/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.filter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SamPairUtil;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;

public class FilteringIterator
implements CloseableIterator<SAMRecord> {
    private final PeekableIterator<SAMRecord> iterator;
    private final SamRecordFilter filter;
    private boolean filterReadPairs = false;
    private SAMRecord next = null;

    public FilteringIterator(Iterator<SAMRecord> iterator, SamRecordFilter filter, boolean filterByPair) {
        if (filterByPair && iterator instanceof SAMRecordIterator) {
            ((SAMRecordIterator)iterator).assertSorted(SAMFileHeader.SortOrder.queryname);
        }
        this.iterator = new PeekableIterator<SAMRecord>(iterator);
        this.filter = filter;
        this.filterReadPairs = filterByPair;
        this.next = this.getNextRecord();
    }

    public FilteringIterator(Iterator<SAMRecord> iterator, SamRecordFilter filter) {
        this.iterator = new PeekableIterator<SAMRecord>(iterator);
        this.filter = filter;
        this.next = this.getNextRecord();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public SAMRecord next() {
        if (this.next == null) {
            throw new NoSuchElementException("Iterator has no more elements.");
        }
        SAMRecord result = this.next;
        this.next = this.getNextRecord();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove() not supported by FilteringIterator");
    }

    @Override
    public void close() {
        CloserUtil.close(this.iterator);
    }

    private SAMRecord getNextRecord() {
        while (this.iterator.hasNext()) {
            SAMRecord record = this.iterator.next();
            if (this.filterReadPairs && record.getReadPairedFlag() && record.getFirstOfPairFlag() && this.iterator.hasNext()) {
                SamPairUtil.assertMate(record, this.iterator.peek());
                if (this.filter.filterOut(record, this.iterator.peek())) {
                    this.iterator.next();
                    continue;
                }
                return record;
            }
            if (this.filterReadPairs && record.getReadPairedFlag() && record.getSecondOfPairFlag()) {
                return record;
            }
            if (this.filter.filterOut(record)) continue;
            return record;
        }
        return null;
    }
}

