/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.util.List;
import net.sf.picard.fastq.IlluminaReadNameEncoder;
import net.sf.picard.fastq.ReadNameEncoder;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.filter.SolexaNoiseFilter;
import net.sf.picard.illumina.IlluminaBasecallsConverter;
import net.sf.picard.illumina.IlluminaBasecallsToSam;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.ReadData;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.util.AdapterMarker;
import net.sf.picard.util.AdapterPair;
import net.sf.picard.util.IlluminaUtil;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTag;

public class ClusterDataToSamConverter
implements IlluminaBasecallsConverter.ClusterDataConverter<IlluminaBasecallsToSam.SAMRecordsForCluster> {
    private final String runBarcode;
    private final String readGroupId;
    private final SamRecordFilter filters = new SolexaNoiseFilter();
    private final boolean isPairedEnd;
    private final boolean isBarcoded;
    private final int[] templateIndices;
    private final int[] barcodeIndices;
    private final AdapterMarker adapterMarker;
    private final int outputRecordsPerCluster;
    private final ReadNameEncoder readNameEncoder;

    public ClusterDataToSamConverter(String runBarcode, String readGroupId, ReadStructure readStructure, List<IlluminaUtil.IlluminaAdapterPair> adapters) {
        this.runBarcode = runBarcode;
        this.readGroupId = readGroupId;
        this.readNameEncoder = new IlluminaReadNameEncoder(runBarcode);
        this.isPairedEnd = readStructure.templates.length() == 2;
        this.isBarcoded = !readStructure.barcodes.isEmpty();
        this.adapterMarker = adapters.isEmpty() ? null : new AdapterMarker(adapters.toArray(new AdapterPair[adapters.size()]));
        this.templateIndices = readStructure.templates.getIndices();
        this.barcodeIndices = readStructure.barcodes.getIndices();
        this.outputRecordsPerCluster = readStructure.templates.length();
    }

    private SAMRecord createSamRecord(ReadData readData, String readName, boolean isPf, boolean firstOfPair, String unmatchedBarcode) {
        SAMRecord sam = new SAMRecord(null);
        sam.setReadName(readName);
        sam.setReadBases(readData.getBases());
        sam.setBaseQualities(readData.getQualities());
        sam.setReadPairedFlag(this.isPairedEnd);
        sam.setReadUnmappedFlag(true);
        sam.setReadFailsVendorQualityCheckFlag(!isPf);
        if (this.isPairedEnd) {
            sam.setMateUnmappedFlag(true);
            sam.setFirstOfPairFlag(firstOfPair);
            sam.setSecondOfPairFlag(!firstOfPair);
        }
        if (this.filters.filterOut(sam)) {
            sam.setAttribute("XN", (Object)1);
        }
        if (this.readGroupId != null) {
            sam.setAttribute(SAMTag.RG.name(), (Object)this.readGroupId);
        }
        if (unmatchedBarcode != null) {
            sam.setAttribute(SAMTag.BC.name(), (Object)unmatchedBarcode);
        }
        return sam;
    }

    @Override
    public IlluminaBasecallsToSam.SAMRecordsForCluster convertClusterToOutputRecord(ClusterData cluster) {
        SAMRecord firstOfPair;
        IlluminaBasecallsToSam.SAMRecordsForCluster ret = new IlluminaBasecallsToSam.SAMRecordsForCluster(this.outputRecordsPerCluster);
        String readName = this.readNameEncoder.generateReadName(cluster, null);
        String unmatchedBarcode = null;
        if (this.isBarcoded && cluster.getMatchedBarcode() == null) {
            byte[][] barcode = new byte[this.barcodeIndices.length][];
            for (int i = 0; i < this.barcodeIndices.length; ++i) {
                barcode[i] = cluster.getRead(this.barcodeIndices[i]).getBases();
            }
            unmatchedBarcode = IlluminaUtil.barcodeSeqsToString(barcode).replace('.', 'N');
        }
        ret.records[0] = firstOfPair = this.createSamRecord(cluster.getRead(this.templateIndices[0]), readName, cluster.isPf(), true, unmatchedBarcode);
        SAMRecord secondOfPair = null;
        if (this.isPairedEnd) {
            ret.records[1] = secondOfPair = this.createSamRecord(cluster.getRead(this.templateIndices[1]), readName, cluster.isPf(), false, unmatchedBarcode);
        }
        if (this.adapterMarker != null) {
            if (this.isPairedEnd) {
                this.adapterMarker.adapterTrimIlluminaPairedReads(firstOfPair, secondOfPair);
            } else {
                this.adapterMarker.adapterTrimIlluminaSingleRead(firstOfPair);
            }
        }
        return ret;
    }
}

