/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.FourChannelIntensityData;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaIntensityParser;
import net.sf.picard.illumina.parser.IntensityChannel;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.RawIntensityData;
import net.sf.samtools.util.CollectionUtil;

class CifParser
extends IlluminaIntensityParser<RawIntensityData> {
    private static final Set<IlluminaDataType> SupportedTypes = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.RawIntensities));

    public CifParser(File directory, int lane, CycleIlluminaFileMap tilesToCycleFiles, OutputMapping outputMapping) {
        super(directory, lane, tilesToCycleFiles, outputMapping);
    }

    @Override
    protected void addIntensityToIlluminaData(RawIntensityData rawIntensityData, OutputMapping.TwoDIndex index, IntensityChannel channel, short intensity) {
        rawIntensityData.getRawIntensities()[index.majorIndex].getChannel((IntensityChannel)channel)[index.minorIndex] = intensity;
    }

    @Override
    protected RawIntensityData intensityToIlluminaData(final FourChannelIntensityData[] fcids) {
        return new RawIntensityData(){

            @Override
            public FourChannelIntensityData[] getRawIntensities() {
                return fcids;
            }
        };
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SupportedTypes;
    }
}

