/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.BclParser;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.TileIndex;
import net.sf.picard.illumina.parser.readers.BclIndexReader;
import net.sf.picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import net.sf.picard.illumina.parser.readers.BclReader;
import net.sf.samtools.util.CloseableIterator;

public class MultiTileBclParser
extends BclParser {
    private final TileIndex tileIndex;

    public MultiTileBclParser(File directory, int lane, CycleIlluminaFileMap tilesToCycleFiles, OutputMapping outputMapping, boolean applyEamssFilter, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, TileIndex tileIndex) {
        super(directory, lane, tilesToCycleFiles, outputMapping, applyEamssFilter, bclQualityEvaluationStrategy);
        this.tileIndex = tileIndex;
        super.initialize();
    }

    @Override
    protected void initialize() {
    }

    @Override
    protected CloseableIterator<BclReader.BclValue> makeReader(File file, int cycle, int tileNumber) {
        TileIndex.TileIndexRecord tileIndexRecord = this.tileIndex.findTile(tileNumber);
        BclIndexReader bclIndexReader = new BclIndexReader(file);
        if (this.tileIndex.getNumTiles() != bclIndexReader.getNumTiles()) {
            throw new PicardException(String.format("%s.getNumTiles(%d) != %s.getNumTiles(%d)", this.tileIndex.getFile().getAbsolutePath(), this.tileIndex.getNumTiles(), bclIndexReader.getBciFile().getAbsolutePath(), bclIndexReader.getNumTiles()));
        }
        BclReader bclReader = BclReader.makeSeekable(file, this.bclQualityEvaluationStrategy);
        bclReader.seek(bclIndexReader.get(tileIndexRecord.zeroBasedTileNumber));
        return new CountLimitedIterator(bclReader, tileIndexRecord.numClustersInTile);
    }

    static class CountLimitedIterator
    implements CloseableIterator<BclReader.BclValue> {
        private final CloseableIterator<BclReader.BclValue> underlyingIterator;
        private final int recordLimit;
        private int numRecordsRead = 0;

        CountLimitedIterator(CloseableIterator<BclReader.BclValue> underlyingIterator, int recordLimit) {
            this.underlyingIterator = underlyingIterator;
            this.recordLimit = recordLimit;
        }

        @Override
        public void close() {
            this.underlyingIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.numRecordsRead < this.recordLimit && this.underlyingIterator.hasNext();
        }

        @Override
        public BclReader.BclValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.numRecordsRead;
            return (BclReader.BclValue)this.underlyingIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

