/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.BinaryFileIterator;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.util.CloserUtil;

public class MMapBackedIteratorFactory {
    private static int BYTE_SIZE = 1;
    private static int INT_SIZE = 4;
    private static int FLOAT_SIZE = 4;
    private static int LONG_SIZE = 8;

    public static BinaryFileIterator<Integer> getIntegerIterator(int headerSize, File binaryFile) {
        MMapBackedIteratorFactory.checkFactoryVars(headerSize, binaryFile);
        ByteBuffer buf = MMapBackedIteratorFactory.getBuffer(binaryFile);
        byte[] header = MMapBackedIteratorFactory.getHeader(buf, headerSize);
        return new IntegerMMapIterator(header, binaryFile, buf);
    }

    public static BinaryFileIterator<Byte> getByteIterator(int headerSize, File binaryFile) {
        MMapBackedIteratorFactory.checkFactoryVars(headerSize, binaryFile);
        ByteBuffer buf = MMapBackedIteratorFactory.getBuffer(binaryFile);
        byte[] header = MMapBackedIteratorFactory.getHeader(buf, headerSize);
        return new ByteMMapIterator(header, binaryFile, buf);
    }

    public static BinaryFileIterator<Float> getFloatIterator(int headerSize, File binaryFile) {
        MMapBackedIteratorFactory.checkFactoryVars(headerSize, binaryFile);
        ByteBuffer buf = MMapBackedIteratorFactory.getBuffer(binaryFile);
        byte[] header = MMapBackedIteratorFactory.getHeader(buf, headerSize);
        return new FloatMMapIterator(header, binaryFile, buf);
    }

    public static BinaryFileIterator<Long> getLongIterator(int headerSize, File binaryFile) {
        MMapBackedIteratorFactory.checkFactoryVars(headerSize, binaryFile);
        ByteBuffer buf = MMapBackedIteratorFactory.getBuffer(binaryFile);
        byte[] header = MMapBackedIteratorFactory.getHeader(buf, headerSize);
        return new LongMMapIterator(header, binaryFile, buf);
    }

    public static BinaryFileIterator<ByteBuffer> getByteBufferIterator(int headerSize, int elementSize, File binaryFile) {
        MMapBackedIteratorFactory.checkFactoryVars(headerSize, binaryFile);
        ByteBuffer buf = MMapBackedIteratorFactory.getBuffer(binaryFile);
        byte[] header = MMapBackedIteratorFactory.getHeader(buf, headerSize);
        return new ByteBufferMMapIterator(header, binaryFile, elementSize, buf);
    }

    private static void checkFactoryVars(int headerSize, File binaryFile) {
        IoUtil.assertFileIsReadable(binaryFile);
        if (headerSize < 0) {
            throw new PicardException("Header size cannot be negative.  HeaderSize(" + headerSize + ") for file " + binaryFile.getAbsolutePath());
        }
        if ((long)headerSize > binaryFile.length()) {
            throw new PicardException("Header size(" + headerSize + ") is greater than file size(" + binaryFile.length() + ") for file " + binaryFile.getAbsolutePath());
        }
    }

    private static ByteBuffer getBuffer(File binaryFile) {
        MappedByteBuffer buf;
        try {
            FileInputStream is = new FileInputStream(binaryFile);
            FileChannel channel = is.getChannel();
            long fileSize = channel.size();
            buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            CloserUtil.close(channel);
            CloserUtil.close(is);
        }
        catch (IOException e) {
            throw new PicardException("IOException opening cluster binary file " + binaryFile, e);
        }
        return buf;
    }

    private static byte[] getHeader(ByteBuffer buf, int headerSize) {
        byte[] headerBytes = new byte[headerSize];
        if (headerSize > 0) {
            buf.get(headerBytes);
        }
        return headerBytes;
    }

    private static class ByteBufferMMapIterator
    extends MMapBackedIterator<ByteBuffer> {
        private byte[] localBacking;
        private ByteBuffer localBuffer;

        public ByteBufferMMapIterator(byte[] header, File file, int elementBufferSize, ByteBuffer buf) {
            super(header, file, elementBufferSize, buf);
            this.localBacking = new byte[elementBufferSize];
            this.localBuffer = ByteBuffer.wrap(this.localBacking);
            this.localBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        protected ByteBuffer getElement() {
            this.localBuffer.position(0);
            this.buffer.get(this.localBacking);
            this.localBuffer.position(0);
            return this.localBuffer;
        }
    }

    private static class LongMMapIterator
    extends MMapBackedIterator<Long> {
        public LongMMapIterator(byte[] header, File file, ByteBuffer buf) {
            super(header, file, LONG_SIZE, buf);
        }

        @Override
        protected Long getElement() {
            return this.buffer.getLong();
        }
    }

    private static class FloatMMapIterator
    extends MMapBackedIterator<Float> {
        public FloatMMapIterator(byte[] header, File file, ByteBuffer buf) {
            super(header, file, FLOAT_SIZE, buf);
        }

        @Override
        protected Float getElement() {
            return Float.valueOf(this.buffer.getFloat());
        }
    }

    private static class ByteMMapIterator
    extends MMapBackedIterator<Byte> {
        public ByteMMapIterator(byte[] header, File file, ByteBuffer buf) {
            super(header, file, BYTE_SIZE, buf);
        }

        @Override
        protected Byte getElement() {
            return this.buffer.get();
        }
    }

    private static class IntegerMMapIterator
    extends MMapBackedIterator<Integer> {
        public IntegerMMapIterator(byte[] header, File file, ByteBuffer buf) {
            super(header, file, INT_SIZE, buf);
        }

        @Override
        protected Integer getElement() {
            return this.buffer.getInt();
        }
    }

    static abstract class MMapBackedIterator<TYPE>
    extends BinaryFileIterator<TYPE> {
        protected final ByteBuffer buffer;

        protected MMapBackedIterator(byte[] header, File file, int elementSize, ByteBuffer buffer) {
            super(header, file, elementSize);
            this.buffer = buffer;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.limit() - this.buffer.position() >= this.elementSize;
        }

        @Override
        public void skipElements(int numElements) {
            this.buffer.position(this.buffer.position() + numElements * this.elementSize);
        }

        @Override
        protected abstract TYPE getElement();

        @Override
        public Iterator<TYPE> iterator() {
            return this;
        }
    }
}

