/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.BinaryFileIterator;
import net.sf.picard.illumina.parser.readers.MMapBackedIteratorFactory;
import net.sf.picard.util.UnsignedTypeUtil;

public class TileMetricsOutReader
implements Iterator<IlluminaTileMetrics> {
    private static final int HEADER_SIZE = 2;
    private static final int EXPECTED_RECORD_SIZE = 10;
    private static final int EXPECTED_VERSION = 2;
    private final BinaryFileIterator<ByteBuffer> bbIterator;

    public TileMetricsOutReader(File tileMetricsOutFile) {
        this.bbIterator = MMapBackedIteratorFactory.getByteBufferIterator(2, 10, tileMetricsOutFile);
        ByteBuffer header = this.bbIterator.getHeaderBytes();
        int actualVersion = UnsignedTypeUtil.uByteToInt(header.get());
        if (actualVersion != 2) {
            throw new PicardException("TileMetricsOutReader expects the version number to be 2.  Actual Version in Header( " + actualVersion + ")");
        }
        int actualRecordSize = UnsignedTypeUtil.uByteToInt(header.get());
        if (10 != actualRecordSize) {
            throw new PicardException("TileMetricsOutReader expects the record size to be 10.  Actual Record Size in Header( " + actualRecordSize + ")");
        }
    }

    @Override
    public boolean hasNext() {
        return this.bbIterator.hasNext();
    }

    @Override
    public IlluminaTileMetrics next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return new IlluminaTileMetrics(this.bbIterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class IlluminaLaneTileCode {
        private final int laneNumber;
        private final int tileNumber;
        private final int metricCode;

        public IlluminaLaneTileCode(int laneNumber, int tileNumber, int metricCode) {
            this.laneNumber = laneNumber;
            this.tileNumber = tileNumber;
            this.metricCode = metricCode;
        }

        public int getLaneNumber() {
            return this.laneNumber;
        }

        public int getTileNumber() {
            return this.tileNumber;
        }

        public int getMetricCode() {
            return this.metricCode;
        }

        public boolean equals(Object o) {
            if (o instanceof IlluminaLaneTileCode) {
                IlluminaLaneTileCode that = (IlluminaLaneTileCode)o;
                return this.laneNumber == that.laneNumber && this.tileNumber == that.tileNumber && this.metricCode == that.metricCode;
            }
            return false;
        }

        public int hashCode() {
            int result = this.laneNumber;
            result = 31 * result + this.tileNumber;
            result = 31 * result + this.metricCode;
            return result;
        }
    }

    public static class IlluminaTileMetrics {
        private final IlluminaLaneTileCode laneTileCode;
        private final float metricValue;

        public IlluminaTileMetrics(ByteBuffer bb) {
            this(UnsignedTypeUtil.uShortToInt(bb.getShort()), UnsignedTypeUtil.uShortToInt(bb.getShort()), UnsignedTypeUtil.uShortToInt(bb.getShort()), bb.getFloat());
        }

        public IlluminaTileMetrics(int laneNumber, int tileNumber, int metricCode, float metricValue) {
            this.laneTileCode = new IlluminaLaneTileCode(laneNumber, tileNumber, metricCode);
            this.metricValue = metricValue;
        }

        public int getLaneNumber() {
            return this.laneTileCode.getLaneNumber();
        }

        public int getTileNumber() {
            return this.laneTileCode.getTileNumber();
        }

        public int getMetricCode() {
            return this.laneTileCode.getMetricCode();
        }

        public float getMetricValue() {
            return this.metricValue;
        }

        public IlluminaLaneTileCode getLaneTileCode() {
            return this.laneTileCode;
        }

        public boolean equals(Object o) {
            if (o instanceof IlluminaTileMetrics) {
                IlluminaTileMetrics that = (IlluminaTileMetrics)o;
                return this.laneTileCode == that.laneTileCode && this.metricValue == that.metricValue;
            }
            return false;
        }

        public int hashCode() {
            return String.format("%s:%s:%s:%s", this.laneTileCode.getLaneNumber(), this.laneTileCode.getTileNumber(), this.laneTileCode.getMetricCode(), Float.valueOf(this.metricValue)).hashCode();
        }
    }
}

