/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.metrics;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.metrics.MetricBase;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.metrics.PerUnitMetricCollector;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;

public abstract class MultiLevelCollector<METRIC_TYPE extends MetricBase, HISTOGRAM_KEY extends Comparable, ARGTYPE> {
    public static final String UNKNOWN = "unknown";
    private PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> allReadCollector;
    private List<Distributor> outputOrderedDistributors;

    protected abstract ARGTYPE makeArg(SAMRecord var1, ReferenceSequence var2);

    protected abstract PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeChildCollector(String var1, String var2, String var3);

    protected PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeAllReadCollector() {
        return this.makeChildCollector(null, null, null);
    }

    protected PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeSampleCollector(SAMReadGroupRecord rg) {
        return this.makeChildCollector(rg.getSample(), null, null);
    }

    protected PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeLibraryCollector(SAMReadGroupRecord rg) {
        return this.makeChildCollector(rg.getSample(), rg.getLibrary(), null);
    }

    protected PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeReadGroupCollector(SAMReadGroupRecord rg) {
        return this.makeChildCollector(rg.getSample(), rg.getLibrary(), rg.getPlatformUnit());
    }

    protected void setup(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords) {
        this.outputOrderedDistributors = new ArrayList<Distributor>(4);
        if (accumulationLevels.contains((Object)MetricAccumulationLevel.ALL_READS)) {
            this.outputOrderedDistributors.add(new AllReadsDistributor(samRgRecords));
        }
        if (accumulationLevels.contains((Object)MetricAccumulationLevel.SAMPLE)) {
            this.outputOrderedDistributors.add(new SampleDistributor(samRgRecords));
        }
        if (accumulationLevels.contains((Object)MetricAccumulationLevel.LIBRARY)) {
            this.outputOrderedDistributors.add(new LibraryDistributor(samRgRecords));
        }
        if (accumulationLevels.contains((Object)MetricAccumulationLevel.READ_GROUP)) {
            this.outputOrderedDistributors.add(new ReadGroupCollector(samRgRecords));
        }
    }

    public void acceptRecord(SAMRecord record, ReferenceSequence refSeq) {
        ARGTYPE arg = this.makeArg(record, refSeq);
        for (Distributor collector : this.outputOrderedDistributors) {
            collector.acceptRecord(arg, record.getReadGroup());
        }
    }

    public void finish() {
        for (Distributor collector : this.outputOrderedDistributors) {
            collector.finish();
        }
    }

    public PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> getAllReadsCollector() {
        return this.allReadCollector;
    }

    public void addAllLevelsToFile(MetricsFile<METRIC_TYPE, HISTOGRAM_KEY> file) {
        for (Distributor collector : this.outputOrderedDistributors) {
            collector.addToFile(file);
        }
    }

    private class ReadGroupCollector
    extends Distributor {
        public ReadGroupCollector(List<SAMReadGroupRecord> rgRecs) {
            super(rgRecs);
        }

        @Override
        protected String getKey(SAMReadGroupRecord rg) {
            return rg.getPlatformUnit();
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeCollector(SAMReadGroupRecord rg) {
            return MultiLevelCollector.this.makeReadGroupCollector(rg);
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeUnknownCollector() {
            return MultiLevelCollector.this.makeChildCollector(MultiLevelCollector.UNKNOWN, MultiLevelCollector.UNKNOWN, MultiLevelCollector.UNKNOWN);
        }
    }

    private class LibraryDistributor
    extends Distributor {
        public LibraryDistributor(List<SAMReadGroupRecord> rgRecs) {
            super(rgRecs);
        }

        @Override
        protected String getKey(SAMReadGroupRecord rg) {
            return rg.getLibrary();
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeCollector(SAMReadGroupRecord rg) {
            return MultiLevelCollector.this.makeLibraryCollector(rg);
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeUnknownCollector() {
            return MultiLevelCollector.this.makeChildCollector(MultiLevelCollector.UNKNOWN, MultiLevelCollector.UNKNOWN, null);
        }
    }

    private class SampleDistributor
    extends Distributor {
        public SampleDistributor(List<SAMReadGroupRecord> rgRecs) {
            super(rgRecs);
        }

        @Override
        protected String getKey(SAMReadGroupRecord rg) {
            return rg.getSample();
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeCollector(SAMReadGroupRecord rg) {
            return MultiLevelCollector.this.makeSampleCollector(rg);
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeUnknownCollector() {
            return MultiLevelCollector.this.makeChildCollector(MultiLevelCollector.UNKNOWN, null, null);
        }
    }

    private class AllReadsDistributor
    extends Distributor {
        public AllReadsDistributor(List<SAMReadGroupRecord> rgRecs) {
            super(new ArrayList<SAMReadGroupRecord>());
            this.makeCollector(null);
        }

        @Override
        protected String getKey(SAMReadGroupRecord rg) {
            return null;
        }

        @Override
        public void acceptRecord(ARGTYPE args, SAMReadGroupRecord rg) {
            MultiLevelCollector.this.allReadCollector.acceptRecord(args);
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeCollector(SAMReadGroupRecord rg) {
            MultiLevelCollector.this.allReadCollector = MultiLevelCollector.this.makeAllReadCollector();
            return MultiLevelCollector.this.allReadCollector;
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeUnknownCollector() {
            throw new UnsupportedOperationException("Should not happen");
        }

        @Override
        public void finish() {
            MultiLevelCollector.this.allReadCollector.finish();
        }

        @Override
        public void addToFile(MetricsFile<METRIC_TYPE, HISTOGRAM_KEY> file) {
            MultiLevelCollector.this.allReadCollector.addMetricsToFile(file);
        }
    }

    private abstract class Distributor {
        private final Map<String, PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE>> collectors = new LinkedHashMap();

        protected abstract String getKey(SAMReadGroupRecord var1);

        protected abstract PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeCollector(SAMReadGroupRecord var1);

        protected abstract PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE> makeUnknownCollector();

        public Distributor(List<SAMReadGroupRecord> rgRecs) {
            for (SAMReadGroupRecord rg : rgRecs) {
                String key = this.getKey(rg);
                if (this.collectors.containsKey(key)) continue;
                this.collectors.put(key, this.makeCollector(rg));
            }
        }

        public void finish() {
            for (PerUnitMetricCollector collector : this.collectors.values()) {
                collector.finish();
            }
        }

        public void acceptRecord(ARGTYPE args, SAMReadGroupRecord rg) {
            PerUnitMetricCollector collector;
            String computedKey;
            String key = MultiLevelCollector.UNKNOWN;
            if (rg != null && (computedKey = this.getKey(rg)) != null) {
                key = computedKey;
            }
            if ((collector = this.collectors.get(key)) == null) {
                if (!MultiLevelCollector.UNKNOWN.equals(key)) {
                    throw new PicardException("Could not find collector for " + key);
                }
                collector = this.makeUnknownCollector();
                this.collectors.put(key, collector);
            }
            collector.acceptRecord(args);
        }

        public void addToFile(MetricsFile<METRIC_TYPE, HISTOGRAM_KEY> file) {
            for (PerUnitMetricCollector collector : this.collectors.values()) {
                collector.addMetricsToFile(file);
            }
        }
    }
}

