/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFFileReader;
import org.broadinstitute.variant.vcf.VCFHeader;

public class MakeSitesOnlyVcf
extends CommandLineProgram {
    @Usage
    public final String usage = "Reads a VCF/VCF.gz/BCF and removes all genotype information from it while retaining all site level information, including annotations based on genotypes (e.g. AN, AF). Output an be any support variant format including .vcf, .vcf.gz or .bcf.";
    @Option(shortName="I", doc="Input VCF or BCF")
    public File INPUT;
    @Option(shortName="O", doc="Output VCF or BCF to emit without per-sample info.")
    public File OUTPUT;
    @Option(shortName="S", doc="Optionally one or more samples to retain when building the 'sites-only' VCF.", optional=true)
    public Set<String> SAMPLE = new TreeSet<String>();

    public static void main(String[] args) {
        new MakeSitesOnlyVcf().instanceMainWithExit(args);
    }

    public MakeSitesOnlyVcf() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        VCFFileReader reader = new VCFFileReader(this.INPUT, false);
        VCFHeader inputVcfHeader = new VCFHeader(reader.getFileHeader().getMetaDataInInputOrder());
        SAMSequenceDictionary sequenceDictionary = inputVcfHeader.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        ProgressLogger progress = new ProgressLogger(Log.getInstance(MakeSitesOnlyVcf.class), 10000);
        EnumSet<Options> options = EnumSet.copyOf(VariantContextWriterFactory.DEFAULT_OPTIONS);
        if (this.CREATE_INDEX.booleanValue()) {
            options.add(Options.INDEX_ON_THE_FLY);
        } else {
            options.remove(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter writer = VariantContextWriterFactory.create((File)this.OUTPUT, (SAMSequenceDictionary)sequenceDictionary, options);
        VCFHeader header = new VCFHeader(inputVcfHeader.getMetaDataInInputOrder(), this.SAMPLE);
        writer.writeHeader(header);
        CloseableIterator iterator = reader.iterator();
        while (iterator.hasNext()) {
            VariantContext full = (VariantContext)iterator.next();
            VariantContext site = MakeSitesOnlyVcf.subsetToSamplesWithOriginalAnnotations(full, this.SAMPLE);
            writer.add(site);
            progress.record(site.getChr(), site.getStart());
        }
        CloserUtil.close(iterator);
        CloserUtil.close(reader);
        writer.close();
        return 0;
    }

    private static VariantContext subsetToSamplesWithOriginalAnnotations(VariantContext ctx, Set<String> samples) {
        VariantContextBuilder builder = new VariantContextBuilder(ctx);
        GenotypesContext newGenotypes = ctx.getGenotypes().subsetToSamples(samples);
        builder.alleles((Collection)ctx.getAlleles());
        return builder.genotypes(newGenotypes).make();
    }
}

