/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

public class Lazy<T> {
    private final LazyInitializer<T> initializer;
    private boolean isInitialized = false;
    private T instance;

    public Lazy(LazyInitializer<T> initializer) {
        this.initializer = initializer;
    }

    public synchronized T get() {
        if (!this.isInitialized) {
            this.instance = this.initializer.make();
            this.isInitialized = true;
        }
        return this.instance;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public static interface LazyInitializer<T> {
        public T make();
    }
}

