/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment;

import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.alignment.SimpleSubstitutionMatrix;
import org.biojava.nbio.alignment.aaindex.AAindexFactory;
import org.biojava.nbio.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.compound.AmbiguityDNACompoundSet;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;

public class SubstitutionMatrixHelper {
    private static Map<String, SubstitutionMatrix<AminoAcidCompound>> aminoAcidMatrices = new HashMap<String, SubstitutionMatrix<AminoAcidCompound>>();
    private static Map<String, SubstitutionMatrix<NucleotideCompound>> nucleotideMatrices = new HashMap<String, SubstitutionMatrix<NucleotideCompound>>();

    private SubstitutionMatrixHelper() {
    }

    public static SubstitutionMatrix<AminoAcidCompound> getMatrixFromAAINDEX(String matrixName) {
        return AAindexFactory.getAAIndexProvider().getMatrix(matrixName);
    }

    public static SubstitutionMatrix<AminoAcidCompound> getIdentity() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("identity");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum100() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum100");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum30() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum30");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum35() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum35");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum40() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum40");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum45() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum45");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum50() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum50");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum55() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum55");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum60() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum60");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum62() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum62");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum65() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum65");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum70() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum70");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum75() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum75");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum80() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum80");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum85() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum85");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum90() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("blosum90");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getGonnet250() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("gonnet250");
    }

    public static SubstitutionMatrix<NucleotideCompound> getNuc4_2() {
        return SubstitutionMatrixHelper.getNucleotideMatrix("nuc-4_2");
    }

    public static SubstitutionMatrix<NucleotideCompound> getNuc4_4() {
        return SubstitutionMatrixHelper.getNucleotideMatrix("nuc-4_4");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getPAM250() {
        return SubstitutionMatrixHelper.getAminoAcidMatrix("pam250");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getAminoAcidSubstitutionMatrix(String name) {
        SubstitutionMatrix<AminoAcidCompound> matrix = SubstitutionMatrixHelper.getMatrixFromAAINDEX(name);
        if (matrix != null) {
            return matrix;
        }
        return SubstitutionMatrixHelper.getAminoAcidMatrix(name);
    }

    private static SubstitutionMatrix<AminoAcidCompound> getAminoAcidMatrix(String file) {
        if (!aminoAcidMatrices.containsKey(file)) {
            aminoAcidMatrices.put(file, new SimpleSubstitutionMatrix<AminoAcidCompound>(AminoAcidCompoundSet.getAminoAcidCompoundSet(), SubstitutionMatrixHelper.getReader(file), file));
        }
        return aminoAcidMatrices.get(file);
    }

    private static SubstitutionMatrix<NucleotideCompound> getNucleotideMatrix(String file) {
        if (!nucleotideMatrices.containsKey(file)) {
            nucleotideMatrices.put(file, new SimpleSubstitutionMatrix<NucleotideCompound>(AmbiguityDNACompoundSet.getDNACompoundSet(), SubstitutionMatrixHelper.getReader(file), file));
        }
        return nucleotideMatrices.get(file);
    }

    private static InputStreamReader getReader(String file) {
        return new InputStreamReader(SubstitutionMatrixHelper.class.getResourceAsStream(String.format("/%s.txt", file)));
    }
}

