/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biojava.nbio.alignment.routines.AlignerHelper;
import org.biojava.nbio.alignment.template.AbstractScorer;
import org.biojava.nbio.alignment.template.AlignedSequence;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.MatrixAligner;
import org.biojava.nbio.alignment.template.Profile;
import org.biojava.nbio.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;

public abstract class AbstractMatrixAligner<S extends Sequence<C>, C extends Compound>
extends AbstractScorer
implements MatrixAligner<S, C> {
    protected GapPenalty gapPenalty;
    private SubstitutionMatrix<C> subMatrix;
    private boolean local;
    private boolean storingScoreMatrix;
    protected List<AlignerHelper.Anchor> anchors = new ArrayList<AlignerHelper.Anchor>();
    protected int cutsPerSection;
    protected Profile<S, C> profile;
    protected int[] xyStart;
    protected int[] xyMax;
    protected int max;
    protected int min;
    protected int score;
    protected int[][][] scores;
    private String[] types;
    protected long time = -1L;

    protected AbstractMatrixAligner() {
    }

    protected AbstractMatrixAligner(GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        this(gapPenalty, subMatrix, false);
    }

    protected AbstractMatrixAligner(GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix, boolean local) {
        this.gapPenalty = gapPenalty;
        this.subMatrix = subMatrix;
        this.local = local;
        this.reset();
    }

    public GapPenalty getGapPenalty() {
        return this.gapPenalty;
    }

    public SubstitutionMatrix<C> getSubstitutionMatrix() {
        return this.subMatrix;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isStoringScoreMatrix() {
        return this.storingScoreMatrix;
    }

    public void setGapPenalty(GapPenalty gapPenalty) {
        this.gapPenalty = gapPenalty;
        this.reset();
    }

    public void setSubstitutionMatrix(SubstitutionMatrix<C> subMatrix) {
        this.subMatrix = subMatrix;
        this.reset();
    }

    public void setStoringScoreMatrix(boolean storingScoreMatrix) {
        this.storingScoreMatrix = storingScoreMatrix;
        if (!storingScoreMatrix) {
            this.scores = null;
        }
    }

    @Override
    public int[][][] getScoreMatrix() {
        boolean tempStoringScoreMatrix = this.storingScoreMatrix;
        if (this.scores == null) {
            this.storingScoreMatrix = true;
            this.align();
            if (this.scores == null) {
                return null;
            }
        }
        int[][][] copy = this.scores;
        if (tempStoringScoreMatrix) {
            copy = new int[this.scores.length][this.scores[0].length][];
            for (int i = 0; i < copy.length; ++i) {
                for (int j = 0; j < copy[0].length; ++j) {
                    copy[i][j] = Arrays.copyOf(this.scores[i][j], this.scores[i][j].length);
                }
            }
        }
        this.setStoringScoreMatrix(tempStoringScoreMatrix);
        return copy;
    }

    @Override
    public String getScoreMatrixAsString() {
        int[][][] scores = this.getScoreMatrix();
        return this.scoreMatrixToString(scores);
    }

    private String scoreMatrixToString(int[][][] scores) {
        StringBuilder s = new StringBuilder();
        CompoundSet<Compound> compoundSet = this.getCompoundSet();
        int lengthCompound = compoundSet.getMaxSingleCompoundStringLength();
        int lengthRest = Math.max(Math.max(Integer.toString(this.min).length(), Integer.toString(this.max).length()), lengthCompound) + 1;
        String padCompound = "%" + Integer.toString(lengthCompound) + "s";
        String padRest = "%" + Integer.toString(lengthRest);
        List<C> query = this.getCompoundsOfQuery();
        List<C> target = this.getCompoundsOfTarget();
        for (int type = 0; type < scores[0][0].length; ++type) {
            if (type > 0) {
                s.append(String.format("%n", new Object[0]));
            }
            if (this.types[type] != null) {
                s.append(String.format("%s%n", this.types[type]));
            }
            s.append(String.format(padCompound, ""));
            s.append(String.format(padRest + "s", ""));
            for (Compound col : target) {
                s.append(String.format(padRest + "s", compoundSet.getStringForCompound(col)));
            }
            s.append(String.format("%n", new Object[0]));
            for (int x = 0; x < scores.length; ++x) {
                s.append(String.format(padCompound, x == 0 ? "" : compoundSet.getStringForCompound((Compound)query.get(x - 1))));
                for (int y = 0; y < scores[0].length; ++y) {
                    s.append(scores[x][y][type] >= this.min ? String.format(padRest + "d", scores[x][y][type]) : String.format(padRest + "s", "-\u221e"));
                }
                s.append(String.format("%n", new Object[0]));
            }
        }
        return s.toString();
    }

    @Override
    public long getComputationTime() {
        if (this.profile == null) {
            this.align();
        }
        return this.time;
    }

    @Override
    public Profile<S, C> getProfile() {
        if (this.profile == null) {
            this.align();
        }
        return this.profile;
    }

    @Override
    public double getMaxScore() {
        if (this.profile == null) {
            this.align();
        }
        return this.max;
    }

    @Override
    public double getMinScore() {
        if (this.profile == null) {
            this.align();
        }
        return this.min;
    }

    @Override
    public double getScore() {
        if (this.profile == null) {
            this.align();
        }
        return this.score;
    }

    protected void align() {
        if (!this.isReady()) {
            return;
        }
        long timeStart = System.nanoTime();
        int[] dim = this.getScoreMatrixDimensions();
        if (this.storingScoreMatrix) {
            this.scores = new int[dim[0]][dim[1]][dim[2]];
        } else {
            this.scores = new int[dim[0]][][];
            this.scores[0] = new int[dim[1]][dim[2]];
            this.scores[1] = new int[dim[1]][dim[2]];
        }
        boolean linear = this.gapPenalty.getType() == GapPenalty.Type.LINEAR;
        AlignerHelper.Last[][][] traceback = new AlignerHelper.Last[dim[0]][][];
        ArrayList<AlignedSequence.Step> sx = new ArrayList<AlignedSequence.Step>();
        ArrayList<AlignedSequence.Step> sy = new ArrayList<AlignedSequence.Step>();
        if (!this.local) {
            this.xyMax = new int[]{dim[0] - 1, dim[1] - 1};
            this.xyStart = new int[]{0, 0};
            this.score = 0;
            List<AlignerHelper.Subproblem> problems = AlignerHelper.Subproblem.getSubproblems(this.anchors, this.xyMax[0], this.xyMax[1]);
            assert (problems.size() == this.anchors.size() + 1);
            for (int i = 0; i < problems.size(); ++i) {
                AlignerHelper.Subproblem subproblem = problems.get(i);
                for (int x = subproblem.getQueryStartIndex(); x <= subproblem.getQueryEndIndex(); ++x) {
                    traceback[x] = linear ? AlignerHelper.setScoreVector(x, subproblem, this.gapPenalty.getExtensionPenalty(), this.getSubstitutionScoreVector(x, subproblem), this.storingScoreMatrix, this.scores) : AlignerHelper.setScoreVector(x, subproblem, this.gapPenalty.getOpenPenalty(), this.gapPenalty.getExtensionPenalty(), this.getSubstitutionScoreVector(x, subproblem), this.storingScoreMatrix, this.scores);
                }
            }
            AlignerHelper.setSteps(traceback, this.scores, sx, sy);
            this.score = Integer.MIN_VALUE;
            int[] finalScore = this.scores[this.xyMax[0]][this.xyMax[1]];
            for (int z = 0; z < finalScore.length; ++z) {
                this.score = Math.max(this.score, finalScore[z]);
            }
        } else {
            for (int x = 0; x < dim[0]; ++x) {
                AlignerHelper.Last[][] lastArray = traceback[x] = linear ? AlignerHelper.setScoreVector(x, this.gapPenalty.getExtensionPenalty(), this.getSubstitutionScoreVector(x), this.storingScoreMatrix, this.scores, this.xyMax, this.score) : AlignerHelper.setScoreVector(x, this.gapPenalty.getOpenPenalty(), this.gapPenalty.getExtensionPenalty(), this.getSubstitutionScoreVector(x), this.storingScoreMatrix, this.scores, this.xyMax, this.score);
                if (this.xyMax[0] != x) continue;
                this.score = this.scores[x][this.xyMax[1]][0];
            }
            this.xyStart = this.local ? AlignerHelper.setSteps(traceback, this.xyMax, sx, sy) : AlignerHelper.setSteps(traceback, this.scores, sx, sy);
        }
        this.setProfile(sx, sy);
        if (!this.storingScoreMatrix) {
            this.scores = null;
        }
        this.time = System.nanoTime() - timeStart;
    }

    protected int[] getSubstitutionScoreVector(int queryColumn) {
        return this.getSubstitutionScoreVector(queryColumn, new AlignerHelper.Subproblem(0, 0, this.scores.length - 1, this.scores[0].length - 1));
    }

    protected int[] getSubstitutionScoreVector(int queryColumn, AlignerHelper.Subproblem subproblem) {
        int[] subs = new int[subproblem.getTargetEndIndex() + 1];
        if (queryColumn > 0) {
            for (int y = Math.max(1, subproblem.getTargetStartIndex()); y <= subproblem.getTargetEndIndex(); ++y) {
                subs[y] = this.getSubstitutionScore(queryColumn, y);
            }
        }
        return subs;
    }

    protected void reset() {
        String[] stringArray;
        this.xyMax = new int[]{0, 0};
        this.xyStart = new int[]{0, 0};
        this.scores = null;
        if (this.gapPenalty == null || this.gapPenalty.getType() == GapPenalty.Type.LINEAR) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = null;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "Substitution";
            stringArray3[1] = "Deletion";
            stringArray = stringArray3;
            stringArray3[2] = "Insertion";
        }
        this.types = stringArray;
        this.time = -1L;
        this.profile = null;
    }

    protected abstract CompoundSet<C> getCompoundSet();

    protected abstract List<C> getCompoundsOfQuery();

    protected abstract List<C> getCompoundsOfTarget();

    protected abstract int[] getScoreMatrixDimensions();

    protected abstract int getSubstitutionScore(int var1, int var2);

    protected abstract boolean isReady();

    protected abstract void setProfile(List<AlignedSequence.Step> var1, List<AlignedSequence.Step> var2);
}

