/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.io.ProteinSequenceCreator;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.ProxySequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasePreservingProteinSequenceCreator
extends ProteinSequenceCreator {
    private static final Logger logger = LoggerFactory.getLogger(CasePreservingProteinSequenceCreator.class);

    public CasePreservingProteinSequenceCreator(CompoundSet<AminoAcidCompound> compoundSet) {
        super(compoundSet);
    }

    @Override
    public AbstractSequence<AminoAcidCompound> getSequence(ProxySequenceReader<AminoAcidCompound> proxyLoader, long index) {
        AbstractSequence<AminoAcidCompound> seq = super.getSequence(proxyLoader, index);
        seq.setUserCollection(CasePreservingProteinSequenceCreator.getStringCase(proxyLoader.getSequenceAsString()));
        return seq;
    }

    @Override
    public AbstractSequence<AminoAcidCompound> getSequence(String sequence, long index) throws CompoundNotFoundException {
        AbstractSequence<AminoAcidCompound> seq = super.getSequence(sequence.toUpperCase(Locale.ENGLISH), index);
        seq.setUserCollection(CasePreservingProteinSequenceCreator.getStringCase(sequence));
        return seq;
    }

    @Override
    public AbstractSequence<AminoAcidCompound> getSequence(List<AminoAcidCompound> list) {
        AbstractSequence<AminoAcidCompound> seq = super.getSequence(list);
        ArrayList<Object> strCase = new ArrayList<Object>(seq.getLength());
        for (int i = 0; i < seq.getLength(); ++i) {
            strCase.add(true);
        }
        seq.setUserCollection(strCase);
        return seq;
    }

    private static List<Object> getStringCase(String str) {
        ArrayList<Object> types = new ArrayList<Object>(str.length());
        for (int i = 0; i < str.length(); ++i) {
            types.add(Character.isUpperCase(str.charAt(i)));
        }
        return types;
    }

    public static void main(String[] args) throws Exception {
        CasePreservingProteinSequenceCreator creator = new CasePreservingProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet());
        AbstractSequence<AminoAcidCompound> seq = creator.getSequence("aaAA", 0L);
        logger.info("Sequence: {}", (Object)seq.getSequenceAsString());
        logger.info("User Collection: {}", (Object)seq.getUserCollection());
    }

    public static void setLowercaseToNull(ProteinSequence seq, Object[] out) {
        Collection<Object> userCollection = seq.getUserCollection();
        if (userCollection == null) {
            throw new IllegalArgumentException("Sequence doesn't contain valid case info");
        }
        if (userCollection.size() != out.length) {
            throw new IllegalArgumentException("Sequence length doesn't math output array length");
        }
        int pos = 0;
        for (Object isAligned : userCollection) {
            assert (isAligned instanceof Boolean);
            if (!((Boolean)isAligned).booleanValue()) {
                out[pos] = null;
            }
            ++pos;
        }
    }
}

