/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(SoftHashMap.class);
    public static final int DEFAULT_LIMIT = 1;
    private final Map<K, SoftReference<V>> map = new HashMap<K, SoftReference<V>>();
    private final int max_limit;
    private final LinkedList<V> hardCache = new LinkedList();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public SoftHashMap() {
        this(1000);
    }

    public SoftHashMap(int hardSize) {
        this.max_limit = hardSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object result;
        block8: {
            result = null;
            SoftReference<V> soft_ref = this.map.get(key);
            if (soft_ref != null) {
                try {
                    result = soft_ref.get();
                    if (result == null) {
                        this.map.remove(key);
                        break block8;
                    }
                    LinkedList<V> linkedList = this.hardCache;
                    synchronized (linkedList) {
                        this.hardCache.addFirst(result);
                        if (this.hardCache.size() > this.max_limit) {
                            this.hardCache.removeLast();
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Exception: ", e);
                }
            }
        }
        return (V)result;
    }

    private void clearGCCollected() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.map.remove(sv.key);
        }
    }

    @Override
    public synchronized V put(K key, V value) {
        this.clearGCCollected();
        logger.debug("Putting {} on cache. size: {}", (Object)key, (Object)this.size());
        this.map.put(key, new SoftValue(value, key, this.queue));
        return value;
    }

    @Override
    public V remove(Object key) {
        this.clearGCCollected();
        logger.debug("Removing {} from cache. size: {}", key, (Object)this.size());
        return this.map.remove(key).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LinkedList<V> linkedList = this.hardCache;
        synchronized (linkedList) {
            this.hardCache.clear();
        }
        this.clearGCCollected();
        logger.debug("clearing cache");
        this.map.clear();
    }

    @Override
    public int size() {
        this.clearGCCollected();
        return this.map.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class SoftValue<K, V>
    extends SoftReference<V> {
        private final Object key;

        private SoftValue(V k, K key, ReferenceQueue<? super V> q) {
            super(k, q);
            this.key = key;
        }
    }
}

