/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.cytoband;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import org.biojava.nbio.genome.parsers.cytoband.Cytoband;
import org.biojava.nbio.genome.parsers.cytoband.StainType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CytobandParser {
    private static final Logger logger = LoggerFactory.getLogger(CytobandParser.class);
    public static final String DEFAULT_LOCATION = "http://hgdownload.cse.ucsc.edu/goldenPath/hg19/database/cytoBand.txt.gz";

    public static void main(String[] args) {
        CytobandParser me = new CytobandParser();
        try {
            SortedSet<Cytoband> cytobands = me.getAllCytobands(new URL(DEFAULT_LOCATION));
            TreeSet<StainType> types = new TreeSet<StainType>();
            for (Cytoband c : cytobands) {
                logger.info("Cytoband: {}", (Object)c);
                if (types.contains(c.getType())) continue;
                types.add(c.getType());
            }
            logger.info("Strain Type: {}", (Object)types);
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
        }
    }

    public SortedSet<Cytoband> getAllCytobands(URL u) throws IOException {
        GZIPInputStream stream = new GZIPInputStream(u.openStream());
        return this.getAllCytobands(stream);
    }

    public SortedSet<Cytoband> getAllCytobands(InputStream instream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(instream));
        String line = null;
        TreeSet<Cytoband> cytobands = new TreeSet<Cytoband>();
        while ((line = reader.readLine()) != null) {
            String[] spl = line.split("\t");
            if (spl.length != 5) {
                logger.warn("WRONG LINE LENGHT, expected 5, but got {} for: {}", (Object)spl.length, (Object)line);
            }
            Cytoband b = new Cytoband();
            b.setChromosome(spl[0]);
            b.setStart(Integer.parseInt(spl[1]));
            b.setEnd(Integer.parseInt(spl[2]));
            b.setLocus(spl[3]);
            StainType type = StainType.getStainTypeFromString(spl[4]);
            if (type == null) {
                logger.warn("unknown type: {}", (Object)spl[4]);
            }
            b.setType(type);
            cytobands.add(b);
        }
        return cytobands;
    }
}

