/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.gff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.genome.parsers.gff.FeatureI;
import org.biojava.nbio.genome.parsers.gff.Location;

public class FeatureList
extends ArrayList<FeatureI> {
    Map<String, Map<String, List<FeatureI>>> featindex = new HashMap<String, Map<String, List<FeatureI>>>();
    Location mLocation = null;

    public FeatureList() {
    }

    public FeatureList(Collection<FeatureI> features) {
        this();
        this.add(features);
        this.mLocation = null;
    }

    @Override
    public boolean add(FeatureI feature) {
        if (this.mLocation == null) {
            this.mLocation = feature.location().plus();
        } else if (null != feature.location()) {
            this.mLocation = this.mLocation.union(feature.location().plus());
        }
        for (Map.Entry<String, String> entry : feature.getAttributes().entrySet()) {
            List<FeatureI> features;
            if (!this.featindex.containsKey(entry.getKey())) continue;
            Map<String, List<FeatureI>> feat = this.featindex.get(entry.getKey());
            if (feat == null) {
                feat = new HashMap<String, List<FeatureI>>();
            }
            if ((features = feat.get(entry.getValue())) == null) {
                features = new ArrayList<FeatureI>();
            }
            features.add(feature);
            feat.put(entry.getValue(), features);
            this.featindex.put(entry.getKey(), feat);
        }
        return super.add(feature);
    }

    public void add(Collection<FeatureI> list) {
        for (FeatureI f : list) {
            this.add(f);
        }
    }

    public Location bounds() {
        return this.mLocation;
    }

    public boolean hasGaps(int gapLength) {
        Location last = null;
        for (FeatureI f : this) {
            if (last != null && gapLength <= f.location().distance(last)) {
                return true;
            }
            last = f.location();
        }
        return false;
    }

    public String splice(DNASequence sequence) {
        StringBuilder subData = new StringBuilder();
        Location last = null;
        for (FeatureI f : this) {
            Location loc = f.location();
            if (last == null || loc.startsAfter(last)) {
                subData.append(sequence.getSubSequence(loc.start(), loc.end()).toString());
                last = loc;
                continue;
            }
            throw new IllegalStateException("Splice: Feature locations should not overlap.");
        }
        return subData.toString();
    }

    public Collection<String> groupValues() {
        HashSet<String> set = new HashSet<String>();
        for (FeatureI f : this) {
            set.add(f.group());
        }
        return set;
    }

    public Collection<String> attributeValues(String key) {
        if (this.featindex.containsKey(key)) {
            Map<String, List<FeatureI>> map = this.featindex.get(key);
            Set<String> result = map.keySet();
            if (result == null) {
                result = new HashSet<String>();
            }
            return Collections.unmodifiableCollection(result);
        }
        LinkedHashMap hash = new LinkedHashMap();
        for (FeatureI f : this) {
            hash.put(f.getAttribute(key), null);
        }
        return Collections.unmodifiableCollection(hash.keySet());
    }

    public FeatureList selectByGroup(String groupid) {
        FeatureList list = new FeatureList();
        for (FeatureI f : this) {
            if (!f.group().equals(groupid)) continue;
            list.add(f);
        }
        return list;
    }

    public FeatureList selectByType(String type) {
        FeatureList list = new FeatureList();
        for (FeatureI f : this) {
            if (!f.type().equals(type)) continue;
            list.add(f);
        }
        return list;
    }

    public FeatureList selectByAttribute(String key, String value) {
        if (this.featindex.containsKey(key)) {
            Map<String, List<FeatureI>> featuresmap = this.featindex.get(key);
            if (featuresmap == null) {
                return new FeatureList();
            }
            List<FeatureI> list = featuresmap.get(value);
            if (list == null) {
                return new FeatureList();
            }
            return new FeatureList((Collection<FeatureI>)list);
        }
        FeatureList list = new FeatureList();
        for (FeatureI f : this) {
            if (!f.hasAttribute(key, value)) continue;
            list.add(f);
        }
        return list;
    }

    public FeatureList selectByAttribute(String key) {
        Map<String, List<FeatureI>> featsmap;
        FeatureList list = new FeatureList();
        if (this.featindex.containsKey(key) && null != (featsmap = this.featindex.get(key))) {
            for (List<FeatureI> feats : featsmap.values()) {
                list.addAll(Collections.unmodifiableCollection(feats));
            }
            return list;
        }
        for (FeatureI f : this) {
            if (!f.hasAttribute(key)) continue;
            list.add(f);
        }
        return list;
    }

    public FeatureList selectByUserData(String key, Object value) {
        FeatureList list = new FeatureList();
        for (FeatureI f : this) {
            String o = f.userData().get(key);
            if (o == null || !o.equals(value)) continue;
            list.add(f);
        }
        return list;
    }

    public FeatureList selectByUserData(String key) {
        FeatureList list = new FeatureList();
        for (FeatureI f : this) {
            if (!f.userData().containsKey(key)) continue;
            list.add(f);
        }
        return list;
    }

    public FeatureList selectOverlapping(String seqname, Location location, boolean useBothStrands) throws Exception {
        FeatureList list = new FeatureList();
        for (FeatureI feature : this) {
            boolean overlaps = false;
            if (feature.seqname().equals(seqname)) {
                if (location.isSameStrand(feature.location())) {
                    overlaps = feature.location().overlaps(location);
                } else if (useBothStrands) {
                    overlaps = feature.location().overlaps(location.opposite());
                }
            }
            if (!overlaps) continue;
            list.add(feature);
        }
        return list;
    }

    public FeatureList omitOverlapping(String seqname, Location location, boolean useBothStrands) {
        FeatureList list = new FeatureList();
        for (FeatureI feature : this) {
            boolean overlaps = false;
            if (feature.seqname().equals(seqname)) {
                if (location.isSameStrand(feature.location())) {
                    overlaps = feature.location().overlaps(location);
                } else if (useBothStrands) {
                    overlaps = feature.location().overlaps(location.opposite());
                }
            }
            if (overlaps) continue;
            list.add(feature);
        }
        return list;
    }

    public boolean hasAttribute(String key) {
        if (this.featindex.containsKey(key)) {
            Map<String, List<FeatureI>> mappa = this.featindex.get(key);
            return mappa != null && mappa.size() > 0;
        }
        for (FeatureI f : this) {
            if (!f.hasAttribute(key)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(String key, String value) {
        if (this.featindex.containsKey(key)) {
            Map<String, List<FeatureI>> mappa = this.featindex.get(key);
            if (mappa == null) {
                return false;
            }
            return mappa.containsKey(value);
        }
        for (FeatureI f : this) {
            if (!f.hasAttribute(key, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("FeatureList: >>\n");
        for (FeatureI f : this) {
            s.append(f.seqname() + ":" + f.toString() + "\n");
        }
        s.append("\n<<\n");
        return s.toString();
    }

    public FeatureList sortByStart() {
        FeatureI[] array = this.toArray(new FeatureI[1]);
        Arrays.sort(array, new FeatureComparator());
        return new FeatureList((Collection<FeatureI>)Arrays.asList(array));
    }

    @Deprecated
    public static void main(String[] args) {
    }

    public void addIndexes(List<String> indexes) {
        for (String index : indexes) {
            this.addIndex(index);
        }
    }

    public void addIndex(String index) {
        this.featindex.put(index, null);
    }

    private class FeatureComparator
    implements Comparator<FeatureI> {
        private FeatureComparator() {
        }

        @Override
        public int compare(FeatureI a, FeatureI b) {
            if (a.seqname().equals(b.seqname()) && a.location().isSameStrand(b.location())) {
                return a.location().start() - b.location().start();
            }
            throw new IndexOutOfBoundsException("Cannot compare/sort features whose locations are on opposite strands or with different seqname().\r\n" + a.toString() + "\r\n" + b.toString());
        }
    }
}

