/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.phylo;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.biojava.nbio.phylo.ScoreMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResidueProperties {
    private static final Logger logger;
    public static Hashtable<String, ScoreMatrix> scoreMatrices;
    public static final int[] aaIndex;
    public static final int[] nucleotideIndex;
    public static final Hashtable<String, Integer> aa3Hash;
    public static final Hashtable<String, String> aa2Triplet;
    public static final Hashtable<String, String> nucleotideName;
    public static final String[] aa;
    public static final Color midBlue;
    public static final Vector<Color> scaleColours;
    public static final Color[] taylor;
    public static final Color[] nucleotide;
    public static final Color[] zappo;
    public static final double[] hyd2;
    public static final double[] helix;
    public static final double helixmin = 0.57;
    public static final double helixmax = 1.51;
    public static final double[] strand;
    public static final double strandmin = 0.37;
    public static final double strandmax = 1.7;
    public static final double[] turn;
    public static final double turnmin = 0.47;
    public static final double turnmax = 1.56;
    public static final double[] buried;
    public static final double buriedmin = 0.05;
    public static final double buriedmax = 4.6;
    public static final double[] hyd;
    public static final double hydmax = 4.5;
    public static final double hydmin = -3.9;
    private static final int[][] BLOSUM62;
    static final int[][] PAM250;
    public static final Hashtable<String, Color> ssHash;
    static final int[][] DNA;
    public static final Color[] pidColours;
    public static final float[] pidThresholds;
    public static Hashtable<String, Vector<String>> codonHash;
    public static Vector<String> Lys;
    public static Vector<String> Asn;
    public static Vector<String> Gln;
    public static Vector<String> His;
    public static Vector<String> Glu;
    public static Vector<String> Asp;
    public static Vector<String> Tyr;
    public static Vector<String> Thr;
    public static Vector<String> Pro;
    public static Vector<String> Ala;
    public static Vector<String> Ser;
    public static Vector<String> Arg;
    public static Vector<String> Gly;
    public static Vector<String> Trp;
    public static Vector<String> Cys;
    public static Vector<String> Ile;
    public static Vector<String> Met;
    public static Vector<String> Leu;
    public static Vector<String> Val;
    public static Vector<String> Phe;
    public static Vector<String> STOP;
    public static Hashtable<String, String> codonHash2;
    public static Hashtable<String, Hashtable<String, Integer>> propHash;
    public static Hashtable<String, Integer> hydrophobic;
    public static Hashtable<String, Integer> polar;
    public static Hashtable<String, Integer> small;
    public static Hashtable<String, Integer> positive;
    public static Hashtable<String, Integer> negative;
    public static Hashtable<String, Integer> charged;
    public static Hashtable<String, Integer> aromatic;
    public static Hashtable<String, Integer> aliphatic;
    public static Hashtable<String, Integer> tiny;
    public static Hashtable<String, Integer> proline;
    public static Hashtable<String, String> toDssp3State;

    private ResidueProperties() {
    }

    public static double getHydmax() {
        return 4.5;
    }

    public static double getHydmin() {
        return -3.9;
    }

    public static double[] getHyd() {
        return hyd;
    }

    public static Hashtable<String, Integer> getAA3Hash() {
        return aa3Hash;
    }

    public static int[][] getDNA() {
        return DNA;
    }

    public static int[][] getBLOSUM62() {
        return BLOSUM62;
    }

    public static int getPAM250(String A1, String A2) {
        return ResidueProperties.getPAM250(A1.charAt(0), A2.charAt(0));
    }

    public static int getBLOSUM62(char c1, char c2) {
        int pog = 0;
        try {
            int a = aaIndex[c1];
            int b = aaIndex[c2];
            pog = BLOSUM62[a][b];
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
        }
        return pog;
    }

    public static Vector<?> getCodons(String res) {
        if (codonHash.containsKey(res)) {
            return codonHash.get(res);
        }
        return null;
    }

    public static String codonTranslate(String codon) {
        Enumeration<String> e = codonHash.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Vector<String> tmp = codonHash.get(key);
            if (!tmp.contains(codon.toUpperCase())) continue;
            return key;
        }
        return null;
    }

    public static int[][] getDefaultPeptideMatrix() {
        return ResidueProperties.getBLOSUM62();
    }

    public static int[][] getDefaultDnaMatrix() {
        return ResidueProperties.getDNA();
    }

    public static ScoreMatrix getScoreMatrix(String pwtype) {
        ScoreMatrix val = scoreMatrices.get(pwtype);
        if (val != null) {
            return val;
        }
        return null;
    }

    public static int getPAM250(char c, char d) {
        int a = aaIndex[c];
        int b = aaIndex[d];
        int pog = PAM250[a][b];
        return pog;
    }

    public static String getDssp3state(String ssstring) {
        if (ssstring == null) {
            return null;
        }
        StringBuffer ss = new StringBuffer();
        for (int i = 0; i < ssstring.length(); ++i) {
            String ssc = ssstring.substring(i, i + 1);
            if (toDssp3State.containsKey(ssc)) {
                ss.append(toDssp3State.get(ssc));
                continue;
            }
            ss.append(" ");
        }
        return ss.toString();
    }

    public static void main(String[] args) {
        Hashtable aa = new Hashtable();
        logger.info("my %aa = {");
        Enumeration<String> prop = propHash.keys();
        while (prop.hasMoreElements()) {
            String pname = prop.nextElement();
            Hashtable<String, Integer> phash = propHash.get(pname);
            Enumeration<String> res = phash.keys();
            while (res.hasMoreElements()) {
                Integer hasprop;
                String rname = res.nextElement();
                Vector<String> aprops = (Vector<String>)aa.get(rname);
                if (aprops == null) {
                    aprops = new Vector<String>();
                    aa.put(rname, aprops);
                }
                if ((hasprop = phash.get(rname)) != 1) continue;
                aprops.addElement(pname);
            }
        }
        Enumeration res = aa.keys();
        while (res.hasMoreElements()) {
            String rname = (String)res.nextElement();
            logger.info("'{}' => [", (Object)rname);
            Enumeration props = ((Vector)aa.get(rname)).elements();
            while (props.hasMoreElements()) {
                logger.info("'{}'", (Object)((String)props.nextElement()).toString());
            }
            logger.info("]{}", (Object)(res.hasMoreElements() ? "," : ""));
        }
        logger.info("};");
    }

    static {
        int i;
        logger = LoggerFactory.getLogger(ResidueProperties.class);
        scoreMatrices = new Hashtable();
        aa3Hash = new Hashtable();
        aa2Triplet = new Hashtable();
        nucleotideName = new Hashtable();
        aaIndex = new int[255];
        for (i = 0; i < 255; ++i) {
            ResidueProperties.aaIndex[i] = 23;
        }
        ResidueProperties.aaIndex[65] = 0;
        ResidueProperties.aaIndex[82] = 1;
        ResidueProperties.aaIndex[78] = 2;
        ResidueProperties.aaIndex[68] = 3;
        ResidueProperties.aaIndex[67] = 4;
        ResidueProperties.aaIndex[81] = 5;
        ResidueProperties.aaIndex[69] = 6;
        ResidueProperties.aaIndex[71] = 7;
        ResidueProperties.aaIndex[72] = 8;
        ResidueProperties.aaIndex[73] = 9;
        ResidueProperties.aaIndex[76] = 10;
        ResidueProperties.aaIndex[75] = 11;
        ResidueProperties.aaIndex[77] = 12;
        ResidueProperties.aaIndex[70] = 13;
        ResidueProperties.aaIndex[80] = 14;
        ResidueProperties.aaIndex[83] = 15;
        ResidueProperties.aaIndex[84] = 16;
        ResidueProperties.aaIndex[87] = 17;
        ResidueProperties.aaIndex[89] = 18;
        ResidueProperties.aaIndex[86] = 19;
        ResidueProperties.aaIndex[66] = 20;
        ResidueProperties.aaIndex[90] = 21;
        ResidueProperties.aaIndex[88] = 22;
        ResidueProperties.aaIndex[85] = 22;
        ResidueProperties.aaIndex[97] = 0;
        ResidueProperties.aaIndex[114] = 1;
        ResidueProperties.aaIndex[110] = 2;
        ResidueProperties.aaIndex[100] = 3;
        ResidueProperties.aaIndex[99] = 4;
        ResidueProperties.aaIndex[113] = 5;
        ResidueProperties.aaIndex[101] = 6;
        ResidueProperties.aaIndex[103] = 7;
        ResidueProperties.aaIndex[104] = 8;
        ResidueProperties.aaIndex[105] = 9;
        ResidueProperties.aaIndex[108] = 10;
        ResidueProperties.aaIndex[107] = 11;
        ResidueProperties.aaIndex[109] = 12;
        ResidueProperties.aaIndex[102] = 13;
        ResidueProperties.aaIndex[112] = 14;
        ResidueProperties.aaIndex[115] = 15;
        ResidueProperties.aaIndex[116] = 16;
        ResidueProperties.aaIndex[119] = 17;
        ResidueProperties.aaIndex[121] = 18;
        ResidueProperties.aaIndex[118] = 19;
        ResidueProperties.aaIndex[98] = 20;
        ResidueProperties.aaIndex[122] = 21;
        ResidueProperties.aaIndex[120] = 22;
        ResidueProperties.aaIndex[117] = 22;
        nucleotideIndex = new int[255];
        for (i = 0; i < 255; ++i) {
            ResidueProperties.nucleotideIndex[i] = -1;
        }
        ResidueProperties.nucleotideIndex[65] = 0;
        ResidueProperties.nucleotideIndex[97] = 0;
        ResidueProperties.nucleotideIndex[67] = 1;
        ResidueProperties.nucleotideIndex[99] = 1;
        ResidueProperties.nucleotideIndex[71] = 2;
        ResidueProperties.nucleotideIndex[103] = 2;
        ResidueProperties.nucleotideIndex[84] = 3;
        ResidueProperties.nucleotideIndex[116] = 3;
        ResidueProperties.nucleotideIndex[85] = 4;
        ResidueProperties.nucleotideIndex[117] = 4;
        ResidueProperties.nucleotideIndex[73] = 5;
        ResidueProperties.nucleotideIndex[105] = 5;
        ResidueProperties.nucleotideIndex[88] = 6;
        ResidueProperties.nucleotideIndex[120] = 6;
        ResidueProperties.nucleotideIndex[82] = 7;
        ResidueProperties.nucleotideIndex[114] = 7;
        ResidueProperties.nucleotideIndex[89] = 8;
        ResidueProperties.nucleotideIndex[121] = 8;
        ResidueProperties.nucleotideIndex[78] = 9;
        ResidueProperties.nucleotideIndex[110] = 9;
        nucleotideName.put("A", "Adenine");
        nucleotideName.put("a", "Adenine");
        nucleotideName.put("G", "Guanine");
        nucleotideName.put("g", "Guanine");
        nucleotideName.put("C", "Cytosine");
        nucleotideName.put("c", "Cytosine");
        nucleotideName.put("T", "Thymine");
        nucleotideName.put("t", "Thymine");
        nucleotideName.put("U", "Uracil");
        nucleotideName.put("u", "Uracil");
        nucleotideName.put("I", "Inosine");
        nucleotideName.put("i", "Inosine");
        nucleotideName.put("X", "Xanthine");
        nucleotideName.put("x", "Xanthine");
        nucleotideName.put("R", "Unknown Purine");
        nucleotideName.put("r", "Unknown Purine");
        nucleotideName.put("Y", "Unknown Pyrimidine");
        nucleotideName.put("y", "Unknown Pyrimidine");
        nucleotideName.put("N", "Unknown");
        nucleotideName.put("n", "Unknown");
        aa3Hash.put("ALA", new Integer(0));
        aa3Hash.put("ARG", new Integer(1));
        aa3Hash.put("ASN", new Integer(2));
        aa3Hash.put("ASP", new Integer(3));
        aa3Hash.put("CYS", new Integer(4));
        aa3Hash.put("GLN", new Integer(5));
        aa3Hash.put("GLU", new Integer(6));
        aa3Hash.put("GLY", new Integer(7));
        aa3Hash.put("HIS", new Integer(8));
        aa3Hash.put("ILE", new Integer(9));
        aa3Hash.put("LEU", new Integer(10));
        aa3Hash.put("LYS", new Integer(11));
        aa3Hash.put("MET", new Integer(12));
        aa3Hash.put("PHE", new Integer(13));
        aa3Hash.put("PRO", new Integer(14));
        aa3Hash.put("SER", new Integer(15));
        aa3Hash.put("THR", new Integer(16));
        aa3Hash.put("TRP", new Integer(17));
        aa3Hash.put("TYR", new Integer(18));
        aa3Hash.put("VAL", new Integer(19));
        aa3Hash.put("ASX", new Integer(20));
        aa3Hash.put("GLX", new Integer(21));
        aa3Hash.put("XAA", new Integer(22));
        aa3Hash.put("-", new Integer(23));
        aa3Hash.put("*", new Integer(23));
        aa3Hash.put(".", new Integer(23));
        aa3Hash.put(" ", new Integer(23));
        aa3Hash.put("Gap", new Integer(23));
        aa2Triplet.put("A", "ALA");
        aa2Triplet.put("a", "ALA");
        aa2Triplet.put("R", "ARG");
        aa2Triplet.put("r", "ARG");
        aa2Triplet.put("N", "ASN");
        aa2Triplet.put("n", "ASN");
        aa2Triplet.put("D", "ASP");
        aa2Triplet.put("d", "ASP");
        aa2Triplet.put("C", "CYS");
        aa2Triplet.put("c", "CYS");
        aa2Triplet.put("Q", "GLN");
        aa2Triplet.put("q", "GLN");
        aa2Triplet.put("E", "GLU");
        aa2Triplet.put("e", "GLU");
        aa2Triplet.put("G", "GLY");
        aa2Triplet.put("g", "GLY");
        aa2Triplet.put("H", "HIS");
        aa2Triplet.put("h", "HIS");
        aa2Triplet.put("I", "ILE");
        aa2Triplet.put("i", "ILE");
        aa2Triplet.put("L", "LEU");
        aa2Triplet.put("l", "LEU");
        aa2Triplet.put("K", "LYS");
        aa2Triplet.put("k", "LYS");
        aa2Triplet.put("M", "MET");
        aa2Triplet.put("m", "MET");
        aa2Triplet.put("F", "PHE");
        aa2Triplet.put("f", "PHE");
        aa2Triplet.put("P", "PRO");
        aa2Triplet.put("p", "PRO");
        aa2Triplet.put("S", "SER");
        aa2Triplet.put("s", "SER");
        aa2Triplet.put("T", "THR");
        aa2Triplet.put("t", "THR");
        aa2Triplet.put("W", "TRP");
        aa2Triplet.put("w", "TRP");
        aa2Triplet.put("Y", "TYR");
        aa2Triplet.put("y", "TYR");
        aa2Triplet.put("V", "VAL");
        aa2Triplet.put("v", "VAL");
        aa = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "B", "Z", "X", "_", "*", ".", " "};
        midBlue = new Color(100, 100, 255);
        scaleColours = new Vector();
        scaleColours.addElement(new Color(114, 0, 147));
        scaleColours.addElement(new Color(156, 0, 98));
        scaleColours.addElement(new Color(190, 0, 0));
        scaleColours.addElement(Color.red);
        scaleColours.addElement(new Color(255, 125, 0));
        scaleColours.addElement(Color.orange);
        scaleColours.addElement(new Color(255, 194, 85));
        scaleColours.addElement(Color.yellow);
        scaleColours.addElement(new Color(255, 255, 181));
        scaleColours.addElement(Color.white);
        taylor = new Color[]{new Color(204, 255, 0), new Color(0, 0, 255), new Color(204, 0, 255), new Color(255, 0, 0), new Color(255, 255, 0), new Color(255, 0, 204), new Color(255, 0, 102), new Color(255, 153, 0), new Color(0, 102, 255), new Color(102, 255, 0), new Color(51, 255, 0), new Color(102, 0, 255), new Color(0, 255, 0), new Color(0, 255, 102), new Color(255, 204, 0), new Color(255, 51, 0), new Color(255, 102, 0), new Color(0, 204, 255), new Color(0, 255, 204), new Color(153, 255, 0), Color.white, Color.white, Color.white, Color.white, Color.white, Color.white};
        nucleotide = new Color[]{new Color(100, 247, 63), new Color(255, 179, 64), new Color(235, 65, 60), new Color(60, 136, 238), new Color(60, 136, 238)};
        zappo = new Color[]{Color.pink, midBlue, Color.green, Color.red, Color.yellow, Color.green, Color.red, Color.magenta, midBlue, Color.pink, Color.pink, midBlue, Color.pink, Color.orange, Color.magenta, Color.green, Color.green, Color.orange, Color.orange, Color.pink, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white};
        hyd2 = new double[]{0.62, 0.29, -0.9, -0.74, 1.19, 0.48, -0.4, 1.38, -1.5, 1.06, 0.64, -0.78, 0.12, -0.85, -2.53, -0.18, -0.05, 1.08, 0.81, 0.0, 0.26, 0.0, 0.0};
        helix = new double[]{1.42, 0.98, 0.67, 1.01, 0.7, 1.11, 1.51, 0.57, 1.0, 1.08, 1.21, 1.16, 1.45, 1.13, 0.57, 0.77, 0.83, 1.08, 0.69, 1.06, 0.84, 1.31, 1.0, 0.0};
        strand = new double[]{0.83, 0.93, 0.89, 0.54, 1.19, 1.1, 0.37, 0.75, 0.87, 1.6, 1.3, 0.74, 1.05, 1.38, 0.55, 0.75, 1.19, 1.37, 1.47, 1.7, 0.72, 0.74, 1.0, 0.0};
        turn = new double[]{0.66, 0.95, 1.56, 1.46, 1.19, 0.98, 0.74, 1.56, 0.95, 0.47, 0.59, 1.01, 0.6, 0.6, 1.52, 1.43, 0.96, 0.96, 1.14, 0.5, 1.51, 0.86, 1.0, 0.0, 0.0};
        buried = new double[]{1.7, 0.1, 0.4, 0.4, 4.6, 0.3, 0.3, 1.8, 0.8, 3.1, 2.4, 0.05, 1.9, 2.2, 0.6, 0.8, 0.7, 1.6, 0.5, 2.9, 0.4, 0.3, 1.358, 0.0};
        hyd = new double[]{1.8, -4.5, -3.5, -3.5, 2.5, -3.5, -3.5, -0.4, -3.2, 4.5, 3.8, -3.9, 1.9, 2.8, -1.6, -0.8, -0.7, -0.9, -1.3, 4.2, -3.5, -3.5, -0.49, 0.0};
        BLOSUM62 = new int[][]{{4, -1, -2, -2, 0, -1, -1, 0, -2, -1, -1, -1, -1, -2, -1, 1, 0, -3, -2, 0, -2, -1, 0, -4}, {-1, 5, 0, -2, -3, 1, 0, -2, 0, -3, -2, 2, -1, -3, -2, -1, -1, -3, -2, -3, -1, 0, -1, -4}, {-2, 0, 6, 1, -3, 0, 0, 0, 1, -3, -3, 0, -2, -3, -2, 1, 0, -4, -2, -3, 3, 0, -1, -4}, {-2, -2, 1, 6, -3, 0, 2, -1, -1, -3, -4, -1, -3, -3, -1, 0, -1, -4, -3, -3, 4, 1, -1, -4}, {0, 3, -3, -3, 9, -3, -4, -3, -3, -1, -1, -3, -1, -2, -3, -1, -1, -2, -2, -1, -3, -3, -2, -4}, {-1, 1, 0, 0, -3, 5, 2, -2, 0, -3, -2, 1, 0, -3, -1, 0, -1, -2, -1, -2, 0, 3, -1, -4}, {-1, 0, 0, 2, -4, 2, 5, -2, 0, -3, -3, 1, -2, -3, -1, 0, -1, -3, -2, -2, 1, 4, -1, -4}, {0, -2, 0, -1, -3, -2, -2, 6, -2, -4, -4, -2, -3, -3, -2, 0, -2, -2, -3, -3, -1, -2, -1, -4}, {-2, 0, 1, -1, -3, 0, 0, -2, 8, -3, -3, -1, -2, -1, -2, -1, -2, -2, 2, -3, 0, 0, -1, -4}, {-1, -3, -3, -3, -1, -3, -3, -4, -3, 4, 2, -3, 1, 0, -3, -2, -1, -3, -1, 3, -3, -3, -1, -4}, {-1, -2, -3, -4, -1, -2, -3, -4, -3, 2, 4, -2, 2, 0, -3, -2, -1, -2, -1, 1, -4, -3, -1, -4}, {-1, 2, 0, -1, -3, 1, 1, -2, -1, -3, -2, 5, -1, -3, -1, 0, -1, -3, -2, -2, 0, 1, -1, -4}, {-1, -1, -2, -3, -1, 0, -2, -3, -2, 1, 2, -1, 5, 0, -2, -1, -1, -1, -1, 1, -3, -1, -1, -4}, {-2, -3, -3, -3, -2, -3, -3, -3, -1, 0, 0, -3, 0, 6, -4, -2, -2, 1, 3, -1, -3, -3, -1, -4}, {-1, -2, -2, -1, -3, -1, -1, -2, -2, -3, -3, -1, -2, -4, 7, -1, -1, -4, -3, -2, -2, -1, -2, -4}, {1, -1, 1, 0, -1, 0, 0, 0, -1, -2, -2, 0, -1, -2, -1, 4, 1, -3, -2, -2, 0, 0, 0, -4}, {0, -1, 0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1, -2, -1, 1, 5, -2, -2, 0, -1, -1, 0, -4}, {-3, -3, -4, -4, -2, -2, -3, -2, -2, -3, -2, -3, -1, 1, -4, -3, -2, 11, 2, -3, -4, -3, -2, -4}, {-2, -2, -2, -3, -2, -1, -2, -3, 2, -1, -1, -2, -1, 3, -3, -2, -2, 2, 7, -1, -3, -2, -1, -4}, {0, -3, -3, -3, -1, -2, -2, -3, -3, 3, 1, -2, 1, -1, -2, -2, 0, -3, -1, 4, -3, -2, -1, -4}, {-2, -1, 3, 4, -3, 0, 1, -1, 0, -3, -4, 0, -3, -3, -2, 0, -1, -4, -3, -3, 4, 1, -1, -4}, {-1, 0, 0, 1, -3, 3, 4, -2, 0, -3, -3, 1, -1, -3, -1, 0, -1, -3, -2, -2, 1, 4, -1, -4}, {0, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, 0, 0, -2, -1, -1, -1, -1, -1, -4}, {-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, 1}};
        PAM250 = new int[][]{{2, -2, 0, 0, -2, 0, 0, 1, -1, -1, -2, -1, -1, -3, 1, 1, 1, -6, -3, 0, 0, 0, 0, -8}, {-2, 6, 0, -1, -4, 1, -1, -3, 2, -2, -3, 3, 0, -4, 0, 0, -1, 2, -4, -2, -1, 0, -1, -8}, {0, 0, 2, 2, -4, 1, 1, 0, 2, -2, -3, 1, -2, -3, 0, 1, 0, -4, -2, -2, 2, 1, 0, -8}, {0, -1, 2, 4, -5, 2, 3, 1, 1, -2, -4, 0, -3, -6, -1, 0, 0, -7, -4, -2, 3, 3, -1, -8}, {-2, -4, -4, -5, 12, -5, -5, -3, -3, -2, -6, -5, -5, -4, -3, 0, -2, -8, 0, -2, -4, -5, -3, -8}, {0, 1, 1, 2, -5, 4, 2, -1, 3, -2, -2, 1, -1, -5, 0, -1, -1, -5, -4, -2, 1, 3, -1, -8}, {0, -1, 1, 3, -5, 2, 4, 0, 1, -2, -3, 0, -2, -5, -1, 0, 0, -7, -4, -2, 3, 3, -1, -8}, {1, -3, 0, 1, -3, -1, 0, 5, -2, -3, -4, -2, -3, -5, 0, 1, 0, -7, -5, -1, 0, 0, -1, -8}, {-1, 2, 2, 1, -3, 3, 1, -2, 6, -2, -2, 0, -2, -2, 0, -1, -1, -3, 0, -2, 1, 2, -1, -8}, {-1, -2, -2, -2, -2, -2, -2, -3, -2, 5, 2, -2, 2, 1, -2, -1, 0, -5, -1, 4, -2, -2, -1, -8}, {-2, -3, -3, -4, -6, -2, -3, -4, -2, 2, 6, -3, 4, 2, -3, -3, -2, -2, -1, 2, -3, -3, -1, -8}, {-1, 3, 1, 0, -5, 1, 0, -2, 0, -2, -3, 5, 0, -5, -1, 0, 0, -3, -4, -2, 1, 0, -1, -8}, {-1, 0, -2, -3, -5, -1, -2, -3, -2, 2, 4, 0, 6, 0, -2, -2, -1, -4, -2, 2, -2, -2, -1, -8}, {-3, -4, -3, -6, -4, -5, -5, -5, -2, 1, 2, -5, 0, 9, -5, -3, -3, 0, 7, -1, -4, -5, -2, -8}, {1, 0, 0, -1, -3, 0, -1, 0, 0, -2, -3, -1, -2, -5, 6, 1, 0, -6, -5, -1, -1, 0, -1, -8}, {1, 0, 1, 0, 0, -1, 0, 1, -1, -1, -3, 0, -2, -3, 1, 2, 1, -2, -3, -1, 0, 0, 0, -8}, {1, -1, 0, 0, -2, -1, 0, 0, -1, 0, -2, 0, -1, -3, 0, 1, 3, -5, -3, 0, 0, -1, 0, -8}, {-6, 2, -4, -7, -8, -5, -7, -7, -3, -5, -2, -3, -4, 0, -6, -2, -5, 17, 0, -6, -5, -6, -4, -8}, {-3, -4, -2, -4, 0, -4, -4, -5, 0, -1, -1, -4, -2, 7, -5, -3, -3, 0, 10, -2, -3, -4, -2, -8}, {0, -2, -2, -2, -2, -2, -2, -1, -2, 4, 2, -2, 2, -1, -1, -1, 0, -6, -2, 4, -2, -2, -1, -8}, {0, -1, 2, 3, -4, 1, 3, 0, 1, -2, -3, 1, -2, -4, -1, 0, 0, -5, -3, -2, 3, 2, -1, -8}, {0, 0, 1, 3, -5, 3, 3, 0, 2, -2, -3, 0, -2, -5, 0, 0, -1, -6, -4, -2, 2, 3, -1, -8}, {0, -1, 0, -1, -3, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, 0, 0, -4, -2, -1, -1, -1, -1, -8}, {-8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1}};
        ssHash = new Hashtable();
        ssHash.put("H", Color.magenta);
        ssHash.put("E", Color.yellow);
        ssHash.put("-", Color.white);
        ssHash.put(".", Color.white);
        ssHash.put("S", Color.cyan);
        ssHash.put("T", Color.blue);
        ssHash.put("G", Color.pink);
        ssHash.put("I", Color.pink);
        ssHash.put("B", Color.yellow);
        DNA = new int[][]{{5, -4, -4, -4, 1}, {-4, 5, -4, -4, 1}, {-4, -4, 5, -4, 1}, {-4, -4, -4, 5, 1}, {1, 1, 1, 1, 1}};
        scoreMatrices.put("BLOSUM62", new ScoreMatrix("BLOSUM62", BLOSUM62, 0));
        scoreMatrices.put("PAM250", new ScoreMatrix("PAM250", PAM250, 0));
        scoreMatrices.put("DNA", new ScoreMatrix("DNA", DNA, 1));
        pidColours = new Color[]{midBlue, new Color(153, 153, 255), new Color(204, 204, 255)};
        pidThresholds = new float[]{80.0f, 60.0f, 40.0f};
        codonHash = new Hashtable();
        Lys = new Vector();
        Asn = new Vector();
        Gln = new Vector();
        His = new Vector();
        Glu = new Vector();
        Asp = new Vector();
        Tyr = new Vector();
        Thr = new Vector();
        Pro = new Vector();
        Ala = new Vector();
        Ser = new Vector();
        Arg = new Vector();
        Gly = new Vector();
        Trp = new Vector();
        Cys = new Vector();
        Ile = new Vector();
        Met = new Vector();
        Leu = new Vector();
        Val = new Vector();
        Phe = new Vector();
        STOP = new Vector();
        codonHash.put("K", Lys);
        codonHash.put("N", Asn);
        codonHash.put("Q", Gln);
        codonHash.put("H", His);
        codonHash.put("E", Glu);
        codonHash.put("D", Asp);
        codonHash.put("Y", Tyr);
        codonHash.put("T", Thr);
        codonHash.put("P", Pro);
        codonHash.put("A", Ala);
        codonHash.put("S", Ser);
        codonHash.put("R", Arg);
        codonHash.put("G", Gly);
        codonHash.put("W", Trp);
        codonHash.put("C", Cys);
        codonHash.put("I", Ile);
        codonHash.put("M", Met);
        codonHash.put("L", Leu);
        codonHash.put("V", Val);
        codonHash.put("F", Phe);
        codonHash.put("STOP", STOP);
        codonHash2 = new Hashtable();
        codonHash2.put("AAA", "K");
        codonHash2.put("AAG", "K");
        codonHash2.put("AAC", "N");
        codonHash2.put("AAT", "N");
        codonHash2.put("CAA", "E");
        codonHash2.put("CAG", "E");
        codonHash2.put("CAC", "H");
        codonHash2.put("CAT", "H");
        codonHash2.put("GAA", "Q");
        codonHash2.put("GAG", "Q");
        codonHash2.put("GAC", "D");
        codonHash2.put("GAT", "D");
        codonHash2.put("TAC", "Y");
        codonHash2.put("TAT", "Y");
        codonHash2.put("ACA", "T");
        codonHash2.put("AAG", "T");
        codonHash2.put("ACC", "T");
        codonHash2.put("ACT", "T");
        codonHash2.put("CCA", "P");
        codonHash2.put("CCG", "P");
        codonHash2.put("CCC", "P");
        codonHash2.put("CCT", "P");
        codonHash2.put("GCA", "A");
        codonHash2.put("GCG", "A");
        codonHash2.put("GCC", "A");
        codonHash2.put("GCT", "A");
        codonHash2.put("TCA", "S");
        codonHash2.put("TCG", "S");
        codonHash2.put("TCC", "S");
        codonHash2.put("TCT", "S");
        codonHash2.put("AGC", "S");
        codonHash2.put("AGT", "S");
        codonHash2.put("AGA", "R");
        codonHash2.put("AGG", "R");
        codonHash2.put("CGA", "R");
        codonHash2.put("CGG", "R");
        codonHash2.put("CGC", "R");
        codonHash2.put("CGT", "R");
        codonHash2.put("GGA", "G");
        codonHash2.put("GGG", "G");
        codonHash2.put("GGC", "G");
        codonHash2.put("GGT", "G");
        codonHash2.put("TGA", "*");
        codonHash2.put("TAA", "*");
        codonHash2.put("TAG", "*");
        codonHash2.put("TGG", "W");
        codonHash2.put("TGC", "C");
        codonHash2.put("TGT", "C");
        codonHash2.put("ATA", "I");
        codonHash2.put("ATC", "I");
        codonHash2.put("ATT", "I");
        codonHash2.put("ATG", "M");
        codonHash2.put("CTA", "L");
        codonHash2.put("CTG", "L");
        codonHash2.put("CTC", "L");
        codonHash2.put("CTT", "L");
        codonHash2.put("TTA", "L");
        codonHash2.put("TTG", "L");
        codonHash2.put("GTA", "V");
        codonHash2.put("GTG", "V");
        codonHash2.put("GTC", "V");
        codonHash2.put("GTT", "V");
        codonHash2.put("TTC", "F");
        codonHash2.put("TTT", "F");
        Lys.addElement("AAA");
        Lys.addElement("AAG");
        Asn.addElement("AAC");
        Asn.addElement("AAT");
        Gln.addElement("CAA");
        Gln.addElement("CAG");
        His.addElement("CAC");
        His.addElement("CAT");
        Glu.addElement("GAA");
        Glu.addElement("GAG");
        Asp.addElement("GAC");
        Asp.addElement("GAT");
        Tyr.addElement("TAC");
        Tyr.addElement("TAT");
        Thr.addElement("ACA");
        Thr.addElement("ACG");
        Thr.addElement("ACC");
        Thr.addElement("ACT");
        Pro.addElement("CCA");
        Pro.addElement("CCG");
        Pro.addElement("CCC");
        Pro.addElement("CCT");
        Ala.addElement("GCA");
        Ala.addElement("GCG");
        Ala.addElement("GCC");
        Ala.addElement("GCT");
        Ser.addElement("TCA");
        Ser.addElement("TCG");
        Ser.addElement("TCC");
        Ser.addElement("TCT");
        Ser.addElement("AGC");
        Ser.addElement("AGT");
        Arg.addElement("AGA");
        Arg.addElement("AGG");
        Arg.addElement("CGA");
        Arg.addElement("CGG");
        Arg.addElement("CGC");
        Arg.addElement("CGT");
        Gly.addElement("GGA");
        Gly.addElement("GGG");
        Gly.addElement("GGC");
        Gly.addElement("GGT");
        STOP.addElement("TGA");
        STOP.addElement("TAA");
        STOP.addElement("TAG");
        Trp.addElement("TGG");
        Cys.addElement("TGC");
        Cys.addElement("TGT");
        Ile.addElement("ATA");
        Ile.addElement("ATC");
        Ile.addElement("ATT");
        Met.addElement("ATG");
        Leu.addElement("CTA");
        Leu.addElement("CTG");
        Leu.addElement("CTC");
        Leu.addElement("CTT");
        Leu.addElement("TTA");
        Leu.addElement("TTG");
        Val.addElement("GTA");
        Val.addElement("GTG");
        Val.addElement("GTC");
        Val.addElement("GTT");
        Phe.addElement("TTC");
        Phe.addElement("TTT");
        propHash = new Hashtable();
        hydrophobic = new Hashtable();
        polar = new Hashtable();
        small = new Hashtable();
        positive = new Hashtable();
        negative = new Hashtable();
        charged = new Hashtable();
        aromatic = new Hashtable();
        aliphatic = new Hashtable();
        tiny = new Hashtable();
        proline = new Hashtable();
        hydrophobic.put("I", new Integer(1));
        hydrophobic.put("L", new Integer(1));
        hydrophobic.put("V", new Integer(1));
        hydrophobic.put("C", new Integer(1));
        hydrophobic.put("A", new Integer(1));
        hydrophobic.put("G", new Integer(1));
        hydrophobic.put("M", new Integer(1));
        hydrophobic.put("F", new Integer(1));
        hydrophobic.put("Y", new Integer(1));
        hydrophobic.put("W", new Integer(1));
        hydrophobic.put("H", new Integer(1));
        hydrophobic.put("K", new Integer(1));
        hydrophobic.put("X", new Integer(1));
        hydrophobic.put("-", new Integer(1));
        hydrophobic.put("*", new Integer(1));
        hydrophobic.put("R", new Integer(0));
        hydrophobic.put("E", new Integer(0));
        hydrophobic.put("Q", new Integer(0));
        hydrophobic.put("D", new Integer(0));
        hydrophobic.put("N", new Integer(0));
        hydrophobic.put("S", new Integer(0));
        hydrophobic.put("T", new Integer(0));
        hydrophobic.put("P", new Integer(0));
        polar.put("Y", new Integer(1));
        polar.put("W", new Integer(1));
        polar.put("H", new Integer(1));
        polar.put("K", new Integer(1));
        polar.put("R", new Integer(1));
        polar.put("E", new Integer(1));
        polar.put("Q", new Integer(1));
        polar.put("D", new Integer(1));
        polar.put("N", new Integer(1));
        polar.put("S", new Integer(1));
        polar.put("T", new Integer(1));
        polar.put("X", new Integer(1));
        polar.put("-", new Integer(1));
        polar.put("*", new Integer(1));
        polar.put("I", new Integer(0));
        polar.put("L", new Integer(0));
        polar.put("V", new Integer(0));
        polar.put("C", new Integer(0));
        polar.put("A", new Integer(0));
        polar.put("G", new Integer(0));
        polar.put("M", new Integer(0));
        polar.put("F", new Integer(0));
        polar.put("P", new Integer(0));
        small.put("I", new Integer(0));
        small.put("L", new Integer(0));
        small.put("V", new Integer(1));
        small.put("C", new Integer(1));
        small.put("A", new Integer(1));
        small.put("G", new Integer(1));
        small.put("M", new Integer(0));
        small.put("F", new Integer(0));
        small.put("Y", new Integer(0));
        small.put("W", new Integer(0));
        small.put("H", new Integer(0));
        small.put("K", new Integer(0));
        small.put("R", new Integer(0));
        small.put("E", new Integer(0));
        small.put("Q", new Integer(0));
        small.put("D", new Integer(1));
        small.put("N", new Integer(1));
        small.put("S", new Integer(1));
        small.put("T", new Integer(1));
        small.put("P", new Integer(1));
        small.put("-", new Integer(1));
        small.put("*", new Integer(1));
        positive.put("I", new Integer(0));
        positive.put("L", new Integer(0));
        positive.put("V", new Integer(0));
        positive.put("C", new Integer(0));
        positive.put("A", new Integer(0));
        positive.put("G", new Integer(0));
        positive.put("M", new Integer(0));
        positive.put("F", new Integer(0));
        positive.put("Y", new Integer(0));
        positive.put("W", new Integer(0));
        positive.put("H", new Integer(1));
        positive.put("K", new Integer(1));
        positive.put("R", new Integer(1));
        positive.put("E", new Integer(0));
        positive.put("Q", new Integer(0));
        positive.put("D", new Integer(0));
        positive.put("N", new Integer(0));
        positive.put("S", new Integer(0));
        positive.put("T", new Integer(0));
        positive.put("P", new Integer(0));
        positive.put("-", new Integer(1));
        positive.put("*", new Integer(1));
        negative.put("I", new Integer(0));
        negative.put("L", new Integer(0));
        negative.put("V", new Integer(0));
        negative.put("C", new Integer(0));
        negative.put("A", new Integer(0));
        negative.put("G", new Integer(0));
        negative.put("M", new Integer(0));
        negative.put("F", new Integer(0));
        negative.put("Y", new Integer(0));
        negative.put("W", new Integer(0));
        negative.put("H", new Integer(0));
        negative.put("K", new Integer(0));
        negative.put("R", new Integer(0));
        negative.put("E", new Integer(1));
        negative.put("Q", new Integer(0));
        negative.put("D", new Integer(1));
        negative.put("N", new Integer(0));
        negative.put("S", new Integer(0));
        negative.put("T", new Integer(0));
        negative.put("P", new Integer(0));
        negative.put("-", new Integer(1));
        negative.put("*", new Integer(1));
        charged.put("I", new Integer(0));
        charged.put("L", new Integer(0));
        charged.put("V", new Integer(0));
        charged.put("C", new Integer(0));
        charged.put("A", new Integer(0));
        charged.put("G", new Integer(0));
        charged.put("M", new Integer(0));
        charged.put("F", new Integer(0));
        charged.put("Y", new Integer(0));
        charged.put("W", new Integer(0));
        charged.put("H", new Integer(1));
        charged.put("K", new Integer(1));
        charged.put("R", new Integer(1));
        charged.put("E", new Integer(1));
        charged.put("Q", new Integer(0));
        charged.put("D", new Integer(1));
        charged.put("N", new Integer(1));
        charged.put("S", new Integer(0));
        charged.put("T", new Integer(0));
        charged.put("P", new Integer(0));
        charged.put("-", new Integer(1));
        charged.put("*", new Integer(1));
        aromatic.put("I", new Integer(0));
        aromatic.put("L", new Integer(0));
        aromatic.put("V", new Integer(0));
        aromatic.put("C", new Integer(0));
        aromatic.put("A", new Integer(0));
        aromatic.put("G", new Integer(0));
        aromatic.put("M", new Integer(0));
        aromatic.put("F", new Integer(1));
        aromatic.put("Y", new Integer(1));
        aromatic.put("W", new Integer(1));
        aromatic.put("H", new Integer(1));
        aromatic.put("K", new Integer(0));
        aromatic.put("R", new Integer(0));
        aromatic.put("E", new Integer(0));
        aromatic.put("Q", new Integer(0));
        aromatic.put("D", new Integer(0));
        aromatic.put("N", new Integer(0));
        aromatic.put("S", new Integer(0));
        aromatic.put("T", new Integer(0));
        aromatic.put("P", new Integer(0));
        aromatic.put("-", new Integer(1));
        aromatic.put("*", new Integer(1));
        aliphatic.put("I", new Integer(1));
        aliphatic.put("L", new Integer(1));
        aliphatic.put("V", new Integer(1));
        aliphatic.put("C", new Integer(0));
        aliphatic.put("A", new Integer(0));
        aliphatic.put("G", new Integer(0));
        aliphatic.put("M", new Integer(0));
        aliphatic.put("F", new Integer(0));
        aliphatic.put("Y", new Integer(0));
        aliphatic.put("W", new Integer(0));
        aliphatic.put("H", new Integer(0));
        aliphatic.put("K", new Integer(0));
        aliphatic.put("R", new Integer(0));
        aliphatic.put("E", new Integer(0));
        aliphatic.put("Q", new Integer(0));
        aliphatic.put("D", new Integer(0));
        aliphatic.put("N", new Integer(0));
        aliphatic.put("S", new Integer(0));
        aliphatic.put("T", new Integer(0));
        aliphatic.put("P", new Integer(0));
        aliphatic.put("-", new Integer(1));
        aliphatic.put("*", new Integer(1));
        tiny.put("I", new Integer(0));
        tiny.put("L", new Integer(0));
        tiny.put("V", new Integer(0));
        tiny.put("C", new Integer(0));
        tiny.put("A", new Integer(1));
        tiny.put("G", new Integer(1));
        tiny.put("M", new Integer(0));
        tiny.put("F", new Integer(0));
        tiny.put("Y", new Integer(0));
        tiny.put("W", new Integer(0));
        tiny.put("H", new Integer(0));
        tiny.put("K", new Integer(0));
        tiny.put("R", new Integer(0));
        tiny.put("E", new Integer(0));
        tiny.put("Q", new Integer(0));
        tiny.put("D", new Integer(0));
        tiny.put("N", new Integer(0));
        tiny.put("S", new Integer(1));
        tiny.put("T", new Integer(0));
        tiny.put("P", new Integer(0));
        tiny.put("-", new Integer(1));
        tiny.put("*", new Integer(1));
        proline.put("I", new Integer(0));
        proline.put("L", new Integer(0));
        proline.put("V", new Integer(0));
        proline.put("C", new Integer(0));
        proline.put("A", new Integer(0));
        proline.put("G", new Integer(0));
        proline.put("M", new Integer(0));
        proline.put("F", new Integer(0));
        proline.put("Y", new Integer(0));
        proline.put("W", new Integer(0));
        proline.put("H", new Integer(0));
        proline.put("K", new Integer(0));
        proline.put("R", new Integer(0));
        proline.put("E", new Integer(0));
        proline.put("Q", new Integer(0));
        proline.put("D", new Integer(0));
        proline.put("N", new Integer(0));
        proline.put("S", new Integer(0));
        proline.put("T", new Integer(0));
        proline.put("P", new Integer(1));
        proline.put("-", new Integer(1));
        proline.put("*", new Integer(1));
        propHash.put("hydrophobic", hydrophobic);
        propHash.put("small", small);
        propHash.put("positive", positive);
        propHash.put("negative", negative);
        propHash.put("charged", charged);
        propHash.put("aromatic", aromatic);
        propHash.put("aliphatic", aliphatic);
        propHash.put("tiny", tiny);
        propHash.put("proline", proline);
        propHash.put("polar", polar);
        toDssp3State = new Hashtable();
        toDssp3State.put("H", "H");
        toDssp3State.put("E", "E");
        toDssp3State.put("C", " ");
        toDssp3State.put(" ", " ");
        toDssp3State.put("T", " ");
        toDssp3State.put("B", "E");
        toDssp3State.put("G", "H");
        toDssp3State.put("I", "H");
        toDssp3State.put("X", " ");
    }
}

