/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.Reader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.readers.LongLineBufferedReader;

public class AsynchronousLineReader
implements LineReader {
    public static final int DEFAULT_NUMBER_LINES_BUFFER = 100;
    private final LongLineBufferedReader bufferedReader;
    private final BlockingQueue<String> lineQueue;
    private final Thread worker;
    private volatile Throwable workerException = null;
    private volatile boolean eofReached = false;

    public AsynchronousLineReader(Reader reader, int lineReadAheadSize) {
        this.bufferedReader = new LongLineBufferedReader(reader);
        this.lineQueue = new LinkedBlockingQueue<String>(lineReadAheadSize);
        this.worker = new Thread(new Worker());
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public AsynchronousLineReader(Reader reader) {
        this(reader, 100);
    }

    @Override
    public String readLine() {
        try {
            String pollResult;
            block3: {
                do {
                    this.checkAndThrowIfWorkerException();
                    pollResult = this.lineQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (pollResult != null) break block3;
                } while (!this.eofReached);
                this.checkAndThrowIfWorkerException();
                return (String)this.lineQueue.poll();
            }
            return pollResult;
        }
        catch (InterruptedException e) {
            throw new TribbleException("Line polling interrupted.", e);
        }
    }

    private void checkAndThrowIfWorkerException() {
        if (this.workerException != null) {
            throw new TribbleException("Exception encountered in worker thread.", this.workerException);
        }
    }

    @Override
    public void close() {
        this.worker.interrupt();
    }

    static /* synthetic */ LongLineBufferedReader access$100(AsynchronousLineReader x0) {
        return x0.bufferedReader;
    }

    static /* synthetic */ boolean access$202(AsynchronousLineReader x0, boolean x1) {
        x0.eofReached = x1;
        return x0.eofReached;
    }

    static /* synthetic */ BlockingQueue access$300(AsynchronousLineReader x0) {
        return x0.lineQueue;
    }

    static /* synthetic */ Throwable access$402(AsynchronousLineReader x0, Throwable x1) {
        x0.workerException = x1;
        return x0.workerException;
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

