/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.TabixReader;

public class TabixUtils {
    public static final String STANDARD_INDEX_EXTENSION = ".tbi";

    public static boolean less64(long u, long v) {
        return u < v ^ u < 0L ^ v < 0L;
    }

    public static SAMSequenceDictionary getSequenceDictionary(File tabixIndex) {
        if (tabixIndex == null) {
            throw new IllegalArgumentException();
        }
        try {
            BlockCompressedInputStream is = new BlockCompressedInputStream(tabixIndex);
            byte[] buf = new byte[32];
            is.read(buf, 0, 32);
            int len = TabixReader.readInt(is);
            buf = new byte[len];
            is.read(buf);
            ArrayList<SAMSequenceRecord> sequences = new ArrayList<SAMSequenceRecord>();
            int j = 0;
            for (int i = 0; i < buf.length; ++i) {
                if (buf[i] != 0) continue;
                byte[] b = new byte[i - j];
                System.arraycopy(buf, j, b, 0, b.length);
                sequences.add(new SAMSequenceRecord(new String(b)));
                j = i + 1;
            }
            is.close();
            return new SAMSequenceDictionary(sequences);
        }
        catch (Exception e) {
            throw new TribbleException("Unable to read tabix index: " + e.getMessage());
        }
    }

    public static class TIntv {
        public int tid;
        public int beg;
        public int end;
    }

    public static class TIndex {
        public HashMap<Integer, TPair64[]> b;
        public long[] l;
    }

    public static class TPair64
    implements Comparable<TPair64> {
        public long u;
        public long v;

        public TPair64(long _u, long _v) {
            this.u = _u;
            this.v = _v;
        }

        public TPair64(TPair64 p) {
            this.u = p.u;
            this.v = p.v;
        }

        @Override
        public int compareTo(TPair64 p) {
            return this.u == p.u ? 0 : (this.u < p.u ^ this.u < 0L ^ p.u < 0L ? -1 : 1);
        }
    }
}

