/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.sdi.GSDI;
import org.forester.sdi.SDI;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIse;
import org.forester.util.CommandLineArguments;
import org.forester.util.EasyWriter;
import org.forester.util.ForesterUtil;

public final class gsdi {
    public static final boolean REPLACE_UNDERSCORES_IN_NH_SPECIES_TREE = true;
    private static final String ALLOW_STRIPPING_OF_GENE_TREE_OPTION = "g";
    private static final String SDISE_OPTION = "b";
    private static final String MOST_PARSIMONIOUS_OPTION = "m";
    private static final String GUESS_FORMAT_OF_SPECIES_TREE = "q";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String SUFFIX_FOR_SPECIES_TREE_USED = "_species_tree_used.xml";
    private static final String LOGFILE_SUFFIX = "_gsdi_log.txt";
    private static final String REMAPPED_SUFFIX = "_gsdi_remapped.txt";
    private static final String PRG_NAME = "gsdi";
    private static final String PRG_VERSION = "1.000";
    private static final String PRG_DATE = "120629";
    private static final String PRG_DESC = "general speciation duplication inference";
    private static final String E_MAIL = "phylosoft@gmail.com";
    private static final String WWW = "www.phylosoft.org/forester";

    public static void main(String[] stringArray) {
        try {
            ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
            CommandLineArguments commandLineArguments = null;
            try {
                commandLineArguments = new CommandLineArguments(stringArray);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
            }
            if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
                System.out.println();
                gsdi.print_help();
                System.exit(0);
            } else if (stringArray.length < 2 || commandLineArguments.getNumberOfNames() != 3) {
                System.out.println();
                System.out.println("Wrong number of arguments.");
                System.out.println();
                gsdi.print_help();
                System.exit(-1);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(SDISE_OPTION);
            arrayList.add(GUESS_FORMAT_OF_SPECIES_TREE);
            arrayList.add(MOST_PARSIMONIOUS_OPTION);
            arrayList.add(ALLOW_STRIPPING_OF_GENE_TREE_OPTION);
            String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
            if (string.length() > 0) {
                ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
            }
            gsdi.execute(commandLineArguments);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
    }

    private static void execute(CommandLineArguments commandLineArguments) throws IOException {
        Object object;
        Object object2;
        BASE_ALGORITHM bASE_ALGORITHM = BASE_ALGORITHM.GSDI;
        boolean bl = false;
        boolean bl2 = false;
        if (commandLineArguments.isOptionSet(SDISE_OPTION)) {
            bASE_ALGORITHM = BASE_ALGORITHM.SDI;
        }
        if (commandLineArguments.isOptionSet(MOST_PARSIMONIOUS_OPTION)) {
            if (bASE_ALGORITHM != BASE_ALGORITHM.GSDI) {
                ForesterUtil.fatalError(PRG_NAME, "Can only use most parsimonious duplication mode with GSDI");
            }
            bl = true;
        }
        if (commandLineArguments.isOptionSet(ALLOW_STRIPPING_OF_GENE_TREE_OPTION)) {
            if (bASE_ALGORITHM != BASE_ALGORITHM.GSDI) {
                ForesterUtil.fatalError(PRG_NAME, "Can only allow stripping of gene tree with GSDI");
            }
            bl2 = true;
        }
        Phylogeny phylogeny = null;
        Phylogeny phylogeny2 = null;
        File file = null;
        File file2 = null;
        File file3 = null;
        File file4 = null;
        EasyWriter easyWriter = null;
        try {
            file = commandLineArguments.getFile(0);
            file2 = commandLineArguments.getFile(1);
            file3 = commandLineArguments.getFile(2);
            file4 = new File(ForesterUtil.removeSuffix(file3.toString()) + LOGFILE_SUFFIX);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ForesterUtil.fatalError(PRG_NAME, "error in command line: " + illegalArgumentException.getMessage());
        }
        if (ForesterUtil.isReadableFile(file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(file));
        }
        if (ForesterUtil.isReadableFile(file2) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(file2));
        }
        if (ForesterUtil.isWritableFile(file3) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isWritableFile(file3));
        }
        if (ForesterUtil.isWritableFile(file4) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isWritableFile(file4));
        }
        try {
            easyWriter = ForesterUtil.createEasyWriter(file4);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to create [" + file4 + "]: " + iOException.getMessage());
        }
        try {
            object2 = ParserBasedPhylogenyFactory.getInstance();
            phylogeny2 = object2.create(file, new PhyloXmlParser())[0];
        }
        catch (IOException iOException) {
            gsdi.fatalError("ERROR", "Failed to read gene tree from [" + file + "]: " + iOException.getMessage(), easyWriter);
        }
        try {
            object2 = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file2, true);
            if (phylogenyParser instanceof PhyloXmlParser) {
                phylogeny = object2.create(file2, phylogenyParser)[0];
            } else {
                if (phylogenyParser instanceof NHXParser) {
                    ((NHXParser)phylogenyParser).setReplaceUnderscores(true);
                }
                phylogeny = object2.create(file2, phylogenyParser)[0];
                SDI.TaxonomyComparisonBase taxonomyComparisonBase = GSDI.determineTaxonomyComparisonBase(phylogeny2);
                switch (taxonomyComparisonBase) {
                    case SCIENTIFIC_NAME: {
                        try {
                            PhylogenyMethods.transferNodeNameToField(phylogeny, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME, true);
                        }
                        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                            gsdi.fatalError("USER ERROR", "Failed to transfer general node name to scientific name, in [" + file2 + "]: " + phyloXmlDataFormatException.getMessage(), easyWriter);
                        }
                        break;
                    }
                    case CODE: {
                        try {
                            PhylogenyMethods.transferNodeNameToField(phylogeny, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
                        }
                        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                            gsdi.fatalError("USER ERROR", "Failed to transfer general node name to taxonomy code, in [" + file2 + "]: " + phyloXmlDataFormatException.getMessage(), easyWriter);
                        }
                        break;
                    }
                    case ID: {
                        try {
                            PhylogenyMethods.transferNodeNameToField(phylogeny, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_ID, true);
                        }
                        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                            gsdi.fatalError("USER ERROR", "Failed to transfer general node name to taxonomy id, in [" + file2 + "]: " + phyloXmlDataFormatException.getMessage(), easyWriter);
                        }
                        break;
                    }
                    default: {
                        gsdi.fatalError("UNEXPECTED ERROR", "unable to determine comparison base", easyWriter);
                    }
                }
            }
        }
        catch (IOException iOException) {
            gsdi.fatalError("ERROR", "Failed to read species tree from [" + file2 + "]: " + iOException.getMessage(), easyWriter);
        }
        phylogeny2.setRooted(true);
        phylogeny.setRooted(true);
        if (!phylogeny2.isCompletelyBinary()) {
            gsdi.fatalError("user error", "gene tree is not completely binary", easyWriter);
        }
        if (bASE_ALGORITHM != BASE_ALGORITHM.GSDI && !phylogeny.isCompletelyBinary()) {
            gsdi.fatalError("user error", "species tree is not completely binary, use GSDI instead", easyWriter);
        }
        easyWriter.println("gsdi - general speciation duplication inference");
        easyWriter.println("  version         : 1.000");
        easyWriter.println("  date            : 120629");
        easyWriter.println("  forester version: 1.005");
        easyWriter.println();
        easyWriter.println("Start time                               : " + new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(new Date()));
        System.out.println("Start time                               : " + new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(new Date()));
        easyWriter.println("Gene tree file                           : " + file.getCanonicalPath());
        System.out.println("Gene tree file                           : " + file.getCanonicalPath());
        easyWriter.println("Gene tree name                           : " + (ForesterUtil.isEmpty(phylogeny2.getName()) ? "" : phylogeny2.getName()));
        System.out.println("Gene tree name                           : " + (ForesterUtil.isEmpty(phylogeny2.getName()) ? "" : phylogeny2.getName()));
        easyWriter.println("Species tree file                        : " + file2.getCanonicalPath());
        System.out.println("Species tree file                        : " + file2.getCanonicalPath());
        easyWriter.println("Species tree name                        : " + (ForesterUtil.isEmpty(phylogeny.getName()) ? "" : phylogeny2.getName()));
        System.out.println("Species tree name                        : " + (ForesterUtil.isEmpty(phylogeny.getName()) ? "" : phylogeny2.getName()));
        object2 = null;
        long l = new Date().getTime();
        try {
            if (bASE_ALGORITHM == BASE_ALGORITHM.GSDI) {
                System.out.println("Use most parsimonous duplication model   : " + bl);
                System.out.println("Allow stripping of gene tree nodes       : " + bl2);
                easyWriter.println("Use most parsimonous duplication model   : " + bl);
                easyWriter.println("Allow stripping of gene tree nodes       : " + bl2);
                easyWriter.flush();
                object2 = new GSDI(phylogeny2, phylogeny, bl, bl2, true);
            } else {
                System.out.println();
                System.out.println("Using SDIse algorithm");
                easyWriter.println("Using SDIse algorithm");
                easyWriter.flush();
                object2 = new SDIse(phylogeny2, phylogeny);
            }
        }
        catch (SDIException sDIException) {
            gsdi.fatalError("user error", sDIException.getLocalizedMessage(), easyWriter);
        }
        catch (IOException iOException) {
            gsdi.fatalError("error", iOException.toString(), easyWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            gsdi.fatalError("unexpected error", exception.toString(), easyWriter);
        }
        System.out.println("Running time (excluding I/O)             : " + (new Date().getTime() - l) + "ms");
        easyWriter.println("Running time (excluding I/O)             : " + (new Date().getTime() - l) + "ms");
        if (bASE_ALGORITHM == BASE_ALGORITHM.GSDI) {
            object = (GSDI)object2;
            System.out.println("Mapping based on                         : " + (Object)((Object)((GSDI)object).getTaxCompBase()));
            easyWriter.println("Mapping based on                         : " + (Object)((Object)((GSDI)object).getTaxCompBase()));
        }
        try {
            object = new PhylogenyWriter();
            ((PhylogenyWriter)object).toPhyloXML(file3, phylogeny2, 0);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write to [" + file3.getCanonicalPath() + "]: " + iOException.getMessage());
        }
        System.out.println("Wrote resulting gene tree to             : " + file3.getCanonicalPath());
        easyWriter.println("Wrote resulting gene tree to             : " + file3.getCanonicalPath());
        if (bASE_ALGORITHM == BASE_ALGORITHM.SDI) {
            ((SDI)object2).computeMappingCostL();
            System.out.println("Mapping cost                             : " + ((SDI)object2).computeMappingCostL());
            easyWriter.println("Mapping cost                             : " + ((SDI)object2).computeMappingCostL());
        } else if (bASE_ALGORITHM == BASE_ALGORITHM.GSDI) {
            object = (GSDI)object2;
            File file5 = new File(ForesterUtil.removeSuffix(file3.toString()) + SUFFIX_FOR_SPECIES_TREE_USED);
            try {
                PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
                phylogenyWriter.toPhyloXML(file5, ((SDI)object).getSpeciesTree(), 0);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "Failed to write to [" + file5.getCanonicalPath() + "]: " + iOException.getMessage());
            }
            System.out.println("Wrote (stripped) species tree to         : " + file5.getCanonicalPath());
            easyWriter.println("Wrote (stripped) species tree to         : " + file5.getCanonicalPath());
            if (((GSDI)object).getReMappedScientificNamesFromGeneTree() != null && !((GSDI)object).getReMappedScientificNamesFromGeneTree().isEmpty()) {
                System.out.println("Number of gene tree species remapped     : " + ((GSDI)object).getReMappedScientificNamesFromGeneTree().size());
                easyWriter.println("Number of gene tree species remapped     : " + ((GSDI)object).getReMappedScientificNamesFromGeneTree().size());
                gsdi.writeToRemappedFile(file3, ((GSDI)object).getReMappedScientificNamesFromGeneTree(), easyWriter);
            }
        }
        System.out.println("Number of external nodes in gene tree    : " + phylogeny2.getNumberOfExternalNodes());
        easyWriter.println("Number of external nodes in gene tree    : " + phylogeny2.getNumberOfExternalNodes());
        System.out.println("Number of external nodes in species tree : " + ((SDI)object2).getSpeciesTree().getNumberOfExternalNodes());
        easyWriter.println("Number of external nodes in species tree : " + ((SDI)object2).getSpeciesTree().getNumberOfExternalNodes());
        if (bASE_ALGORITHM == BASE_ALGORITHM.GSDI) {
            object = (GSDI)object2;
            int n = PhylogenyMethods.countNumberOfPolytomies(((SDI)object).getSpeciesTree());
            System.out.println("Number of polytomies in species tree     : " + n);
            easyWriter.println("Number of polytomies in species tree     : " + n);
            System.out.println("External nodes stripped from gene tree   : " + ((GSDI)object).getStrippedExternalGeneTreeNodes().size());
            easyWriter.println("External nodes stripped from gene tree   : " + ((GSDI)object).getStrippedExternalGeneTreeNodes().size());
            System.out.println("External nodes stripped from species tree: " + ((GSDI)object).getStrippedSpeciesTreeNodes().size());
            easyWriter.println("External nodes stripped from species tree: " + ((GSDI)object).getStrippedSpeciesTreeNodes().size());
        }
        System.out.println();
        System.out.println("Number of duplications                   : " + ((SDI)object2).getDuplicationsSum());
        easyWriter.println("Number of duplications                   : " + ((SDI)object2).getDuplicationsSum());
        if (bASE_ALGORITHM == BASE_ALGORITHM.GSDI) {
            object = (GSDI)object2;
            if (!bl) {
                int n = ((GSDI)object).getSpeciationOrDuplicationEventsSum();
                System.out.println("Number of potential duplications         : " + n);
                easyWriter.println("Number of potential duplications         : " + n);
            }
            System.out.println("Number of speciations                    : " + ((GSDI)object).getSpeciationsSum());
            easyWriter.println("Number of speciations                    : " + ((GSDI)object).getSpeciationsSum());
            easyWriter.println();
            gsdi.printMappedNodesToLog(easyWriter, (GSDI)object);
            easyWriter.println();
            gsdi.printStrippedGeneTreeNodesToLog(easyWriter, (GSDI)object);
        }
        System.out.println();
        System.out.println("Wrote log to                             : " + file4.getCanonicalPath());
        System.out.println();
        easyWriter.close();
    }

    private static void writeToRemappedFile(File file, SortedSet<String> sortedSet, EasyWriter easyWriter) throws IOException {
        File file2 = new File(ForesterUtil.removeSuffix(file.toString()) + REMAPPED_SUFFIX);
        EasyWriter easyWriter2 = ForesterUtil.createEasyWriter(file2);
        for (String string : sortedSet) {
            easyWriter2.println(string);
        }
        easyWriter2.close();
        System.out.println("Wrote remapped gene tree species to      : " + file2.getCanonicalPath());
        easyWriter.println("Wrote remapped gene tree species to      : " + file2.getCanonicalPath());
    }

    private static void printMappedNodesToLog(EasyWriter easyWriter, GSDI gSDI) throws IOException {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (PhylogenyNode object : gSDI.getMappedExternalSpeciesTreeNodes()) {
            treeSet.add(object.toString());
        }
        easyWriter.println("The following " + treeSet.size() + " species were used: ");
        for (String string : treeSet) {
            easyWriter.println("  " + string);
        }
    }

    private static void fatalError(String string, String string2, EasyWriter easyWriter) {
        try {
            easyWriter.flush();
            easyWriter.println();
            easyWriter.print(string.toUpperCase() + ": ");
            easyWriter.println(string2);
            easyWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ForesterUtil.fatalError(PRG_NAME, string2);
    }

    private static void printStrippedGeneTreeNodesToLog(EasyWriter easyWriter, GSDI gSDI) throws IOException {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (PhylogenyNode object : gSDI.getStrippedExternalGeneTreeNodes()) {
            String string = object.toString();
            if (treeMap.containsKey(string)) {
                treeMap.put(string, (Integer)treeMap.get(string) + 1);
                continue;
            }
            treeMap.put(string, 1);
        }
        easyWriter.println("The following " + treeMap.size() + " nodes were stripped from the gene tree: ");
        for (String string : treeMap.keySet()) {
            int n = (Integer)treeMap.get(string);
            if (n == 1) {
                easyWriter.println("  " + string);
                continue;
            }
            easyWriter.println("  " + string + " [" + n + "]");
        }
    }

    private static void print_help() {
        System.out.println("Usage: gsdi [-options] <gene tree in phyloXML format> <species tree> <outfile>");
        System.out.println();
        System.out.println("Options:");
        System.out.println(" -g: to allow stripping of gene tree nodes without a matching species");
        System.out.println(" -m: use most parimonious duplication model for GSDI: ");
        System.out.println("     assign nodes as speciations which would otherwise be assiged");
        System.out.println("     as potential duplications due to polytomies in the species tree");
        System.out.println(" -q: to allow species tree in other formats than phyloXML (i.e. Newick, NHX, Nexus)");
        System.out.println(" -b: to use SDIse algorithm instead of GSDI algorithm (for binary species trees)");
        System.out.println();
        System.out.println("Gene tree:");
        System.out.println(" in phyloXM format, with taxonomy and sequence data in appropriate fields");
        System.out.println();
        System.out.println("Species tree:");
        System.out.println(" in phyloXML format (unless option -q is used)");
        System.out.println();
        System.out.println("Example: gsdi -g gene_tree.xml tree_of_life.xml out.xml");
        System.out.println();
    }

    private static enum BASE_ALGORITHM {
        GSDI,
        SDI;

    }
}

