/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.forester.evoinference.distance.NeighborJoining;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.io.parsers.SymmetricalDistanceMatrixParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class nj {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String VERBOSE_OPTION = "v";
    private static final String UPPER_TRIANGLE_OPTION = "u";
    private static final String PRG_NAME = "nj";
    private static final String PRG_VERSION = "0.0.1";
    private static final String PRG_DATE = "2008.03.04";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/";

    public static void main(String[] stringArray) {
        String string;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HELP_OPTION_1);
        arrayList.add(HELP_OPTION_2);
        arrayList.add(VERBOSE_OPTION);
        arrayList.add(UPPER_TRIANGLE_OPTION);
        if (stringArray.length < 2) {
            nj.printHelp();
            System.exit(-1);
        }
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
            nj.printHelp();
            System.exit(0);
        }
        if (commandLineArguments.getNumberOfNames() != 2) {
            nj.printHelp();
            System.exit(-1);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (commandLineArguments.isOptionSet(VERBOSE_OPTION)) {
            bl = true;
        }
        if (commandLineArguments.isOptionSet(UPPER_TRIANGLE_OPTION)) {
            bl2 = true;
        }
        File file = commandLineArguments.getFile(0);
        File file2 = commandLineArguments.getFile(1);
        String string2 = ForesterUtil.isReadableFile(file);
        if (!ForesterUtil.isEmpty(string2)) {
            ForesterUtil.fatalError(PRG_NAME, "cannot read from infile [" + file + "]: " + string2);
        }
        if (file2.exists()) {
            ForesterUtil.fatalError(PRG_NAME, "outfile [" + file2 + "] already exists");
        }
        if (!ForesterUtil.isEmpty(string = ForesterUtil.isWritableFile(file2))) {
            ForesterUtil.fatalError(PRG_NAME, "cannot write to outfile [" + file2 + "]: " + string);
        }
        SymmetricalDistanceMatrixParser symmetricalDistanceMatrixParser = SymmetricalDistanceMatrixParser.createInstance();
        if (bl2) {
            symmetricalDistanceMatrixParser.setInputMatrixType(SymmetricalDistanceMatrixParser.InputMatrixType.UPPER_TRIANGLE);
        } else {
            symmetricalDistanceMatrixParser.setInputMatrixType(SymmetricalDistanceMatrixParser.InputMatrixType.LOWER_TRIANGLE);
        }
        DistanceMatrix[] distanceMatrixArray = null;
        try {
            distanceMatrixArray = symmetricalDistanceMatrixParser.parse(file);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read from infile [" + file + "]: " + iOException.getMessage());
        }
        if (bl) {
            System.out.println("nj > read " + distanceMatrixArray.length + " pairwise distance matrice(s) of size " + distanceMatrixArray[0].getSize());
        }
        ArrayList<Phylogeny> arrayList2 = new ArrayList<Phylogeny>();
        NeighborJoining neighborJoining = NeighborJoining.createInstance(bl);
        long l = new Date().getTime();
        for (DistanceMatrix distanceMatrix : distanceMatrixArray) {
            arrayList2.add(neighborJoining.execute((BasicSymmetricalDistanceMatrix)distanceMatrix));
        }
        long l2 = new Date().getTime();
        PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
        try {
            phylogenyWriter.toPhyloXML(file2, arrayList2, 1, ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write to outfile [" + file2 + "]: " + iOException.getMessage());
        }
        System.out.println();
        System.out.println("nj > OK [" + (l2 - l) + "ms]");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println();
        System.out.println("% java -cp forester.jar org.forester.applications.nj [options] <pairwise distances infile> <out file>");
        System.out.println();
        System.out.println(" Options: ");
        System.out.println("v: verbose on");
        System.out.println("u: upper triangle option on (lower triangle is default)");
        System.out.println();
    }
}

