/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.ArchaeopteryxE;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

final class ControlPanel
extends JPanel
implements ActionListener {
    private static final String RETURN_TO_SUPER_TREE_TEXT = "Back to Super Tree";
    static final Font jcb_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 9);
    static final Font js_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 9);
    static final Font jcb_bold_font = new Font(Configuration.getDefaultFontFamilyName(), 1, 9);
    private static final long serialVersionUID = -8463483932821545633L;
    private final MainPanel _mainpanel;
    private final Configuration _configuration;
    private JCheckBox _display_internal_data;
    private JCheckBox _show_node_names;
    private JCheckBox _show_taxo_code;
    private JCheckBox _write_confidence;
    private JCheckBox _show_events;
    private JCheckBox _color_acc_species;
    private JCheckBox _color_branches_cb;
    private JCheckBox _width_branches;
    private JCheckBox _show_domain_architectures;
    private JCheckBox _show_annotation;
    private JCheckBox _show_binary_characters;
    private JCheckBox _show_binary_character_counts;
    private JCheckBox _show_gene_names;
    private JCheckBox _show_gene_symbols;
    private JCheckBox _show_sequence_acc;
    private JCheckBox _node_desc_popup_cb;
    private JCheckBox _dynamically_hide_data;
    private JCheckBox _show_taxo_scientific_names;
    private JCheckBox _show_taxo_common_names;
    private JCheckBox _show_taxo_images_cb;
    private JCheckBox _color_according_to_annotation;
    private JCheckBox _display_as_phylogram_cb;
    private JCheckBox _seq_relation_confidence_switch;
    private JComboBox _show_sequence_relations;
    private JComboBox _sequence_relation_type_box;
    private JCheckBox _show_vector_data_cb;
    private JCheckBox _show_properties_cb;
    private JLabel _click_to_label;
    private JLabel _zoom_label;
    private JLabel _domain_display_label;
    private JComboBox _click_to_combobox;
    private Map<Integer, String> _all_click_to_names;
    private List<String> _click_to_names;
    private int _show_data_item;
    private int _collapse_cb_item;
    private int _reroot_cb_item;
    private int _swap_cb_item;
    private int _subtree_cb_item;
    private int _color_subtree_cb_item;
    private int _open_seq_web_item;
    private int _sort_descendents_item;
    private int _open_tax_web_item;
    private int _cut_subtree_item;
    private int _copy_subtree_item;
    private int _delete_node_or_subtree_item;
    private int _paste_subtree_item;
    private int _add_new_node_item;
    private int _edit_node_data_item;
    private int _blast_item;
    private JButton _zoom_in_x;
    private JButton _zoom_in_y;
    private JButton _zoom_out_x;
    private JButton _zoom_out_y;
    private JButton _show_whole;
    private JButton _order;
    private JButton _uncollapse_all;
    private JButton _zoom_in_domain_structure;
    private JButton _zoom_out_domain_structure;
    private JButton _decr_domain_structure_evalue_thr;
    private JButton _incr_domain_structure_evalue_thr;
    private JButton _return_to_super_tree;
    private JTextField _domain_structure_evalue_thr_tf;
    private JTextField _search_tf;
    private boolean _order_of_appearance;
    private boolean _color_branches;
    private NodeClickAction _action_when_node_clicked;
    private List<Boolean> _draw_phylogram;
    private Map<String, Color> _annotation_colors;
    private Map<String, Color> _species_colors;
    private JButton _search_reset_button;
    private JLabel _search_found_label;
    private Sequence _selected_query_seq;

    ControlPanel(MainPanel mainPanel, Configuration configuration) {
        this.init();
        this._mainpanel = mainPanel;
        this._configuration = configuration;
        if (!this._configuration.isUseNativeUI()) {
            this.setBackground(this.getConfiguration().getGuiBackgroundColor());
            this.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        this.setLayout(new GridLayout(0, 1, 2, 2));
        this._order_of_appearance = true;
        this.setupControls();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
            if (treePanel == null) {
                return;
            }
            if (actionEvent.getSource() == this._click_to_combobox) {
                this.setClickToAction(this._click_to_combobox.getSelectedIndex());
                this.getCurrentTreePanel().repaint();
            } else if (actionEvent.getSource() == this._show_binary_characters) {
                if (this._show_binary_character_counts != null && this._show_binary_characters.isSelected()) {
                    this._show_binary_character_counts.setSelected(false);
                }
                this.displayedPhylogenyMightHaveChanged(true);
            } else if (actionEvent.getSource() == this._show_binary_character_counts) {
                if (this._show_binary_characters != null && this._show_binary_character_counts.isSelected()) {
                    this._show_binary_characters.setSelected(false);
                }
                this.displayedPhylogenyMightHaveChanged(true);
            } else if (actionEvent.getSource() == this._color_according_to_annotation) {
                if (this._show_annotation != null && this._color_according_to_annotation.isSelected()) {
                    this._show_annotation.setSelected(true);
                }
                this.displayedPhylogenyMightHaveChanged(false);
            } else if (actionEvent.getSource() == this._show_annotation) {
                if (this._color_according_to_annotation != null && !this._show_annotation.isSelected()) {
                    this._color_according_to_annotation.setSelected(false);
                }
                this.displayedPhylogenyMightHaveChanged(false);
            } else if (treePanel != null && treePanel.getPhylogeny() != null) {
                if (actionEvent.getSource() == this.getDisplayAsPhylogramCb()) {
                    this.setDrawPhylogram(this.getDisplayAsPhylogramCb().isSelected());
                    this.showWhole();
                } else if (actionEvent.getSource() == this._zoom_in_x) {
                    this.zoomInX(1.25f, 1.2f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (actionEvent.getSource() == this._zoom_in_y) {
                    this.zoomInY(1.25f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (actionEvent.getSource() == this._zoom_out_x) {
                    this.zoomOutX(0.8f, 0.8333333f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (actionEvent.getSource() == this._zoom_out_y) {
                    this.zoomOutY(0.8f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (actionEvent.getSource() == this._show_whole) {
                    this.showWhole();
                } else if (actionEvent.getSource() == this._return_to_super_tree) {
                    this._mainpanel.getCurrentTreePanel().superTree();
                    this.showWhole();
                } else if (actionEvent.getSource() == this._order) {
                    PhylogenyMethods.DESCENDANT_SORT_PRIORITY dESCENDANT_SORT_PRIORITY = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY;
                    if (!(this.isShowTaxonomyScientificNames() || this.isShowTaxonomyCode() || this.isShowTaxonomyCommonNames())) {
                        if (this.isShowSequenceAcc() || this.isShowGeneNames() || this.isShowGeneSymbols()) {
                            dESCENDANT_SORT_PRIORITY = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.SEQUENCE;
                        } else if (this.isShowNodeNames()) {
                            dESCENDANT_SORT_PRIORITY = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME;
                        }
                    }
                    PhylogenyMethods.orderAppearance(treePanel.getPhylogeny().getRoot(), this._order_of_appearance, true, dESCENDANT_SORT_PRIORITY);
                    this._order_of_appearance = !this._order_of_appearance;
                    treePanel.setNodeInPreorderToNull();
                    treePanel.getPhylogeny().externalNodesHaveChanged();
                    treePanel.getPhylogeny().clearHashIdToNodeMap();
                    treePanel.getPhylogeny().recalculateNumberOfExternalDescendants(true);
                    treePanel.resetNodeIdToDistToLeafMap();
                    treePanel.setEdited(true);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (actionEvent.getSource() == this._uncollapse_all) {
                    this.uncollapseAll(treePanel);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (actionEvent.getSource() == this._zoom_in_domain_structure) {
                    this._mainpanel.getCurrentTreePanel().zoomInDomainStructure();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (actionEvent.getSource() == this._zoom_out_domain_structure) {
                    this._mainpanel.getCurrentTreePanel().zoomOutDomainStructure();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (actionEvent.getSource() == this._decr_domain_structure_evalue_thr) {
                    this._mainpanel.getCurrentTreePanel().decreaseDomainStructureEvalueThreshold();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (actionEvent.getSource() == this._incr_domain_structure_evalue_thr) {
                    this._mainpanel.getCurrentTreePanel().increaseDomainStructureEvalueThreshold();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (actionEvent.getSource() == this._search_tf) {
                    this.search();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else {
                    this.displayedPhylogenyMightHaveChanged(true);
                }
            }
            treePanel.requestFocus();
            treePanel.requestFocusInWindow();
            treePanel.requestFocus();
        }
        catch (Exception exception) {
            AptxUtil.unexpectedException(exception);
        }
        catch (Error error) {
            AptxUtil.unexpectedError(error);
        }
    }

    void activateButtonToReturnToSuperTree(int n) {
        if (--n > 0) {
            this._return_to_super_tree.setText("Back to Super Tree " + n);
        } else {
            this._return_to_super_tree.setText(RETURN_TO_SUPER_TREE_TEXT);
        }
        this._return_to_super_tree.setForeground(this.getConfiguration().getGuiCheckboxAndButtonActiveColor());
        this._return_to_super_tree.setEnabled(true);
    }

    void addButtons() {
        JLabel jLabel = new JLabel("");
        jLabel.setOpaque(false);
        this.add(jLabel);
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 0, 0));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1, 0, 0));
        if (!this.getConfiguration().isUseNativeUI()) {
            jPanel.setBackground(this.getBackground());
            jPanel2.setBackground(this.getBackground());
            jPanel3.setBackground(this.getBackground());
        }
        this._zoom_label = new JLabel("Zoom:");
        this.add(this._zoom_label);
        ControlPanel.customizeLabel(this._zoom_label, this.getConfiguration());
        this.add(jPanel);
        this.add(jPanel2);
        this.add(jPanel3);
        if (this.getConfiguration().isUseNativeUI()) {
            this._zoom_in_x = new JButton("+");
            this._zoom_out_x = new JButton("-");
        } else {
            this._zoom_in_x = new JButton("X+");
            this._zoom_out_x = new JButton("X-");
        }
        this._zoom_in_y = new JButton("Y+");
        this._zoom_out_y = new JButton("Y-");
        this._show_whole = new JButton("F");
        this._show_whole.setToolTipText("To fit the complete phylogeny to the current display size [Backspace]");
        this._zoom_in_x.setToolTipText("To zoom in horizontally [Shift+Right]");
        this._zoom_in_y.setToolTipText("To zoom in vertically [Shift+Up]");
        this._zoom_out_x.setToolTipText("To zoom out horizontally [Shift+Left]");
        this._zoom_out_y.setToolTipText("To zoom out vertically [Shift+Down]");
        if (this.getConfiguration().isUseNativeUI() && AptxUtil.isMac()) {
            this._zoom_out_x.setPreferredSize(new Dimension(55, 10));
            this._zoom_in_x.setPreferredSize(new Dimension(55, 10));
        } else {
            this._zoom_out_x.setPreferredSize(new Dimension(10, 10));
            this._zoom_in_x.setPreferredSize(new Dimension(10, 10));
        }
        this._zoom_out_y.setPreferredSize(new Dimension(10, 10));
        this._zoom_in_y.setPreferredSize(new Dimension(10, 10));
        this._show_whole.setPreferredSize(new Dimension(10, 10));
        this._return_to_super_tree = new JButton(RETURN_TO_SUPER_TREE_TEXT);
        this._return_to_super_tree.setEnabled(false);
        this._order = new JButton("Order Subtrees");
        this._uncollapse_all = new JButton("Uncollapse All");
        this.addJButton(this._zoom_in_y, jPanel);
        this.addJButton(this._zoom_out_x, jPanel2);
        this.addJButton(this._show_whole, jPanel2);
        this.addJButton(this._zoom_in_x, jPanel2);
        this.addJButton(this._zoom_out_y, jPanel3);
        if (this.getConfiguration().doDisplayOption(10)) {
            this.setUpControlsForDomainStrucures();
        }
        JLabel jLabel2 = new JLabel("");
        this.add(jLabel2);
        this.addJButton(this._return_to_super_tree, this);
        this.addJButton(this._order, this);
        this.addJButton(this._uncollapse_all, this);
        JLabel jLabel3 = new JLabel("");
        this.add(jLabel3);
        this.setVisibilityOfDomainStrucureControls();
    }

    void addCheckbox(int n, String string) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        switch (n) {
            case 0: {
                this._display_as_phylogram_cb = new JCheckBox(string);
                this.getDisplayAsPhylogramCb().setToolTipText("To switch between phylogram and cladogram display");
                this.addJCheckBox(this.getDisplayAsPhylogramCb(), jPanel);
                this.add(jPanel);
                break;
            }
            case 15: {
                this._display_internal_data = new JCheckBox(string);
                this._display_internal_data.setToolTipText("To allow or disallow display of internal labels");
                this.addJCheckBox(this._display_internal_data, jPanel);
                this.add(jPanel);
                break;
            }
            case 6: {
                this._color_acc_species = new JCheckBox(string);
                this._color_acc_species.setToolTipText("To colorize taxonomy and sequence labels as a function of taxonomy");
                this.addJCheckBox(this._color_acc_species, jPanel);
                this.add(jPanel);
                break;
            }
            case 19: {
                this._color_according_to_annotation = new JCheckBox(string);
                this._color_according_to_annotation.setToolTipText("To colorize sequence annotation labels as a function of sequence annotation");
                this.addJCheckBox(this._color_according_to_annotation, jPanel);
                this.add(jPanel);
                break;
            }
            case 1: {
                this._show_node_names = new JCheckBox(string);
                this.addJCheckBox(this._show_node_names, jPanel);
                this.add(jPanel);
                break;
            }
            case 17: {
                this._show_taxo_scientific_names = new JCheckBox(string);
                this.addJCheckBox(this._show_taxo_scientific_names, jPanel);
                this.add(jPanel);
                break;
            }
            case 18: {
                this._show_taxo_common_names = new JCheckBox(string);
                this.addJCheckBox(this._show_taxo_common_names, jPanel);
                this.add(jPanel);
                break;
            }
            case 2: {
                this._show_taxo_code = new JCheckBox(string);
                this.addJCheckBox(this._show_taxo_code, jPanel);
                this.add(jPanel);
                break;
            }
            case 24: {
                this._show_taxo_images_cb = new JCheckBox(string);
                this.addJCheckBox(this._show_taxo_images_cb, jPanel);
                this.add(jPanel);
                break;
            }
            case 11: {
                this._show_binary_characters = new JCheckBox(string);
                this.addJCheckBox(this._show_binary_characters, jPanel);
                this.add(jPanel);
                break;
            }
            case 3: {
                this._show_annotation = new JCheckBox(string);
                this.addJCheckBox(this._show_annotation, jPanel);
                this.add(jPanel);
                break;
            }
            case 12: {
                this._show_binary_character_counts = new JCheckBox(string);
                this.addJCheckBox(this._show_binary_character_counts, jPanel);
                this.add(jPanel);
                break;
            }
            case 4: {
                this._write_confidence = new JCheckBox(string);
                this.addJCheckBox(this.getWriteConfidenceCb(), jPanel);
                this.add(jPanel);
                break;
            }
            case 5: {
                this._show_events = new JCheckBox(string);
                this.addJCheckBox(this.getShowEventsCb(), jPanel);
                this.add(jPanel);
                break;
            }
            case 7: {
                this._color_branches_cb = new JCheckBox(string);
                this.getColorBranchesCb().setToolTipText("To use branch color values, if present");
                this.addJCheckBox(this.getColorBranchesCb(), jPanel);
                this.add(jPanel);
                break;
            }
            case 8: {
                this._width_branches = new JCheckBox(string);
                this._width_branches.setToolTipText("To use branch width values, if present");
                this.addJCheckBox(this._width_branches, jPanel);
                this.add(jPanel);
                break;
            }
            case 10: {
                this._show_domain_architectures = new JCheckBox(string);
                this.addJCheckBox(this._show_domain_architectures, jPanel);
                this.add(jPanel);
                break;
            }
            case 13: {
                this._show_gene_names = new JCheckBox(string);
                this.addJCheckBox(this._show_gene_names, jPanel);
                this.add(jPanel);
                break;
            }
            case 20: {
                this._show_gene_symbols = new JCheckBox(string);
                this.addJCheckBox(this._show_gene_symbols, jPanel);
                this.add(jPanel);
                break;
            }
            case 14: {
                this._show_sequence_acc = new JCheckBox(string);
                this.addJCheckBox(this._show_sequence_acc, jPanel);
                this.add(jPanel);
                break;
            }
            case 16: {
                this._dynamically_hide_data = new JCheckBox(string);
                this.getDynamicallyHideData().setToolTipText("To hide labels depending on likely visibility");
                this.addJCheckBox(this.getDynamicallyHideData(), jPanel);
                this.add(jPanel);
                break;
            }
            case 21: {
                this._node_desc_popup_cb = new JCheckBox(string);
                this.getNodeDescPopupCb().setToolTipText("To enable mouse rollover display of basic node data");
                this.addJCheckBox(this.getNodeDescPopupCb(), jPanel);
                this.add(jPanel);
                break;
            }
            case 22: {
                this._seq_relation_confidence_switch = new JCheckBox(string);
                this.addJCheckBox(this._seq_relation_confidence_switch, jPanel);
                this.add(jPanel);
                break;
            }
            case 23: {
                this._show_vector_data_cb = new JCheckBox(string);
                this.addJCheckBox(this._show_vector_data_cb, jPanel);
                this.add(jPanel);
                break;
            }
            case 25: {
                this._show_properties_cb = new JCheckBox(string);
                this.addJCheckBox(this._show_properties_cb, jPanel);
                this.add(jPanel);
                break;
            }
            default: {
                throw new RuntimeException("unknown checkbox: " + n);
            }
        }
    }

    private void addClickToOption(int n, String string) {
        this._click_to_combobox.addItem(string);
        this._click_to_names.add(string);
        this._all_click_to_names.put(new Integer(n), string);
        if (!this._configuration.isUseNativeUI()) {
            this._click_to_combobox.setBackground(this.getConfiguration().getGuiButtonBackgroundColor());
            this._click_to_combobox.setForeground(this.getConfiguration().getGuiButtonTextColor());
        }
    }

    void addJButton(JButton jButton, JPanel jPanel) {
        jButton.setFocusPainted(false);
        jButton.setFont(jcb_font);
        if (!this._configuration.isUseNativeUI()) {
            jButton.setBorder(BorderFactory.createLineBorder(this.getConfiguration().getGuiButtonBorderColor()));
            jButton.setBackground(this.getConfiguration().getGuiButtonBackgroundColor());
            jButton.setForeground(this.getConfiguration().getGuiButtonTextColor());
        }
        jPanel.add(jButton);
        jButton.addActionListener(this);
    }

    void addJCheckBox(JCheckBox jCheckBox, JPanel jPanel) {
        jCheckBox.setFocusPainted(false);
        jCheckBox.setFont(jcb_font);
        if (!this._configuration.isUseNativeUI()) {
            jCheckBox.setBackground(this.getConfiguration().getGuiBackgroundColor());
            jCheckBox.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        jPanel.add((Component)jCheckBox, "Center");
        jCheckBox.addActionListener(this);
    }

    void addJTextField(JTextField jTextField, JPanel jPanel) {
        if (!this._configuration.isUseNativeUI()) {
            jTextField.setForeground(this.getConfiguration().getGuiBackgroundColor());
            jTextField.setFont(jcb_font);
        }
        jPanel.add(jTextField);
        jTextField.addActionListener(this);
    }

    private void addSequenceRelationBlock() {
        JLabel jLabel = new JLabel("");
        jLabel.setSize(1, 1);
        this.add(jLabel);
        JLabel jLabel2 = new JLabel("Sequence relations to display");
        JLabel jLabel3 = ControlPanel.customizeLabel(new JLabel("(type) "), this.getConfiguration());
        jLabel3.setFont(js_font.deriveFont(7));
        this.getSequenceRelationTypeBox().setFocusable(false);
        this._sequence_relation_type_box.setFont(js_font);
        if (!this._configuration.isUseNativeUI()) {
            this._sequence_relation_type_box.setBackground(this.getConfiguration().getGuiButtonBackgroundColor());
            this._sequence_relation_type_box.setForeground(this.getConfiguration().getGuiButtonTextColor());
        }
        this._sequence_relation_type_box.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = new DefaultListCellRenderer().getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null && object instanceof SequenceRelation.SEQUENCE_RELATION_TYPE) {
                    ((DefaultListCellRenderer)component).setText(SequenceRelation.getPrintableNameByType((SequenceRelation.SEQUENCE_RELATION_TYPE)((Object)object)));
                }
                return component;
            }
        });
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._sequence_relation_type_box.setMinimumSize(new Dimension(115, 17));
        this._sequence_relation_type_box.setPreferredSize(new Dimension(115, 20));
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBackground(this.getBackground());
        jPanel.add(jLabel3);
        jPanel.add(this._sequence_relation_type_box);
        this.add(ControlPanel.customizeLabel(jLabel2, this.getConfiguration()));
        this.add(jPanel);
        this.add(this.getSequenceRelationBox());
        if (this._configuration.doDisplayOption(22)) {
            this.addCheckbox(22, this._configuration.getDisplayTitle(22));
            this.setCheckbox(22, this._configuration.doCheckOption(22));
        }
    }

    void deactivateButtonToReturnToSuperTree() {
        this._return_to_super_tree.setText(RETURN_TO_SUPER_TREE_TEXT);
        this._return_to_super_tree.setForeground(this.getConfiguration().getGuiButtonTextColor());
        this._return_to_super_tree.setEnabled(false);
    }

    void displayedPhylogenyMightHaveChanged(boolean bl) {
        if (this._mainpanel != null && this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            if (this.getOptions().isShowOverview()) {
                this._mainpanel.getCurrentTreePanel().updateOvSizes();
            }
            this._mainpanel.getCurrentTreePanel().recalculateMaxDistanceToRoot();
            this.setVisibilityOfDomainStrucureControls();
            this.updateDomainStructureEvaluethresholdDisplay();
            this._mainpanel.getCurrentTreePanel().calculateScaleDistance();
            this._mainpanel.getCurrentTreePanel().calcMaxDepth();
            this._mainpanel.adjustJScrollPane();
            if (bl) {
                this._mainpanel.getCurrentTreePanel().initNodeData();
                this._mainpanel.getCurrentTreePanel().calculateLongestExtNodeInfo();
            }
            this._mainpanel.getCurrentTreePanel().repaint();
        }
    }

    void endClickToOptions() {
        this._click_to_combobox.addActionListener(this);
    }

    NodeClickAction getActionWhenNodeClicked() {
        return this._action_when_node_clicked;
    }

    Map<Integer, String> getAllClickToItems() {
        return this._all_click_to_names;
    }

    Map<String, Color> getAnnotationColors() {
        return this._annotation_colors;
    }

    public JCheckBox getColorBranchesCb() {
        return this._color_branches_cb;
    }

    public JCheckBox getColorAccSpeciesCb() {
        return this._color_acc_species;
    }

    Configuration getConfiguration() {
        return this._configuration;
    }

    TreePanel getCurrentTreePanel() {
        return this.getMainPanel().getCurrentTreePanel();
    }

    public JCheckBox getDisplayAsPhylogramCb() {
        return this._display_as_phylogram_cb;
    }

    public JCheckBox getDynamicallyHideData() {
        return this._dynamically_hide_data;
    }

    private List<Boolean> getIsDrawPhylogramList() {
        return this._draw_phylogram;
    }

    MainPanel getMainPanel() {
        return this._mainpanel;
    }

    public JCheckBox getNodeDescPopupCb() {
        return this._node_desc_popup_cb;
    }

    Options getOptions() {
        return this.getMainPanel().getOptions();
    }

    private JLabel getSearchFoundCountsLabel() {
        return this._search_found_label;
    }

    private JButton getSearchResetButton() {
        return this._search_reset_button;
    }

    JTextField getSearchTextField() {
        return this._search_tf;
    }

    public Sequence getSelectedQuerySequence() {
        return this._selected_query_seq;
    }

    public JComboBox getSequenceRelationBox() {
        if (this._show_sequence_relations == null) {
            this._show_sequence_relations = new JComboBox();
            this._show_sequence_relations.setFocusable(false);
            this._show_sequence_relations.setMaximumRowCount(20);
            this._show_sequence_relations.setFont(js_font);
            if (!this._configuration.isUseNativeUI()) {
                this._show_sequence_relations.setBackground(this.getConfiguration().getGuiButtonBackgroundColor());
                this._show_sequence_relations.setForeground(this.getConfiguration().getGuiButtonTextColor());
            }
            this._show_sequence_relations.addItem("-----");
            this._show_sequence_relations.setToolTipText("To display orthology information for selected query");
        }
        return this._show_sequence_relations;
    }

    public JComboBox getSequenceRelationTypeBox() {
        if (this._sequence_relation_type_box == null) {
            this._sequence_relation_type_box = new JComboBox();
            for (SequenceRelation.SEQUENCE_RELATION_TYPE sEQUENCE_RELATION_TYPE : SequenceRelation.SEQUENCE_RELATION_TYPE.values()) {
                this._sequence_relation_type_box.addItem(sEQUENCE_RELATION_TYPE);
            }
            this._sequence_relation_type_box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ControlPanel.this._mainpanel.getCurrentPhylogeny() != null) {
                        ControlPanel.this.setSequenceRelationQueries(ControlPanel.this.getMainPanel().getCurrentPhylogeny().getSequenceRelationQueries());
                    }
                }
            });
        }
        return this._sequence_relation_type_box;
    }

    public JCheckBox getShowEventsCb() {
        return this._show_events;
    }

    List<String> getSingleClickToNames() {
        return this._click_to_names;
    }

    Map<String, Color> getSpeciesColors() {
        return this._species_colors;
    }

    public JCheckBox getWriteConfidenceCb() {
        return this._write_confidence;
    }

    private void init() {
        this._draw_phylogram = new ArrayList<Boolean>();
        this.setSpeciesColors(new HashMap<String, Color>());
        this.setAnnotationColors(new HashMap<String, Color>());
    }

    boolean isAntialiasScreenText() {
        return true;
    }

    boolean isColorAccordingToAnnotation() {
        return this._color_according_to_annotation != null && this._color_according_to_annotation.isSelected();
    }

    boolean isColorAccordingToTaxonomy() {
        return this._color_acc_species != null && this._color_acc_species.isSelected();
    }

    boolean isColorBranches() {
        return this.getColorBranchesCb() != null && this.getColorBranchesCb().isSelected() || this.getColorBranchesCb() == null && this._color_branches;
    }

    boolean isDrawPhylogram() {
        return this.isDrawPhylogram(this.getMainPanel().getCurrentTabIndex());
    }

    private boolean isDrawPhylogram(int n) {
        return this.getIsDrawPhylogramList().get(n);
    }

    boolean isDynamicallyHideData() {
        return this.getDynamicallyHideData() != null && this.getDynamicallyHideData().isSelected();
    }

    boolean isEvents() {
        return this.getShowEventsCb() != null && this.getShowEventsCb().isSelected();
    }

    boolean isNodeDescPopup() {
        return this.getNodeDescPopupCb() != null && this.getNodeDescPopupCb().isSelected();
    }

    boolean isShowAnnotation() {
        return this._show_annotation != null && this._show_annotation.isSelected();
    }

    boolean isShowBinaryCharacterCounts() {
        return this._show_binary_character_counts != null && this._show_binary_character_counts.isSelected();
    }

    boolean isShowBinaryCharacters() {
        return this._show_binary_characters != null && this._show_binary_characters.isSelected();
    }

    boolean isShowConfidenceValues() {
        return this.getWriteConfidenceCb() != null && this.getWriteConfidenceCb().isSelected();
    }

    boolean isShowDomainArchitectures() {
        return this._show_domain_architectures != null && this._show_domain_architectures.isSelected();
    }

    boolean isShowGeneNames() {
        return this._show_gene_names != null && this._show_gene_names.isSelected();
    }

    public boolean isShowVectorData() {
        return this._show_vector_data_cb != null && this._show_vector_data_cb.isSelected();
    }

    public boolean isShowProperties() {
        return this._show_properties_cb != null && this._show_properties_cb.isSelected();
    }

    boolean isShowGeneSymbols() {
        return this._show_gene_symbols != null && this._show_gene_symbols.isSelected();
    }

    boolean isShowInternalData() {
        return this._display_internal_data == null || this._display_internal_data.isSelected();
    }

    boolean isShowNodeNames() {
        return this._show_node_names != null && this._show_node_names.isSelected();
    }

    boolean isShowSequenceAcc() {
        return this._show_sequence_acc != null && this._show_sequence_acc.isSelected();
    }

    boolean isShowSequenceRelationConfidence() {
        return this._seq_relation_confidence_switch != null && this._seq_relation_confidence_switch.isSelected();
    }

    boolean isShowSequenceRelations() {
        return this._show_sequence_relations != null && this._show_sequence_relations.getSelectedIndex() > 0;
    }

    boolean isShowTaxonomyCode() {
        return this._show_taxo_code != null && this._show_taxo_code.isSelected();
    }

    public boolean isShowTaxonomyImages() {
        return this._show_taxo_images_cb != null && this._show_taxo_images_cb.isSelected();
    }

    boolean isShowTaxonomyCommonNames() {
        return this._show_taxo_common_names != null && this._show_taxo_common_names.isSelected();
    }

    boolean isShowTaxonomyScientificNames() {
        return this._show_taxo_scientific_names != null && this._show_taxo_scientific_names.isSelected();
    }

    boolean isWidthBranches() {
        return this._width_branches != null && this._width_branches.isSelected();
    }

    void phylogenyAdded(Configuration configuration) {
        this.getIsDrawPhylogramList().add(configuration.isDrawAsPhylogram());
    }

    void phylogenyRemoved(int n) {
        this.getIsDrawPhylogramList().remove(n);
    }

    void search() {
        MainPanel mainPanel = this.getMainPanel();
        Phylogeny phylogeny = mainPanel.getCurrentPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return;
        }
        String string = this.getSearchTextField().getText();
        if (string != null) {
            string = string.trim();
        } else {
            this.getSearchFoundCountsLabel().setVisible(false);
            this.getSearchResetButton().setEnabled(false);
            this.getSearchResetButton().setVisible(false);
            this.searchReset();
        }
        if (!ForesterUtil.isEmpty(string)) {
            this.search(mainPanel, phylogeny, string);
        } else {
            this.getSearchFoundCountsLabel().setVisible(false);
            this.getSearchResetButton().setEnabled(false);
            this.getSearchResetButton().setVisible(false);
            this.searchReset();
        }
    }

    private void search(MainPanel mainPanel, Phylogeny phylogeny, String string) {
        Object object;
        this.getSearchFoundCountsLabel().setVisible(true);
        this.getSearchResetButton().setEnabled(true);
        this.getSearchResetButton().setVisible(true);
        String[] stringArray = null;
        Object object2 = null;
        stringArray = string.indexOf(44) >= 0 ? string.split(",+") : new String[]{string.trim()};
        if (stringArray != null && stringArray.length > 0) {
            object2 = new ArrayList();
            for (String string2 : stringArray) {
                if (ForesterUtil.isEmpty(string2)) continue;
                String string3 = string2.trim();
                if (string3.indexOf(43) >= 0) {
                    object2.addAll(PhylogenyMethods.searchDataLogicalAnd(string3.split("\\++"), phylogeny, this.getOptions().isSearchCaseSensitive(), !this.getOptions().isMatchWholeTermsOnly()));
                    continue;
                }
                object2.addAll(PhylogenyMethods.searchData(string3, phylogeny, this.getOptions().isSearchCaseSensitive(), !this.getOptions().isMatchWholeTermsOnly()));
            }
            if (this.getOptions().isInverseSearchResult()) {
                object = PhylogenyMethods.obtainAllNodesAsList(phylogeny);
                object.removeAll((Collection<?>)object2);
                object2 = object;
            }
        }
        if (object2 != null && object2.size() > 0) {
            mainPanel.getCurrentTreePanel().setFoundNodes(new HashSet<Integer>());
            object = object2.iterator();
            while (object.hasNext()) {
                PhylogenyNode phylogenyNode = (PhylogenyNode)object.next();
                mainPanel.getCurrentTreePanel().getFoundNodes().add(phylogenyNode.getId());
            }
            this.setSearchFoundCountsOnLabel(object2.size());
        } else {
            this.setSearchFoundCountsOnLabel(0);
            this.searchReset();
        }
    }

    private void searchReset() {
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            this.getMainPanel().getCurrentTreePanel().setFoundNodes(null);
        }
    }

    void setActionWhenNodeClicked(NodeClickAction nodeClickAction) {
        this._action_when_node_clicked = nodeClickAction;
    }

    void setAnnotationColors(Map<String, Color> map) {
        this._annotation_colors = map;
    }

    void setCheckbox(int n, boolean bl) {
        switch (n) {
            case 0: {
                if (this.getDisplayAsPhylogramCb() == null) break;
                this.getDisplayAsPhylogramCb().setSelected(bl);
                break;
            }
            case 15: {
                if (this._display_internal_data == null) break;
                this._display_internal_data.setSelected(bl);
                break;
            }
            case 6: {
                if (this._color_acc_species == null) break;
                this._color_acc_species.setSelected(bl);
                break;
            }
            case 19: {
                if (this._color_according_to_annotation == null) break;
                this._color_according_to_annotation.setSelected(bl);
                break;
            }
            case 1: {
                if (this._show_node_names == null) break;
                this._show_node_names.setSelected(bl);
                break;
            }
            case 17: {
                if (this._show_taxo_scientific_names == null) break;
                this._show_taxo_scientific_names.setSelected(bl);
                break;
            }
            case 18: {
                if (this._show_taxo_common_names == null) break;
                this._show_taxo_common_names.setSelected(bl);
                break;
            }
            case 2: {
                if (this._show_taxo_code == null) break;
                this._show_taxo_code.setSelected(bl);
                break;
            }
            case 24: {
                if (this._show_taxo_images_cb == null) break;
                this._show_taxo_images_cb.setSelected(bl);
                break;
            }
            case 3: {
                if (this._show_annotation == null) break;
                this._show_annotation.setSelected(bl);
                break;
            }
            case 11: {
                if (this._show_binary_characters == null) break;
                this._show_binary_characters.setSelected(bl);
                break;
            }
            case 12: {
                if (this._show_binary_character_counts == null) break;
                this._show_binary_character_counts.setSelected(bl);
                break;
            }
            case 4: {
                if (this.getWriteConfidenceCb() == null) break;
                this.getWriteConfidenceCb().setSelected(bl);
                break;
            }
            case 5: {
                if (this.getShowEventsCb() == null) break;
                this.getShowEventsCb().setSelected(bl);
                break;
            }
            case 7: {
                if (this.getColorBranchesCb() == null) break;
                this.getColorBranchesCb().setSelected(bl);
                break;
            }
            case 8: {
                if (this._width_branches == null) break;
                this._width_branches.setSelected(bl);
                break;
            }
            case 10: {
                if (this._show_domain_architectures == null) break;
                this._show_domain_architectures.setSelected(bl);
                break;
            }
            case 13: {
                if (this._show_gene_names == null) break;
                this._show_gene_names.setSelected(bl);
                break;
            }
            case 20: {
                if (this._show_gene_symbols == null) break;
                this._show_gene_symbols.setSelected(bl);
                break;
            }
            case 23: {
                if (this._show_vector_data_cb == null) break;
                this._show_vector_data_cb.setSelected(bl);
                break;
            }
            case 25: {
                if (this._show_properties_cb == null) break;
                this._show_properties_cb.setSelected(bl);
                break;
            }
            case 14: {
                if (this._show_sequence_acc == null) break;
                this._show_sequence_acc.setSelected(bl);
                break;
            }
            case 16: {
                if (this.getDynamicallyHideData() == null) break;
                this.getDynamicallyHideData().setSelected(bl);
                break;
            }
            case 21: {
                if (this.getNodeDescPopupCb() == null) break;
                this.getNodeDescPopupCb().setSelected(bl);
                break;
            }
            case 22: {
                if (this._seq_relation_confidence_switch == null) break;
                this._seq_relation_confidence_switch.setSelected(bl);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown checkbox: " + n));
            }
        }
    }

    void setCheckbox(JCheckBox jCheckBox, boolean bl) {
        if (jCheckBox != null) {
            jCheckBox.setSelected(bl);
        }
    }

    void setClickToAction(int n) {
        if (n == this._show_data_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SHOW_DATA);
        } else if (n == this._collapse_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COLLAPSE);
        } else if (n == this._reroot_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.REROOT);
        } else if (n == this._subtree_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SUBTREE);
        } else if (n == this._swap_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SWAP);
        } else if (n == this._color_subtree_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COLOR_SUBTREE);
        } else if (n == this._open_seq_web_item) {
            this.setActionWhenNodeClicked(NodeClickAction.OPEN_SEQ_WEB);
        } else if (n == this._sort_descendents_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SORT_DESCENDENTS);
        } else if (n == this._blast_item) {
            this.setActionWhenNodeClicked(NodeClickAction.BLAST);
        } else if (n == this._open_tax_web_item) {
            this.setActionWhenNodeClicked(NodeClickAction.OPEN_TAX_WEB);
        } else if (n == this._cut_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.CUT_SUBTREE);
        } else if (n == this._copy_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COPY_SUBTREE);
        } else if (n == this._delete_node_or_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.DELETE_NODE_OR_SUBTREE);
        } else if (n == this._paste_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.PASTE_SUBTREE);
        } else if (n == this._add_new_node_item) {
            this.setActionWhenNodeClicked(NodeClickAction.ADD_NEW_NODE);
        } else if (n == this._edit_node_data_item) {
            this.setActionWhenNodeClicked(NodeClickAction.EDIT_NODE_DATA);
        } else {
            throw new RuntimeException("unknown action: " + n);
        }
        this._click_to_combobox.setSelectedIndex(n);
    }

    void setColorBranches(boolean bl) {
        this._color_branches = bl;
    }

    void setDrawPhylogram(boolean bl) {
        this.getDisplayAsPhylogramCb().setSelected(bl);
        this.setDrawPhylogram(this.getMainPanel().getCurrentTabIndex(), bl);
    }

    private void setDrawPhylogram(int n, boolean bl) {
        this.getIsDrawPhylogramList().set(n, bl);
    }

    void setDrawPhylogramEnabled(boolean bl) {
        this.getDisplayAsPhylogramCb().setEnabled(bl);
    }

    void setDynamicHidingIsOn(boolean bl) {
        if (bl) {
            this.getDynamicallyHideData().setForeground(this.getConfiguration().getGuiCheckboxAndButtonActiveColor());
        } else if (!this._configuration.isUseNativeUI()) {
            this.getDynamicallyHideData().setForeground(this.getConfiguration().getGuiButtonTextColor());
        } else {
            this.getDynamicallyHideData().setForeground(Color.BLACK);
        }
    }

    private void setSearchFoundCountsOnLabel(int n) {
        this.getSearchFoundCountsLabel().setText("Found: " + n);
    }

    public void setSequenceRelationQueries(Collection<Sequence> collection) {
        JComboBox jComboBox = this.getSequenceRelationBox();
        while (jComboBox.getItemCount() > 1) {
            jComboBox.removeItemAt(1);
        }
        final HashMap<String, Sequence> hashMap = new HashMap<String, Sequence>();
        SequenceRelation.SEQUENCE_RELATION_TYPE sEQUENCE_RELATION_TYPE = (SequenceRelation.SEQUENCE_RELATION_TYPE)((Object)this._sequence_relation_type_box.getSelectedItem());
        if (sEQUENCE_RELATION_TYPE == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Sequence objectArray : collection) {
            if (!objectArray.hasSequenceRelations()) continue;
            int n = 0;
            for (SequenceRelation sequenceRelation : objectArray.getSequenceRelations()) {
                if (!sequenceRelation.getType().equals((Object)sEQUENCE_RELATION_TYPE)) continue;
                n = 1;
                break;
            }
            if (n == 0) continue;
            arrayList.add(objectArray.getName());
            hashMap.put(objectArray.getName(), objectArray);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        for (String string : stringArray) {
            jComboBox.addItem(string);
        }
        for (ItemListener itemListener : jComboBox.getItemListeners()) {
            jComboBox.removeItemListener(itemListener);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ControlPanel.this._selected_query_seq = (Sequence)hashMap.get(itemEvent.getItem());
                ControlPanel.this._mainpanel.getCurrentTreePanel().repaint();
            }
        });
    }

    void setShowEvents(boolean bl) {
        if (this.getShowEventsCb() == null) {
            this._show_events = new JCheckBox("");
        }
        this.getShowEventsCb().setSelected(bl);
    }

    void setSpeciesColors(Map<String, Color> map) {
        this._species_colors = map;
    }

    private void setupClickToOptions() {
        int n = this._configuration.getDefaultDisplayClicktoOption();
        int n2 = 0;
        int n3 = 0;
        if (this._configuration.doDisplayClickToOption(0)) {
            this._show_data_item = n3;
            this.addClickToOption(0, this._configuration.getClickToTitle(0));
            if (n == 0) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(1)) {
            this._collapse_cb_item = n3;
            this.addClickToOption(1, this._configuration.getClickToTitle(1));
            if (n == 1) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(2)) {
            this._reroot_cb_item = n3;
            this.addClickToOption(2, this._configuration.getClickToTitle(2));
            if (n == 2) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(3)) {
            this._subtree_cb_item = n3;
            this.addClickToOption(3, this._configuration.getClickToTitle(3));
            if (n == 3) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(4)) {
            this._swap_cb_item = n3;
            this.addClickToOption(4, this._configuration.getClickToTitle(4));
            if (n == 4) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(15)) {
            this._sort_descendents_item = n3;
            this.addClickToOption(15, this._configuration.getClickToTitle(15));
            if (n == 15) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(5)) {
            this._color_subtree_cb_item = n3;
            this.addClickToOption(5, this._configuration.getClickToTitle(5));
            if (n == 5) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(6)) {
            this._open_seq_web_item = n3;
            this.addClickToOption(6, this._configuration.getClickToTitle(6));
            if (n == 6) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(7)) {
            this._open_tax_web_item = n3;
            this.addClickToOption(7, this._configuration.getClickToTitle(7));
            if (n == 7) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(8)) {
            this._blast_item = n3;
            this.addClickToOption(8, this._configuration.getClickToTitle(8));
            if (n == 8) {
                n2 = n3;
            }
            ++n3;
        }
        if (this.getOptions().isEditable()) {
            if (this._configuration.doDisplayClickToOption(9)) {
                this._cut_subtree_item = n3;
                this.addClickToOption(9, this._configuration.getClickToTitle(9));
                if (n == 9) {
                    n2 = n3;
                }
                ++n3;
            }
            if (this._configuration.doDisplayClickToOption(10)) {
                this._copy_subtree_item = n3;
                this.addClickToOption(10, this._configuration.getClickToTitle(10));
                if (n == 10) {
                    n2 = n3;
                }
                ++n3;
            }
            if (this._configuration.doDisplayClickToOption(11)) {
                this._paste_subtree_item = n3;
                this.addClickToOption(11, this._configuration.getClickToTitle(11));
                if (n == 11) {
                    n2 = n3;
                }
                ++n3;
            }
            if (this._configuration.doDisplayClickToOption(12)) {
                this._delete_node_or_subtree_item = n3;
                this.addClickToOption(12, this._configuration.getClickToTitle(12));
                if (n == 12) {
                    n2 = n3;
                }
                ++n3;
            }
            if (this._configuration.doDisplayClickToOption(13)) {
                this._add_new_node_item = n3;
                this.addClickToOption(13, this._configuration.getClickToTitle(13));
                if (n == 13) {
                    n2 = n3;
                }
                ++n3;
            }
            if (this._configuration.doDisplayClickToOption(14)) {
                this._edit_node_data_item = n3;
                this.addClickToOption(14, this._configuration.getClickToTitle(14));
                if (n == 14) {
                    n2 = n3;
                }
                ++n3;
            }
        }
        this._click_to_combobox.setSelectedIndex(n2);
        this.setClickToAction(n2);
    }

    void setupControls() {
        this.setupDisplayCheckboxes();
        if (this._configuration.displaySequenceRelations()) {
            this.addSequenceRelationBlock();
        }
        this.startClickToOptions();
        this.setupClickToOptions();
        this.endClickToOptions();
        this.addButtons();
        this.setupSearchTools();
    }

    void setUpControlsForDomainStrucures() {
        this._domain_display_label = new JLabel("Domain Display:");
        this.add(ControlPanel.customizeLabel(this._domain_display_label, this.getConfiguration()));
        this.add(this._domain_display_label);
        this._zoom_in_domain_structure = new JButton("d+");
        this._zoom_out_domain_structure = new JButton("d-");
        this._decr_domain_structure_evalue_thr = new JButton("-");
        this._incr_domain_structure_evalue_thr = new JButton("+");
        this._zoom_in_domain_structure.setPreferredSize(new Dimension(10, 10));
        this._zoom_out_domain_structure.setPreferredSize(new Dimension(10, 10));
        this._decr_domain_structure_evalue_thr.setPreferredSize(new Dimension(10, 10));
        this._incr_domain_structure_evalue_thr.setPreferredSize(new Dimension(10, 10));
        this._incr_domain_structure_evalue_thr.setToolTipText("Increase the E-value threshold by a factor of 10");
        this._decr_domain_structure_evalue_thr.setToolTipText("Decrease the E-value threshold by a factor of 10");
        this._domain_structure_evalue_thr_tf = new JTextField(3);
        this._domain_structure_evalue_thr_tf.setEditable(false);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._domain_structure_evalue_thr_tf.setForeground(this.getConfiguration().getGuiMenuBackgroundColor());
            this._domain_structure_evalue_thr_tf.setBackground(this.getConfiguration().getGuiCheckboxTextColor());
            this._domain_structure_evalue_thr_tf.setBorder(null);
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 0, 0));
        if (!this._configuration.isUseNativeUI()) {
            jPanel.setBackground(this.getBackground());
            jPanel2.setBackground(this.getBackground());
        }
        this.add(jPanel);
        this.add(jPanel2);
        this.addJButton(this._zoom_out_domain_structure, jPanel);
        this.addJButton(this._zoom_in_domain_structure, jPanel);
        this.addJButton(this._decr_domain_structure_evalue_thr, jPanel2);
        this.addJTextField(this._domain_structure_evalue_thr_tf, jPanel2);
        this.addJButton(this._incr_domain_structure_evalue_thr, jPanel2);
    }

    private void setupDisplayCheckboxes() {
        if (this._configuration.doDisplayOption(0)) {
            this.addCheckbox(0, this._configuration.getDisplayTitle(0));
            this.setCheckbox(0, this._configuration.doCheckOption(0));
        }
        if (this._configuration.doDisplayOption(16)) {
            this.addCheckbox(16, this._configuration.getDisplayTitle(16));
            this.setCheckbox(16, this._configuration.doCheckOption(16));
        }
        if (this._configuration.doDisplayOption(21)) {
            this.addCheckbox(21, this._configuration.getDisplayTitle(21));
            this.setCheckbox(21, this._configuration.doCheckOption(21));
        }
        if (this._configuration.doDisplayOption(15)) {
            this.addCheckbox(15, this._configuration.getDisplayTitle(15));
            this.setCheckbox(15, this._configuration.doCheckOption(15));
        }
        if (this._configuration.doDisplayOption(6)) {
            this.addCheckbox(6, this._configuration.getDisplayTitle(6));
            this.setCheckbox(6, this._configuration.doCheckOption(6));
        }
        if (this._configuration.doDisplayOption(19)) {
            this.addCheckbox(19, this._configuration.getDisplayTitle(19));
            this.setCheckbox(19, this._configuration.doCheckOption(19));
        }
        if (this._configuration.doDisplayOption(7)) {
            this.addCheckbox(7, this._configuration.getDisplayTitle(7));
            this.setCheckbox(7, this._configuration.doCheckOption(7));
        }
        if (this._configuration.doDisplayOption(8)) {
            this.addCheckbox(8, this._configuration.getDisplayTitle(8));
            this.setCheckbox(8, this._configuration.doCheckOption(8));
        }
        JLabel jLabel = new JLabel("Display Data:");
        jLabel.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            jLabel.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this.add(jLabel);
        if (this._configuration.doDisplayOption(1)) {
            this.addCheckbox(1, this._configuration.getDisplayTitle(1));
            this.setCheckbox(1, this._configuration.doCheckOption(1));
        }
        if (this._configuration.doDisplayOption(2)) {
            this.addCheckbox(2, this._configuration.getDisplayTitle(2));
            this.setCheckbox(2, this._configuration.doCheckOption(2));
        }
        if (this._configuration.doDisplayOption(17)) {
            this.addCheckbox(17, this._configuration.getDisplayTitle(17));
            this.setCheckbox(17, this._configuration.doCheckOption(17));
        }
        if (this._configuration.doDisplayOption(18)) {
            this.addCheckbox(18, this._configuration.getDisplayTitle(18));
            this.setCheckbox(18, this._configuration.doCheckOption(18));
        }
        if (this._configuration.doDisplayOption(24)) {
            this.addCheckbox(24, this._configuration.getDisplayTitle(24));
            this.setCheckbox(24, this._configuration.doCheckOption(24));
        }
        if (this._configuration.doDisplayOption(20)) {
            this.addCheckbox(20, this._configuration.getDisplayTitle(20));
            this.setCheckbox(20, this._configuration.doCheckOption(20));
        }
        if (this._configuration.doDisplayOption(13)) {
            this.addCheckbox(13, this._configuration.getDisplayTitle(13));
            this.setCheckbox(13, this._configuration.doCheckOption(13));
        }
        if (this._configuration.doDisplayOption(14)) {
            this.addCheckbox(14, this._configuration.getDisplayTitle(14));
            this.setCheckbox(14, this._configuration.doCheckOption(14));
        }
        if (this._configuration.doDisplayOption(3)) {
            this.addCheckbox(3, this._configuration.getDisplayTitle(3));
            this.setCheckbox(3, this._configuration.doCheckOption(3));
        }
        if (this._configuration.doDisplayOption(11)) {
            this.addCheckbox(11, this._configuration.getDisplayTitle(11));
            this.setCheckbox(11, this._configuration.doCheckOption(11));
        }
        if (this._configuration.doDisplayOption(12)) {
            this.addCheckbox(12, this._configuration.getDisplayTitle(12));
            this.setCheckbox(12, this._configuration.doCheckOption(12));
        }
        if (this._configuration.doDisplayOption(10)) {
            this.addCheckbox(10, this._configuration.getDisplayTitle(10));
            this.setCheckbox(10, this._configuration.doCheckOption(10));
        }
        if (this._configuration.doDisplayOption(4)) {
            this.addCheckbox(4, this._configuration.getDisplayTitle(4));
            this.setCheckbox(4, this._configuration.doCheckOption(4));
        }
        if (this._configuration.doDisplayOption(5)) {
            this.addCheckbox(5, this._configuration.getDisplayTitle(5));
            this.setCheckbox(5, this._configuration.doCheckOption(5));
        }
        if (this._configuration.doDisplayOption(23)) {
            this.addCheckbox(23, this._configuration.getDisplayTitle(23));
            this.setCheckbox(23, this._configuration.doCheckOption(23));
        }
        if (this._configuration.doDisplayOption(25)) {
            this.addCheckbox(25, this._configuration.getDisplayTitle(25));
            this.setCheckbox(25, this._configuration.doCheckOption(25));
        }
    }

    void setupSearchTools() {
        JLabel jLabel = new JLabel("Search:");
        jLabel.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            jLabel.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this.add(jLabel);
        jLabel.setToolTipText("Enter text to search for. Use ',' for multiple searches (logical OR) and '+' for logical AND.");
        this._search_found_label = new JLabel();
        this.getSearchFoundCountsLabel().setVisible(false);
        this._search_found_label.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._search_found_label.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this._search_tf = new JTextField(3);
        this._search_tf.setToolTipText("Enter text to search for. Use ',' for multiple searches (logical OR) and '+' for logical AND.");
        this._search_tf.setEditable(true);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._search_tf.setForeground(this.getConfiguration().getGuiMenuBackgroundColor());
            this._search_tf.setBackground(this.getConfiguration().getGuiCheckboxTextColor());
            this._search_tf.setBorder(null);
        }
        this._search_reset_button = new JButton();
        this.getSearchResetButton().setText("Reset");
        this.getSearchResetButton().setEnabled(false);
        this.getSearchResetButton().setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 0, 0));
        jPanel.setBackground(this.getBackground());
        this.add(jPanel);
        jPanel2.setBackground(this.getBackground());
        this.add(jPanel2);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ControlPanel.this.search();
                ControlPanel.this.displayedPhylogenyMightHaveChanged(true);
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.searchReset();
                ControlPanel.this.setSearchFoundCountsOnLabel(0);
                ControlPanel.this.getSearchFoundCountsLabel().setVisible(false);
                ControlPanel.this.getSearchTextField().setText("");
                ControlPanel.this.getSearchResetButton().setEnabled(false);
                ControlPanel.this.getSearchResetButton().setVisible(false);
                ControlPanel.this.displayedPhylogenyMightHaveChanged(true);
            }
        };
        this._search_reset_button.addActionListener(actionListener);
        this._search_tf.addKeyListener(keyAdapter);
        this.addJTextField(this._search_tf, jPanel);
        jPanel2.add(this._search_found_label);
        this.addJButton(this._search_reset_button, jPanel2);
    }

    private void setVisibilityOfDomainStrucureControls() {
        if (this._zoom_in_domain_structure != null) {
            if (this.isShowDomainArchitectures()) {
                this._domain_display_label.setVisible(true);
                this._zoom_in_domain_structure.setVisible(true);
                this._zoom_out_domain_structure.setVisible(true);
                this._decr_domain_structure_evalue_thr.setVisible(true);
                this._incr_domain_structure_evalue_thr.setVisible(true);
                this._domain_structure_evalue_thr_tf.setVisible(true);
            } else {
                this._domain_display_label.setVisible(false);
                this._zoom_in_domain_structure.setVisible(false);
                this._zoom_out_domain_structure.setVisible(false);
                this._decr_domain_structure_evalue_thr.setVisible(false);
                this._incr_domain_structure_evalue_thr.setVisible(false);
                this._domain_structure_evalue_thr_tf.setVisible(false);
            }
        }
    }

    void showWhole() {
        if (this._mainpanel.getCurrentScrollPane() == null || this._mainpanel.getCurrentTreePanel().getPhylogeny().isEmpty()) {
            return;
        }
        this.getCurrentTreePanel().updateSetOfCollapsedExternalNodes();
        this.displayedPhylogenyMightHaveChanged(true);
        this._mainpanel.getCurrentTreePanel().updateOvSettings();
        this._mainpanel.getCurrentTreePanel().validate();
        this._mainpanel.validate();
        this._mainpanel.getCurrentTreePanel().setParametersForPainting(this._mainpanel.getSizeOfViewport().width, this._mainpanel.getSizeOfViewport().height, true);
        this._mainpanel.getCurrentTreePanel().resetPreferredSize();
        this._mainpanel.adjustJScrollPane();
        this._mainpanel.getCurrentTreePanel().repaint();
        this._mainpanel.getCurrentTreePanel().validate();
        this._mainpanel.validate();
        this._mainpanel.getCurrentTreePanel().setParametersForPainting(this._mainpanel.getSizeOfViewport().width, this._mainpanel.getSizeOfViewport().height, true);
        this._mainpanel.getCurrentTreePanel().resetPreferredSize();
        this._mainpanel.adjustJScrollPane();
        this._mainpanel.getCurrentTreePanel().repaint();
        this._mainpanel.getCurrentTreePanel().updateOvSizes();
    }

    void showWholeAll() {
        for (TreePanel treePanel : this._mainpanel.getTreePanels()) {
            if (treePanel == null) continue;
            treePanel.validate();
            treePanel.setParametersForPainting(this._mainpanel.getSizeOfViewport().width, this._mainpanel.getSizeOfViewport().height, true);
            treePanel.resetPreferredSize();
            treePanel.repaint();
        }
    }

    void startClickToOptions() {
        JLabel jLabel = new JLabel("");
        jLabel.setFont(jcb_font);
        this.add(jLabel);
        this._click_to_label = new JLabel("Click on Node to:");
        this.add(ControlPanel.customizeLabel(this._click_to_label, this.getConfiguration()));
        this._click_to_combobox = new JComboBox();
        this._click_to_combobox.setFocusable(false);
        this._click_to_combobox.setMaximumRowCount(14);
        this._click_to_combobox.setFont(js_font);
        if (!this._configuration.isUseNativeUI()) {
            this._click_to_combobox.setBackground(this.getConfiguration().getGuiBackgroundColor());
        }
        this.add(this._click_to_combobox);
        this._all_click_to_names = new HashMap<Integer, String>();
        this._click_to_names = new ArrayList<String>();
    }

    void tabChanged() {
        if (this.getMainPanel().getTabbedPane().getTabCount() > 0) {
            if (this.getCurrentTreePanel().isPhyHasBranchLengths() && this.getCurrentTreePanel().getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.setDrawPhylogramEnabled(true);
                this.setDrawPhylogram(this.isDrawPhylogram());
            } else {
                this.setDrawPhylogramEnabled(false);
                this.setDrawPhylogram(false);
            }
            if (this.getMainPanel().getMainFrame() == null) {
                ArchaeopteryxE archaeopteryxE = (ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet();
                archaeopteryxE.setSelectedTypeInTypeMenu(archaeopteryxE.getCurrentTreePanel().getPhylogenyGraphicsType());
            } else {
                this.getMainPanel().getMainFrame().setSelectedTypeInTypeMenu(this.getMainPanel().getCurrentTreePanel().getPhylogenyGraphicsType());
            }
            this.getMainPanel().getCurrentTreePanel().updateSubSuperTreeButton();
            this.getMainPanel().getControlPanel().search();
            this.getSequenceRelationTypeBox().removeAllItems();
            for (SequenceRelation.SEQUENCE_RELATION_TYPE sEQUENCE_RELATION_TYPE : this.getMainPanel().getCurrentPhylogeny().getRelevantSequenceRelationTypes()) {
                this._sequence_relation_type_box.addItem(sEQUENCE_RELATION_TYPE);
            }
        }
    }

    void uncollapseAll(TreePanel treePanel) {
        Phylogeny phylogeny = treePanel.getPhylogeny();
        if (phylogeny != null && !phylogeny.isEmpty()) {
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
            while (phylogenyNodeIterator.hasNext()) {
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                phylogenyNode.setCollapse(false);
            }
            treePanel.resetNodeIdToDistToLeafMap();
            treePanel.updateSetOfCollapsedExternalNodes();
            phylogeny.recalculateNumberOfExternalDescendants(false);
            treePanel.setNodeInPreorderToNull();
            phylogeny.clearHashIdToNodeMap();
            this.showWhole();
        }
    }

    void updateDomainStructureEvaluethresholdDisplay() {
        if (this._domain_structure_evalue_thr_tf != null) {
            this._domain_structure_evalue_thr_tf.setText("10^" + this.getMainPanel().getCurrentTreePanel().getDomainStructureEvalueThreshold());
        }
    }

    void zoomInX(float f, float f2) {
        JScrollBar jScrollBar = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar();
        TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
        treePanel.multiplyUrtFactor(1.0f);
        if (treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.isDrawPhylogram(this.getMainPanel().getCurrentTabIndex()) || this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP) {
            double d = (double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / ((double)jScrollBar.getValue() + (double)jScrollBar.getVisibleAmount() / 2.0);
            treePanel.setXdistance(treePanel.getXdistance() * f);
            treePanel.setXcorrectionFactor(treePanel.getXcorrectionFactor() * f2);
            this.getMainPanel().adjustJScrollPane();
            treePanel.resetPreferredSize();
            this.getMainPanel().getCurrentScrollPane().getViewport().validate();
            jScrollBar.setValue(ForesterUtil.roundToInt((double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / d - (double)jScrollBar.getVisibleAmount() / 2.0));
        } else {
            int n = jScrollBar.getMaximum() - jScrollBar.getMinimum() - jScrollBar.getVisibleAmount() - jScrollBar.getValue();
            treePanel.setXdistance(treePanel.getXdistance() * f);
            treePanel.setXcorrectionFactor(treePanel.getXcorrectionFactor() * f2);
            this.getMainPanel().adjustJScrollPane();
            treePanel.resetPreferredSize();
            this.getMainPanel().getCurrentScrollPane().getViewport().validate();
            jScrollBar.setValue(jScrollBar.getMaximum() - jScrollBar.getMinimum() - n - jScrollBar.getVisibleAmount());
        }
        treePanel.resetPreferredSize();
        treePanel.updateOvSizes();
    }

    void zoomInY(float f) {
        JScrollBar jScrollBar = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar();
        TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
        treePanel.multiplyUrtFactor(1.1f);
        double d = (double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / ((double)jScrollBar.getValue() + (double)jScrollBar.getVisibleAmount() / 2.0);
        treePanel.setYdistance(treePanel.getYdistance() * f);
        this.getMainPanel().adjustJScrollPane();
        treePanel.resetPreferredSize();
        this.getMainPanel().getCurrentScrollPane().getViewport().validate();
        jScrollBar.setValue(ForesterUtil.roundToInt((double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / d - (double)jScrollBar.getVisibleAmount() / 2.0));
        treePanel.resetPreferredSize();
        treePanel.updateOvSizes();
    }

    void zoomOutX(float f, float f2) {
        TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
        treePanel.multiplyUrtFactor(1.0f);
        if ((double)(treePanel.getXdistance() * f) > 0.0) {
            JScrollBar jScrollBar = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar();
            if (treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.isDrawPhylogram(this.getMainPanel().getCurrentTabIndex()) || this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP) {
                this.getMainPanel().adjustJScrollPane();
                treePanel.resetPreferredSize();
                this.getMainPanel().getCurrentScrollPane().getViewport().validate();
                double d = (double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / ((double)jScrollBar.getValue() + (double)jScrollBar.getVisibleAmount() / 2.0);
                treePanel.setXdistance(treePanel.getXdistance() * f);
                treePanel.setXcorrectionFactor(treePanel.getXcorrectionFactor() * f2);
                this.getMainPanel().adjustJScrollPane();
                treePanel.resetPreferredSize();
                this.getMainPanel().getCurrentScrollPane().getViewport().validate();
                jScrollBar.setValue(ForesterUtil.roundToInt((double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / d - (double)jScrollBar.getVisibleAmount() / 2.0));
            } else {
                int n = jScrollBar.getMaximum() - jScrollBar.getMinimum() - jScrollBar.getVisibleAmount() - jScrollBar.getValue();
                treePanel.setXdistance(treePanel.getXdistance() * f);
                treePanel.setXcorrectionFactor(treePanel.getXcorrectionFactor() * f2);
                if (n > 0) {
                    this.getMainPanel().adjustJScrollPane();
                    treePanel.resetPreferredSize();
                    this.getMainPanel().getCurrentScrollPane().getViewport().validate();
                    jScrollBar.setValue(jScrollBar.getMaximum() - jScrollBar.getMinimum() - n - jScrollBar.getVisibleAmount());
                }
            }
            treePanel.resetPreferredSize();
            treePanel.updateOvSizes();
        }
    }

    void zoomOutY(float f) {
        TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
        treePanel.multiplyUrtFactor(0.9f);
        if ((double)(treePanel.getYdistance() * f) > 0.0) {
            JScrollBar jScrollBar = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar();
            double d = (double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / ((double)jScrollBar.getValue() + (double)jScrollBar.getVisibleAmount() / 2.0);
            treePanel.setYdistance(treePanel.getYdistance() * f);
            this.getMainPanel().adjustJScrollPane();
            treePanel.resetPreferredSize();
            this.getMainPanel().getCurrentScrollPane().getViewport().validate();
            jScrollBar.setValue(ForesterUtil.roundToInt((double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / d - (double)jScrollBar.getVisibleAmount() / 2.0));
            treePanel.resetPreferredSize();
            treePanel.updateOvSizes();
        }
    }

    static JLabel customizeLabel(JLabel jLabel, Configuration configuration) {
        jLabel.setFont(jcb_bold_font);
        if (!configuration.isUseNativeUI()) {
            jLabel.setForeground(configuration.getGuiCheckboxTextColor());
            jLabel.setBackground(configuration.getGuiBackgroundColor());
        }
        return jLabel;
    }

    static enum NodeClickAction {
        SHOW_DATA,
        COLLAPSE,
        REROOT,
        SUBTREE,
        SWAP,
        COLOR_SUBTREE,
        OPEN_TAX_WEB,
        OPEN_SEQ_WEB,
        CUT_SUBTREE,
        COPY_SUBTREE,
        DELETE_NODE_OR_SUBTREE,
        PASTE_SUBTREE,
        ADD_NEW_NODE,
        EDIT_NODE_DATA,
        SORT_DESCENDENTS,
        BLAST;

    }
}

