/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringWriter;
import java.util.Date;
import org.forester.evoinference.distance.NeighborJoining;
import org.forester.evoinference.distance.PairwiseDistanceCalculator;
import org.forester.evoinference.matrix.character.BasicCharacterStateMatrix;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.evoinference.parsimony.DolloParsimony;
import org.forester.evoinference.parsimony.FitchParsimony;
import org.forester.io.parsers.GeneralMsaParser;
import org.forester.io.parsers.SymmetricalDistanceMatrixParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.msa.Msa;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.ForesterUtil;

public class TestPhylogenyReconstruction {
    private static final double ZERO_DIFF = 1.0E-9;
    private static final boolean TIME = false;

    public static boolean isEqual(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-9;
    }

    public static void main(String[] stringArray) {
        TestPhylogenyReconstruction.timeNeighborJoining();
    }

    public static boolean test(File file) {
        System.out.print("  Basic symmetrical distance matrix: ");
        if (!TestPhylogenyReconstruction.testBasicSymmetricalDistanceMatrix()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic character state matrix: ");
        if (!TestPhylogenyReconstruction.testBasicCharacterStateMatrix()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Symmetrical distance matrix parser: ");
        if (!TestPhylogenyReconstruction.testSymmetricalDistanceMatrixParser()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Distance Calculation: ");
        if (!TestPhylogenyReconstruction.testDistanceCalculationMethods(file)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Neighbor Joining: ");
        if (!TestPhylogenyReconstruction.testNeighborJoining()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Dollo Parsimony: ");
        if (!TestPhylogenyReconstruction.testDolloParsimony()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Dollo Parsimony on non binary trees: ");
        if (!TestPhylogenyReconstruction.testDolloParsimonyOnNonBinaryTree()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Fitch Parsimony: ");
        if (!TestPhylogenyReconstruction.testFitchParsimony()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        return true;
    }

    private static boolean testDistanceCalculationMethods(File file) {
        try {
            Msa msa = GeneralMsaParser.parse(new FileInputStream(file + ForesterUtil.FILE_SEPARATOR + "bcl.aln"));
            BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = PairwiseDistanceCalculator.calcKimuraDistances(msa);
            if (basicSymmetricalDistanceMatrix.getSize() != 120) {
                return false;
            }
            for (int i = 0; i < basicSymmetricalDistanceMatrix.getSize(); ++i) {
                if (TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(i, i), 0.0)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testBasicCharacterStateMatrix() {
        try {
            BasicCharacterStateMatrix<String> basicCharacterStateMatrix = new BasicCharacterStateMatrix<String>(4, 8);
            BasicCharacterStateMatrix<String> basicCharacterStateMatrix2 = new BasicCharacterStateMatrix<String>(4, 8);
            basicCharacterStateMatrix.setIdentifier(0, "A");
            basicCharacterStateMatrix.setIdentifier(1, "B");
            basicCharacterStateMatrix.setIdentifier(2, "C");
            basicCharacterStateMatrix.setIdentifier(3, "D");
            basicCharacterStateMatrix.setCharacter(0, "0");
            basicCharacterStateMatrix.setCharacter(1, "1");
            basicCharacterStateMatrix.setCharacter(2, "2");
            basicCharacterStateMatrix.setCharacter(3, "3");
            basicCharacterStateMatrix.setCharacter(4, "4");
            basicCharacterStateMatrix.setCharacter(5, "5");
            basicCharacterStateMatrix.setCharacter(6, "6");
            basicCharacterStateMatrix.setCharacter(7, "7");
            basicCharacterStateMatrix2.setIdentifier(0, "A");
            basicCharacterStateMatrix2.setIdentifier(1, "B");
            basicCharacterStateMatrix2.setIdentifier(2, "C");
            basicCharacterStateMatrix2.setIdentifier(3, "D");
            basicCharacterStateMatrix2.setCharacter(3, "3");
            basicCharacterStateMatrix2.setCharacter(4, "4");
            if (!basicCharacterStateMatrix.getCharacter(1).equals("1")) {
                return false;
            }
            if (!basicCharacterStateMatrix.getIdentifier(0).equals("A")) {
                return false;
            }
            basicCharacterStateMatrix.setState(0, 0, "00");
            basicCharacterStateMatrix2.setState(0, 0, "00");
            if (!((String)basicCharacterStateMatrix.getState(0, 0)).equals("00")) {
                return false;
            }
            basicCharacterStateMatrix.setState(0, 1, "01");
            basicCharacterStateMatrix2.setState(0, 1, "01");
            if (!((String)basicCharacterStateMatrix.getState(0, 1)).equals("01")) {
                return false;
            }
            basicCharacterStateMatrix.setState(1, 1, "11");
            basicCharacterStateMatrix2.setState(1, 1, "11");
            if (!((String)basicCharacterStateMatrix.getState(1, 1)).equals("11")) {
                return false;
            }
            basicCharacterStateMatrix.setState(1, 0, "10");
            basicCharacterStateMatrix2.setState(1, 0, "10");
            if (!((String)basicCharacterStateMatrix.getState(1, 0)).equals("10")) {
                return false;
            }
            basicCharacterStateMatrix.setState(1, 2, "12");
            basicCharacterStateMatrix2.setState(1, 2, "12");
            if (!((String)basicCharacterStateMatrix.getState(1, 2)).equals("12")) {
                return false;
            }
            basicCharacterStateMatrix.setState(3, 7, "37");
            basicCharacterStateMatrix2.setState(3, 7, "37");
            if (!((String)basicCharacterStateMatrix.getState(3, 7)).equals("37")) {
                return false;
            }
            basicCharacterStateMatrix.setState(2, 6, "26");
            basicCharacterStateMatrix2.setState(2, 6, "26");
            if (!((String)basicCharacterStateMatrix.getState(2, 6)).equals("26")) {
                return false;
            }
            basicCharacterStateMatrix.setState("D", "3", "33");
            basicCharacterStateMatrix2.setState("D", "3", "33");
            if (!((String)basicCharacterStateMatrix.getState(3, 3)).equals("33")) {
                return false;
            }
            if (!((String)basicCharacterStateMatrix.getState("D", "3")).equals("33")) {
                return false;
            }
            basicCharacterStateMatrix.setState("C", "4", "24");
            basicCharacterStateMatrix2.setState("C", "4", "24");
            if (!((String)basicCharacterStateMatrix.getState(2, 4)).equals("24")) {
                return false;
            }
            if (!((String)basicCharacterStateMatrix.getState("C", "4")).equals("24")) {
                return false;
            }
            if (basicCharacterStateMatrix.isEmpty()) {
                return false;
            }
            if (basicCharacterStateMatrix.getNumberOfIdentifiers() != 4) {
                return false;
            }
            if (basicCharacterStateMatrix.getNumberOfCharacters() != 8) {
                return false;
            }
            if (!((Object)basicCharacterStateMatrix).equals(basicCharacterStateMatrix)) {
                return false;
            }
            if (!((Object)basicCharacterStateMatrix).equals(basicCharacterStateMatrix2)) {
                return false;
            }
            basicCharacterStateMatrix2.setState("C", "4", "123");
            if (((Object)basicCharacterStateMatrix).equals(basicCharacterStateMatrix2)) {
                return false;
            }
            Integer[][] integerArrayArray = new Integer[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}};
            BasicCharacterStateMatrix<Integer> basicCharacterStateMatrix3 = new BasicCharacterStateMatrix<Integer>(integerArrayArray);
            basicCharacterStateMatrix3.toString();
            if (basicCharacterStateMatrix3.getNumberOfCharacters() != 4) {
                return false;
            }
            if (basicCharacterStateMatrix3.getNumberOfIdentifiers() != 3) {
                return false;
            }
            if ((Integer)basicCharacterStateMatrix3.getState(0, 1) != 2) {
                return false;
            }
            if ((Integer)basicCharacterStateMatrix3.getState(2, 3) != 12) {
                return false;
            }
            Integer[][] integerArrayArray2 = new Integer[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}};
            BasicCharacterStateMatrix<Integer> basicCharacterStateMatrix4 = new BasicCharacterStateMatrix<Integer>(integerArrayArray2);
            if (!((Object)basicCharacterStateMatrix3).equals(basicCharacterStateMatrix4)) {
                return false;
            }
            Integer[][] integerArrayArray3 = new Integer[][]{{1, 2, 3, -4}, {5, 6, 7, 8}, {9, 10, 11, 12}};
            BasicCharacterStateMatrix<Integer> basicCharacterStateMatrix5 = new BasicCharacterStateMatrix<Integer>(integerArrayArray3);
            if (((Object)basicCharacterStateMatrix3).equals(basicCharacterStateMatrix5)) {
                return false;
            }
            CharacterStateMatrix characterStateMatrix = basicCharacterStateMatrix.copy();
            CharacterStateMatrix characterStateMatrix2 = basicCharacterStateMatrix2.copy();
            if (!characterStateMatrix.equals(basicCharacterStateMatrix)) {
                return false;
            }
            if (!characterStateMatrix2.equals(basicCharacterStateMatrix2)) {
                return false;
            }
            if (characterStateMatrix2.equals(characterStateMatrix)) {
                return false;
            }
            CharacterStateMatrix characterStateMatrix3 = basicCharacterStateMatrix.pivot();
            CharacterStateMatrix characterStateMatrix4 = basicCharacterStateMatrix2.pivot();
            if (!((String)characterStateMatrix3.getState(1, 0)).equals("01")) {
                return false;
            }
            if (!((String)characterStateMatrix3.getState(6, 2)).equals("26")) {
                return false;
            }
            if (!((String)basicCharacterStateMatrix.getState(2, 6)).equals("26")) {
                return false;
            }
            CharacterStateMatrix characterStateMatrix5 = characterStateMatrix4.pivot();
            if (!characterStateMatrix5.equals(basicCharacterStateMatrix2)) {
                return false;
            }
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix6 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(4, 3);
            basicCharacterStateMatrix6.setIdentifier(0, "amphioxus");
            basicCharacterStateMatrix6.setIdentifier(1, "sponge");
            basicCharacterStateMatrix6.setIdentifier(2, "sea_anemone");
            basicCharacterStateMatrix6.setIdentifier(3, "cobra");
            basicCharacterStateMatrix6.setCharacter(0, "notch");
            basicCharacterStateMatrix6.setCharacter(1, "homeobox");
            basicCharacterStateMatrix6.setCharacter(2, "wnt");
            basicCharacterStateMatrix6.setState(0, 0, CharacterStateMatrix.BinaryStates.ABSENT);
            basicCharacterStateMatrix6.setState(0, 1, CharacterStateMatrix.BinaryStates.ABSENT);
            basicCharacterStateMatrix6.setState(0, 2, CharacterStateMatrix.BinaryStates.ABSENT);
            basicCharacterStateMatrix6.setState(1, 0, CharacterStateMatrix.BinaryStates.PRESENT);
            basicCharacterStateMatrix6.setState(1, 1, CharacterStateMatrix.BinaryStates.PRESENT);
            basicCharacterStateMatrix6.setState(1, 2, CharacterStateMatrix.BinaryStates.ABSENT);
            basicCharacterStateMatrix6.setState(2, 0, CharacterStateMatrix.BinaryStates.PRESENT);
            basicCharacterStateMatrix6.setState(2, 1, CharacterStateMatrix.BinaryStates.PRESENT);
            basicCharacterStateMatrix6.setState(2, 2, CharacterStateMatrix.BinaryStates.PRESENT);
            basicCharacterStateMatrix6.setState(3, 0, CharacterStateMatrix.BinaryStates.PRESENT);
            basicCharacterStateMatrix6.setState(3, 1, CharacterStateMatrix.BinaryStates.ABSENT);
            basicCharacterStateMatrix6.setState(3, 2, CharacterStateMatrix.BinaryStates.ABSENT);
            StringWriter stringWriter = new StringWriter();
            basicCharacterStateMatrix6.toWriter(stringWriter, CharacterStateMatrix.Format.NEXUS_BINARY);
            stringWriter = new StringWriter();
            basicCharacterStateMatrix6.pivot().toWriter(stringWriter, CharacterStateMatrix.Format.NEXUS_BINARY);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testBasicSymmetricalDistanceMatrix() {
        try {
            BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = new BasicSymmetricalDistanceMatrix(4);
            basicSymmetricalDistanceMatrix.setIdentifier(0, "A");
            basicSymmetricalDistanceMatrix.setIdentifier(1, "B");
            basicSymmetricalDistanceMatrix.setIdentifier(2, "C");
            basicSymmetricalDistanceMatrix.setIdentifier(3, "0123456789012");
            basicSymmetricalDistanceMatrix.setValue(1, 0, 1.0E-5);
            basicSymmetricalDistanceMatrix.setValue(0, 2, 9.0E-7);
            basicSymmetricalDistanceMatrix.setValue(3, 0, 3.0);
            basicSymmetricalDistanceMatrix.setValue(1, 2, 4.0);
            basicSymmetricalDistanceMatrix.setValue(3, 1, 5.0);
            basicSymmetricalDistanceMatrix.setValue(2, 3, 6.0);
            if (!basicSymmetricalDistanceMatrix.getIdentifier(0).equals("A")) {
                return false;
            }
            if (!basicSymmetricalDistanceMatrix.getIdentifier(1).equals("B")) {
                return false;
            }
            if (!basicSymmetricalDistanceMatrix.getIdentifier(2).equals("C")) {
                return false;
            }
            if (!basicSymmetricalDistanceMatrix.getIdentifier(3).equals("0123456789012")) {
                return false;
            }
            if (basicSymmetricalDistanceMatrix.getSize() != 4) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(3, 3), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(0, 1), 1.0E-5)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(0, 2), 9.0E-7)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(0, 3), 3.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(1, 0), 1.0E-5)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(1, 2), 4.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(1, 3), 5.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(2, 0), 9.0E-7)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(2, 1), 4.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(2, 3), 6.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(3, 0), 3.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(3, 1), 5.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(basicSymmetricalDistanceMatrix.getValue(3, 2), 6.0)) {
                return false;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("    4");
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
            stringBuffer.append("A           0.000000  0.000010  0.000001  3.000000");
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
            stringBuffer.append("B           0.000010  0.000000  4.000000  5.000000");
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
            stringBuffer.append("C           0.000001  4.000000  0.000000  6.000000");
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
            stringBuffer.append("0123456789  3.000000  5.000000  6.000000  0.000000");
            if (!stringBuffer.toString().equals(basicSymmetricalDistanceMatrix.toStringBuffer(DistanceMatrix.Format.PHYLIP).toString())) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDolloParsimony() {
        try {
            CharacterStateMatrix.BinaryStates binaryStates = CharacterStateMatrix.BinaryStates.PRESENT;
            CharacterStateMatrix.BinaryStates binaryStates2 = CharacterStateMatrix.BinaryStates.ABSENT;
            CharacterStateMatrix.GainLossStates gainLossStates = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
            DolloParsimony dolloParsimony = DolloParsimony.createInstance();
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny = phylogenyFactory.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(9, 1);
            basicCharacterStateMatrix.setIdentifier(0, "a");
            basicCharacterStateMatrix.setIdentifier(1, "b");
            basicCharacterStateMatrix.setIdentifier(2, "c");
            basicCharacterStateMatrix.setIdentifier(3, "d");
            basicCharacterStateMatrix.setIdentifier(4, "e");
            basicCharacterStateMatrix.setIdentifier(5, "f");
            basicCharacterStateMatrix.setIdentifier(6, "g");
            basicCharacterStateMatrix.setIdentifier(7, "h");
            basicCharacterStateMatrix.setIdentifier(8, "i");
            basicCharacterStateMatrix.setCharacter(0, "0");
            basicCharacterStateMatrix.setState("a", "0", binaryStates);
            basicCharacterStateMatrix.setState("b", "0", binaryStates2);
            basicCharacterStateMatrix.setState("c", "0", binaryStates);
            basicCharacterStateMatrix.setState("d", "0", binaryStates2);
            basicCharacterStateMatrix.setState("e", "0", binaryStates2);
            basicCharacterStateMatrix.setState("f", "0", binaryStates2);
            basicCharacterStateMatrix.setState("g", "0", binaryStates2);
            basicCharacterStateMatrix.setState("h", "0", binaryStates2);
            basicCharacterStateMatrix.setState("i", "0", binaryStates2);
            dolloParsimony.execute(phylogeny, basicCharacterStateMatrix);
            if (dolloParsimony.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony.getTotalLosses() != 1) {
                return false;
            }
            if (dolloParsimony.getTotalUnchanged() != 15) {
                return false;
            }
            basicCharacterStateMatrix.setState("b", "0", binaryStates);
            dolloParsimony.execute(phylogeny, basicCharacterStateMatrix);
            if (dolloParsimony.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony.getTotalLosses() != 0) {
                return false;
            }
            if (dolloParsimony.getTotalUnchanged() != 16) {
                return false;
            }
            basicCharacterStateMatrix.setState("b", "0", binaryStates2);
            basicCharacterStateMatrix.setState("e", "0", binaryStates);
            dolloParsimony.execute(phylogeny, basicCharacterStateMatrix);
            if (dolloParsimony.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony.getTotalLosses() != 3) {
                return false;
            }
            if (dolloParsimony.getTotalUnchanged() != 13) {
                return false;
            }
            basicCharacterStateMatrix.setState("a", "0", binaryStates2);
            basicCharacterStateMatrix.setState("c", "0", binaryStates2);
            basicCharacterStateMatrix.setState("g", "0", binaryStates);
            dolloParsimony.setReturnInternalStates(true);
            dolloParsimony.setReturnGainLossMatrix(true);
            dolloParsimony.execute(phylogeny, basicCharacterStateMatrix);
            if (dolloParsimony.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony.getTotalLosses() != 3) {
                return false;
            }
            if (dolloParsimony.getTotalUnchanged() != 13) {
                return false;
            }
            DolloParsimony dolloParsimony2 = DolloParsimony.createInstance();
            PhylogenyFactory phylogenyFactory2 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny2 = phylogenyFactory2.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h,i)gi)ai,((j,k,l)jl,(m,n,o)mo,(p,q,r)pr)jr)root", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix2 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(18, 4);
            basicCharacterStateMatrix2.setIdentifier(0, "a");
            basicCharacterStateMatrix2.setIdentifier(1, "b");
            basicCharacterStateMatrix2.setIdentifier(2, "c");
            basicCharacterStateMatrix2.setIdentifier(3, "d");
            basicCharacterStateMatrix2.setIdentifier(4, "e");
            basicCharacterStateMatrix2.setIdentifier(5, "f");
            basicCharacterStateMatrix2.setIdentifier(6, "g");
            basicCharacterStateMatrix2.setIdentifier(7, "h");
            basicCharacterStateMatrix2.setIdentifier(8, "i");
            basicCharacterStateMatrix2.setIdentifier(9, "j");
            basicCharacterStateMatrix2.setIdentifier(10, "k");
            basicCharacterStateMatrix2.setIdentifier(11, "l");
            basicCharacterStateMatrix2.setIdentifier(12, "m");
            basicCharacterStateMatrix2.setIdentifier(13, "n");
            basicCharacterStateMatrix2.setIdentifier(14, "o");
            basicCharacterStateMatrix2.setIdentifier(15, "p");
            basicCharacterStateMatrix2.setIdentifier(16, "q");
            basicCharacterStateMatrix2.setIdentifier(17, "r");
            basicCharacterStateMatrix2.setCharacter(0, "0");
            basicCharacterStateMatrix2.setCharacter(1, "1");
            basicCharacterStateMatrix2.setCharacter(2, "2");
            basicCharacterStateMatrix2.setCharacter(3, "3");
            basicCharacterStateMatrix2.setState("a", "0", binaryStates);
            basicCharacterStateMatrix2.setState("b", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("c", "0", binaryStates);
            basicCharacterStateMatrix2.setState("d", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("e", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("f", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("g", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("h", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("i", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("j", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("k", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("l", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("m", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("n", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("o", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("p", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("q", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("r", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("a", "1", binaryStates);
            basicCharacterStateMatrix2.setState("b", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("c", "1", binaryStates);
            basicCharacterStateMatrix2.setState("d", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("e", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("f", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("g", "1", binaryStates);
            basicCharacterStateMatrix2.setState("h", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("i", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("j", "1", binaryStates);
            basicCharacterStateMatrix2.setState("k", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("l", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("m", "1", binaryStates);
            basicCharacterStateMatrix2.setState("n", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("o", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("p", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("q", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("r", "1", binaryStates2);
            basicCharacterStateMatrix2.setState("a", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("b", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("c", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("d", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("e", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("f", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("g", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("h", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("i", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("j", "2", binaryStates);
            basicCharacterStateMatrix2.setState("k", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("l", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("m", "2", binaryStates);
            basicCharacterStateMatrix2.setState("n", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("o", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("p", "2", binaryStates);
            basicCharacterStateMatrix2.setState("q", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("r", "2", binaryStates2);
            basicCharacterStateMatrix2.setState("a", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("b", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("c", "3", binaryStates);
            basicCharacterStateMatrix2.setState("d", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("e", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("f", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("g", "3", binaryStates);
            basicCharacterStateMatrix2.setState("h", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("i", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("j", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("k", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("l", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("m", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("n", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("o", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("p", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("q", "3", binaryStates2);
            basicCharacterStateMatrix2.setState("r", "3", binaryStates2);
            dolloParsimony2.setReturnInternalStates(true);
            dolloParsimony2.setReturnGainLossMatrix(true);
            dolloParsimony2.execute(phylogeny2, basicCharacterStateMatrix2);
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix = dolloParsimony2.getInternalStatesMatrix();
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix2 = dolloParsimony2.getGainLossMatrix();
            if (dolloParsimony2.getTotalGains() != 3) {
                return false;
            }
            if (dolloParsimony2.getTotalLosses() != 22) {
                return false;
            }
            if (dolloParsimony2.getTotalUnchanged() != 95) {
                return false;
            }
            if (characterStateMatrix.getState("ab", "0") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("ac", "0") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("ad", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("af", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ef", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ai", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("gi", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("jl", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("mo", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("pr", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("jr", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("root", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ab", "1") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("ac", "1") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("ad", "1") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("af", "1") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("ef", "1") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ai", "1") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("gi", "1") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("jl", "1") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("mo", "1") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("pr", "1") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("jr", "1") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("root", "1") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("ab", "2") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ac", "2") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ad", "2") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("af", "2") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ef", "2") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ai", "2") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("gi", "2") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("jl", "2") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("mo", "2") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("pr", "2") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("jr", "2") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("root", "2") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ab", "3") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ac", "3") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("ad", "3") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("af", "3") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("ef", "3") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ai", "3") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("gi", "3") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("jl", "3") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("mo", "3") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("pr", "3") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("jr", "3") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("root", "3") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix2.getState("a", "0") != gainLossStates) {
                return false;
            }
            DolloParsimony dolloParsimony3 = DolloParsimony.createInstance();
            PhylogenyFactory phylogenyFactory3 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny3 = phylogenyFactory3.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r", new NHXParser())[0];
            basicCharacterStateMatrix = new BasicCharacterStateMatrix(9, 3);
            basicCharacterStateMatrix.setIdentifier(0, "a");
            basicCharacterStateMatrix.setIdentifier(1, "b");
            basicCharacterStateMatrix.setIdentifier(2, "c");
            basicCharacterStateMatrix.setIdentifier(3, "d");
            basicCharacterStateMatrix.setIdentifier(4, "e");
            basicCharacterStateMatrix.setIdentifier(5, "f");
            basicCharacterStateMatrix.setIdentifier(6, "g");
            basicCharacterStateMatrix.setIdentifier(7, "h");
            basicCharacterStateMatrix.setIdentifier(8, "i");
            basicCharacterStateMatrix.setState(0, 0, binaryStates);
            basicCharacterStateMatrix.setState(1, 0, binaryStates2);
            basicCharacterStateMatrix.setState(2, 0, binaryStates);
            basicCharacterStateMatrix.setState(3, 0, binaryStates2);
            basicCharacterStateMatrix.setState(4, 0, binaryStates2);
            basicCharacterStateMatrix.setState(5, 0, binaryStates2);
            basicCharacterStateMatrix.setState(6, 0, binaryStates2);
            basicCharacterStateMatrix.setState(7, 0, binaryStates2);
            basicCharacterStateMatrix.setState(8, 0, binaryStates2);
            basicCharacterStateMatrix.setState(0, 1, binaryStates);
            basicCharacterStateMatrix.setState(1, 1, binaryStates);
            basicCharacterStateMatrix.setState(2, 1, binaryStates);
            basicCharacterStateMatrix.setState(3, 1, binaryStates);
            basicCharacterStateMatrix.setState(4, 1, binaryStates2);
            basicCharacterStateMatrix.setState(5, 1, binaryStates2);
            basicCharacterStateMatrix.setState(6, 1, binaryStates2);
            basicCharacterStateMatrix.setState(7, 1, binaryStates2);
            basicCharacterStateMatrix.setState(8, 1, binaryStates2);
            basicCharacterStateMatrix.setState(0, 2, binaryStates);
            basicCharacterStateMatrix.setState(1, 2, binaryStates2);
            basicCharacterStateMatrix.setState(2, 2, binaryStates2);
            basicCharacterStateMatrix.setState(3, 2, binaryStates2);
            basicCharacterStateMatrix.setState(4, 2, binaryStates2);
            basicCharacterStateMatrix.setState(5, 2, binaryStates2);
            basicCharacterStateMatrix.setState(6, 2, binaryStates2);
            basicCharacterStateMatrix.setState(7, 2, binaryStates);
            basicCharacterStateMatrix.setState(8, 2, binaryStates2);
            dolloParsimony3.execute(phylogeny3, basicCharacterStateMatrix);
            if (dolloParsimony3.getTotalGains() != 3) {
                return false;
            }
            if (dolloParsimony3.getTotalLosses() != 6) {
                return false;
            }
            DolloParsimony dolloParsimony4 = DolloParsimony.createInstance();
            PhylogenyFactory phylogenyFactory4 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny4 = phylogenyFactory4.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix3 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(9, 1);
            basicCharacterStateMatrix3.setIdentifier(0, "a");
            basicCharacterStateMatrix3.setIdentifier(1, "b");
            basicCharacterStateMatrix3.setIdentifier(2, "c");
            basicCharacterStateMatrix3.setIdentifier(3, "d");
            basicCharacterStateMatrix3.setIdentifier(4, "e");
            basicCharacterStateMatrix3.setIdentifier(5, "f");
            basicCharacterStateMatrix3.setIdentifier(6, "g");
            basicCharacterStateMatrix3.setIdentifier(7, "h");
            basicCharacterStateMatrix3.setIdentifier(8, "i");
            basicCharacterStateMatrix3.setState(0, 0, binaryStates);
            basicCharacterStateMatrix3.setState(1, 0, binaryStates2);
            basicCharacterStateMatrix3.setState(2, 0, binaryStates);
            basicCharacterStateMatrix3.setState(3, 0, binaryStates2);
            basicCharacterStateMatrix3.setState(4, 0, binaryStates2);
            basicCharacterStateMatrix3.setState(5, 0, binaryStates2);
            basicCharacterStateMatrix3.setState(6, 0, binaryStates2);
            basicCharacterStateMatrix3.setState(7, 0, binaryStates2);
            basicCharacterStateMatrix3.setState(8, 0, binaryStates2);
            dolloParsimony4.execute(phylogeny4, basicCharacterStateMatrix3);
            if (dolloParsimony4.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony4.getTotalLosses() != 1) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDolloParsimonyOnNonBinaryTree() {
        try {
            CharacterStateMatrix.BinaryStates binaryStates = CharacterStateMatrix.BinaryStates.PRESENT;
            CharacterStateMatrix.BinaryStates binaryStates2 = CharacterStateMatrix.BinaryStates.ABSENT;
            DolloParsimony dolloParsimony = DolloParsimony.createInstance();
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny = phylogenyFactory.create("((((((a,b,y)aby,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(10, 1);
            basicCharacterStateMatrix.setIdentifier(0, "a");
            basicCharacterStateMatrix.setIdentifier(1, "b");
            basicCharacterStateMatrix.setIdentifier(2, "y");
            basicCharacterStateMatrix.setIdentifier(3, "c");
            basicCharacterStateMatrix.setIdentifier(4, "d");
            basicCharacterStateMatrix.setIdentifier(5, "e");
            basicCharacterStateMatrix.setIdentifier(6, "f");
            basicCharacterStateMatrix.setIdentifier(7, "g");
            basicCharacterStateMatrix.setIdentifier(8, "h");
            basicCharacterStateMatrix.setIdentifier(9, "i");
            basicCharacterStateMatrix.setCharacter(0, "0");
            basicCharacterStateMatrix.setState("a", "0", binaryStates);
            basicCharacterStateMatrix.setState("b", "0", binaryStates2);
            basicCharacterStateMatrix.setState("y", "0", binaryStates);
            basicCharacterStateMatrix.setState("c", "0", binaryStates);
            basicCharacterStateMatrix.setState("d", "0", binaryStates2);
            basicCharacterStateMatrix.setState("e", "0", binaryStates2);
            basicCharacterStateMatrix.setState("f", "0", binaryStates2);
            basicCharacterStateMatrix.setState("g", "0", binaryStates2);
            basicCharacterStateMatrix.setState("h", "0", binaryStates2);
            basicCharacterStateMatrix.setState("i", "0", binaryStates2);
            dolloParsimony.execute(phylogeny, basicCharacterStateMatrix);
            if (dolloParsimony.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony.getTotalLosses() != 1) {
                return false;
            }
            if (dolloParsimony.getTotalUnchanged() != 16) {
                return false;
            }
            basicCharacterStateMatrix.setState("b", "0", binaryStates);
            dolloParsimony.execute(phylogeny, basicCharacterStateMatrix);
            if (dolloParsimony.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony.getTotalLosses() != 0) {
                return false;
            }
            if (dolloParsimony.getTotalUnchanged() != 17) {
                return false;
            }
            basicCharacterStateMatrix.setState("a", "0", binaryStates2);
            basicCharacterStateMatrix.setState("b", "0", binaryStates2);
            dolloParsimony.execute(phylogeny, basicCharacterStateMatrix);
            if (dolloParsimony.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony.getTotalLosses() != 2) {
                return false;
            }
            if (dolloParsimony.getTotalUnchanged() != 15) {
                return false;
            }
            basicCharacterStateMatrix.setState("y", "0", binaryStates2);
            dolloParsimony.execute(phylogeny, basicCharacterStateMatrix);
            if (dolloParsimony.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony.getTotalLosses() != 0) {
                return false;
            }
            if (dolloParsimony.getTotalUnchanged() != 17) {
                return false;
            }
            DolloParsimony dolloParsimony2 = DolloParsimony.createInstance();
            PhylogenyFactory phylogenyFactory2 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny2 = phylogenyFactory2.create("((((((a,b,y)aby,c,d)cad,e,f)af,(g,h)gh)ah,i))r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix2 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(10, 1);
            basicCharacterStateMatrix2.setIdentifier(0, "a");
            basicCharacterStateMatrix2.setIdentifier(1, "b");
            basicCharacterStateMatrix2.setIdentifier(2, "y");
            basicCharacterStateMatrix2.setIdentifier(3, "c");
            basicCharacterStateMatrix2.setIdentifier(4, "d");
            basicCharacterStateMatrix2.setIdentifier(5, "e");
            basicCharacterStateMatrix2.setIdentifier(6, "f");
            basicCharacterStateMatrix2.setIdentifier(7, "g");
            basicCharacterStateMatrix2.setIdentifier(8, "h");
            basicCharacterStateMatrix2.setIdentifier(9, "i");
            basicCharacterStateMatrix2.setCharacter(0, "0");
            basicCharacterStateMatrix2.setState("a", "0", binaryStates);
            basicCharacterStateMatrix2.setState("b", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("y", "0", binaryStates);
            basicCharacterStateMatrix2.setState("c", "0", binaryStates);
            basicCharacterStateMatrix2.setState("d", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("e", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("f", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("g", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("h", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("i", "0", binaryStates2);
            dolloParsimony2.setReturnInternalStates(true);
            dolloParsimony2.execute(phylogeny2, basicCharacterStateMatrix2);
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix = dolloParsimony2.getInternalStatesMatrix();
            if (characterStateMatrix.getState("aby", "0") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("cad", "0") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("af", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("gh", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ah", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("r", "0") != binaryStates2) {
                return false;
            }
            if (dolloParsimony2.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony2.getTotalLosses() != 2) {
                return false;
            }
            if (dolloParsimony2.getTotalUnchanged() != 14) {
                return false;
            }
            basicCharacterStateMatrix2.setState("b", "0", binaryStates);
            dolloParsimony2.execute(phylogeny2, basicCharacterStateMatrix2);
            if (dolloParsimony2.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony2.getTotalLosses() != 1) {
                return false;
            }
            if (dolloParsimony2.getTotalUnchanged() != 15) {
                return false;
            }
            basicCharacterStateMatrix2.setState("a", "0", binaryStates2);
            basicCharacterStateMatrix2.setState("b", "0", binaryStates2);
            dolloParsimony2.execute(phylogeny2, basicCharacterStateMatrix2);
            if (dolloParsimony2.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony2.getTotalLosses() != 3) {
                return false;
            }
            if (dolloParsimony2.getTotalUnchanged() != 13) {
                return false;
            }
            basicCharacterStateMatrix2.setState("y", "0", binaryStates2);
            dolloParsimony2.execute(phylogeny2, basicCharacterStateMatrix2);
            if (dolloParsimony2.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony2.getTotalLosses() != 0) {
                return false;
            }
            if (dolloParsimony2.getTotalUnchanged() != 16) {
                return false;
            }
            basicCharacterStateMatrix2.setState("c", "0", binaryStates2);
            dolloParsimony2.execute(phylogeny2, basicCharacterStateMatrix2);
            if (dolloParsimony2.getTotalGains() != 0) {
                return false;
            }
            if (dolloParsimony2.getTotalLosses() != 0) {
                return false;
            }
            if (dolloParsimony2.getTotalUnchanged() != 17) {
                return false;
            }
            basicCharacterStateMatrix2.setState("y", "0", binaryStates);
            basicCharacterStateMatrix2.setState("e", "0", binaryStates);
            dolloParsimony2.execute(phylogeny2, basicCharacterStateMatrix2);
            if (dolloParsimony2.getTotalGains() != 1) {
                return false;
            }
            if (dolloParsimony2.getTotalLosses() != 5) {
                return false;
            }
            if (dolloParsimony2.getTotalUnchanged() != 11) {
                return false;
            }
            characterStateMatrix = dolloParsimony2.getInternalStatesMatrix();
            if (characterStateMatrix.getState("aby", "0") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("cad", "0") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("af", "0") != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState("gh", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("ah", "0") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState("r", "0") != binaryStates2) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testFitchParsimony() {
        try {
            CharacterStateMatrix.BinaryStates binaryStates = CharacterStateMatrix.BinaryStates.PRESENT;
            CharacterStateMatrix.BinaryStates binaryStates2 = CharacterStateMatrix.BinaryStates.ABSENT;
            CharacterStateMatrix.GainLossStates gainLossStates = CharacterStateMatrix.GainLossStates.GAIN;
            CharacterStateMatrix.GainLossStates gainLossStates2 = CharacterStateMatrix.GainLossStates.LOSS;
            CharacterStateMatrix.GainLossStates gainLossStates3 = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
            CharacterStateMatrix.GainLossStates gainLossStates4 = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
            FitchParsimony fitchParsimony = new FitchParsimony();
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny = phylogenyFactory.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h,i)gi)ai,((j,k,l)jl,(m,n,o)mo,(p,q,r)pr)jr)root", new NHXParser())[0];
            BasicCharacterStateMatrix<String> basicCharacterStateMatrix = new BasicCharacterStateMatrix<String>(18, 1);
            basicCharacterStateMatrix.setIdentifier(0, "a");
            basicCharacterStateMatrix.setIdentifier(1, "b");
            basicCharacterStateMatrix.setIdentifier(2, "c");
            basicCharacterStateMatrix.setIdentifier(3, "d");
            basicCharacterStateMatrix.setIdentifier(4, "e");
            basicCharacterStateMatrix.setIdentifier(5, "f");
            basicCharacterStateMatrix.setIdentifier(6, "g");
            basicCharacterStateMatrix.setIdentifier(7, "h");
            basicCharacterStateMatrix.setIdentifier(8, "i");
            basicCharacterStateMatrix.setIdentifier(9, "j");
            basicCharacterStateMatrix.setIdentifier(10, "k");
            basicCharacterStateMatrix.setIdentifier(11, "l");
            basicCharacterStateMatrix.setIdentifier(12, "m");
            basicCharacterStateMatrix.setIdentifier(13, "n");
            basicCharacterStateMatrix.setIdentifier(14, "o");
            basicCharacterStateMatrix.setIdentifier(15, "p");
            basicCharacterStateMatrix.setIdentifier(16, "q");
            basicCharacterStateMatrix.setIdentifier(17, "r");
            basicCharacterStateMatrix.setCharacter(0, "0");
            basicCharacterStateMatrix.setState("a", "0", "A");
            basicCharacterStateMatrix.setState("b", "0", "A");
            basicCharacterStateMatrix.setState("c", "0", "B");
            basicCharacterStateMatrix.setState("d", "0", "C");
            basicCharacterStateMatrix.setState("e", "0", "D");
            basicCharacterStateMatrix.setState("f", "0", "A");
            basicCharacterStateMatrix.setState("g", "0", "A");
            basicCharacterStateMatrix.setState("h", "0", "B");
            basicCharacterStateMatrix.setState("i", "0", "C");
            basicCharacterStateMatrix.setState("j", "0", "A");
            basicCharacterStateMatrix.setState("k", "0", "B");
            basicCharacterStateMatrix.setState("l", "0", "C");
            basicCharacterStateMatrix.setState("m", "0", "B");
            basicCharacterStateMatrix.setState("n", "0", "B");
            basicCharacterStateMatrix.setState("o", "0", "B");
            basicCharacterStateMatrix.setState("p", "0", "A");
            basicCharacterStateMatrix.setState("q", "0", "C");
            basicCharacterStateMatrix.setState("r", "0", "D");
            fitchParsimony.setReturnInternalStates(true);
            fitchParsimony.setReturnGainLossMatrix(false);
            fitchParsimony.setRandomize(false);
            fitchParsimony.execute(phylogeny, basicCharacterStateMatrix);
            CharacterStateMatrix characterStateMatrix = fitchParsimony.getInternalStatesMatrix();
            CharacterStateMatrix characterStateMatrix2 = fitchParsimony.getInternalStatesMatrixPriorToTraceback();
            if (fitchParsimony.getCost() != 10) {
                return false;
            }
            if (!((String)characterStateMatrix.getState("ab", "0")).equals("A")) {
                return false;
            }
            if (!((String)characterStateMatrix.getState("ac", "0")).equals("A")) {
                return false;
            }
            if (!((String)characterStateMatrix.getState("ad", "0")).equals("A")) {
                return false;
            }
            if (!((String)characterStateMatrix.getState("ef", "0")).equals("A")) {
                return false;
            }
            if (!((String)characterStateMatrix.getState("ai", "0")).equals("A")) {
                return false;
            }
            if (!((String)characterStateMatrix.getState("gi", "0")).equals("A")) {
                return false;
            }
            if (!((String)characterStateMatrix.getState("jl", "0")).equals("A")) {
                return false;
            }
            if (!((String)characterStateMatrix.getState("mo", "0")).equals("B")) {
                return false;
            }
            if (!((String)characterStateMatrix.getState("pr", "0")).equals("A")) {
                return false;
            }
            if (characterStateMatrix2.getState("ab", "0").size() != 1) {
                return false;
            }
            if (!characterStateMatrix2.getState("ab", "0").contains("A")) {
                return false;
            }
            if (characterStateMatrix2.getState("ac", "0").size() != 2) {
                return false;
            }
            if (!characterStateMatrix2.getState("ac", "0").contains("A")) {
                return false;
            }
            if (!characterStateMatrix2.getState("ac", "0").contains("B")) {
                return false;
            }
            if (characterStateMatrix2.getState("ad", "0").size() != 3) {
                return false;
            }
            if (!characterStateMatrix2.getState("ad", "0").contains("A")) {
                return false;
            }
            if (!characterStateMatrix2.getState("ad", "0").contains("B")) {
                return false;
            }
            if (!characterStateMatrix2.getState("ad", "0").contains("C")) {
                return false;
            }
            if (characterStateMatrix2.getState("af", "0").size() != 1) {
                return false;
            }
            if (!characterStateMatrix2.getState("af", "0").contains("A")) {
                return false;
            }
            if (characterStateMatrix2.getState("ef", "0").size() != 2) {
                return false;
            }
            if (!characterStateMatrix2.getState("ef", "0").contains("A")) {
                return false;
            }
            if (!characterStateMatrix2.getState("ef", "0").contains("D")) {
                return false;
            }
            if (characterStateMatrix2.getState("gi", "0").size() != 3) {
                return false;
            }
            if (!characterStateMatrix2.getState("gi", "0").contains("A")) {
                return false;
            }
            if (!characterStateMatrix2.getState("gi", "0").contains("B")) {
                return false;
            }
            if (!characterStateMatrix2.getState("gi", "0").contains("C")) {
                return false;
            }
            if (characterStateMatrix2.getState("ai", "0").size() != 1) {
                return false;
            }
            if (!characterStateMatrix2.getState("ai", "0").contains("A")) {
                return false;
            }
            if (characterStateMatrix2.getState("jl", "0").size() != 3) {
                return false;
            }
            if (!characterStateMatrix2.getState("jl", "0").contains("A")) {
                return false;
            }
            if (!characterStateMatrix2.getState("jl", "0").contains("B")) {
                return false;
            }
            if (!characterStateMatrix2.getState("jl", "0").contains("C")) {
                return false;
            }
            if (characterStateMatrix2.getState("mo", "0").size() != 1) {
                return false;
            }
            if (!characterStateMatrix2.getState("mo", "0").contains("B")) {
                return false;
            }
            if (characterStateMatrix2.getState("pr", "0").size() != 3) {
                return false;
            }
            if (!characterStateMatrix2.getState("pr", "0").contains("A")) {
                return false;
            }
            if (!characterStateMatrix2.getState("pr", "0").contains("C")) {
                return false;
            }
            if (!characterStateMatrix2.getState("pr", "0").contains("D")) {
                return false;
            }
            if (characterStateMatrix2.getState("jr", "0").size() != 4) {
                return false;
            }
            if (!characterStateMatrix2.getState("jr", "0").contains("A")) {
                return false;
            }
            if (!characterStateMatrix2.getState("jr", "0").contains("B")) {
                return false;
            }
            if (!characterStateMatrix2.getState("jr", "0").contains("C")) {
                return false;
            }
            if (!characterStateMatrix2.getState("jr", "0").contains("D")) {
                return false;
            }
            FitchParsimony fitchParsimony2 = new FitchParsimony();
            PhylogenyFactory phylogenyFactory2 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny2 = phylogenyFactory2.create("((a,b)ab,(c,(d,e)de)cde)r", new NHXParser())[0];
            BasicCharacterStateMatrix<String> basicCharacterStateMatrix2 = new BasicCharacterStateMatrix<String>(5, 1);
            basicCharacterStateMatrix2.setIdentifier(0, "a");
            basicCharacterStateMatrix2.setIdentifier(1, "b");
            basicCharacterStateMatrix2.setIdentifier(2, "c");
            basicCharacterStateMatrix2.setIdentifier(3, "d");
            basicCharacterStateMatrix2.setIdentifier(4, "e");
            basicCharacterStateMatrix2.setCharacter(0, "0");
            basicCharacterStateMatrix2.setState("a", "0", "C");
            basicCharacterStateMatrix2.setState("b", "0", "A");
            basicCharacterStateMatrix2.setState("c", "0", "C");
            basicCharacterStateMatrix2.setState("d", "0", "A");
            basicCharacterStateMatrix2.setState("e", "0", "G");
            fitchParsimony2.setReturnInternalStates(true);
            fitchParsimony2.setReturnGainLossMatrix(false);
            fitchParsimony2.execute(phylogeny2, basicCharacterStateMatrix2);
            CharacterStateMatrix characterStateMatrix3 = fitchParsimony2.getInternalStatesMatrix();
            CharacterStateMatrix characterStateMatrix4 = fitchParsimony2.getInternalStatesMatrixPriorToTraceback();
            if (fitchParsimony2.getCost() != 3) {
                return false;
            }
            if (!((String)characterStateMatrix3.getState("ab", "0")).equals("A")) {
                return false;
            }
            if (!((String)characterStateMatrix3.getState("de", "0")).equals("A")) {
                return false;
            }
            if (!((String)characterStateMatrix3.getState("cde", "0")).equals("A")) {
                return false;
            }
            if (!((String)characterStateMatrix3.getState("r", "0")).equals("A")) {
                return false;
            }
            if (characterStateMatrix4.getState("cde", "0").size() != 3) {
                return false;
            }
            if (!characterStateMatrix4.getState("cde", "0").contains("A")) {
                return false;
            }
            if (!characterStateMatrix4.getState("cde", "0").contains("C")) {
                return false;
            }
            if (!characterStateMatrix4.getState("cde", "0").contains("G")) {
                return false;
            }
            if (characterStateMatrix4.getState("ab", "0").size() != 2) {
                return false;
            }
            if (!characterStateMatrix4.getState("ab", "0").contains("A")) {
                return false;
            }
            if (!characterStateMatrix4.getState("ab", "0").contains("C")) {
                return false;
            }
            fitchParsimony2.setReturnInternalStates(true);
            fitchParsimony2.setReturnGainLossMatrix(false);
            fitchParsimony2.setUseLast(true);
            fitchParsimony2.execute(phylogeny2, basicCharacterStateMatrix2);
            CharacterStateMatrix characterStateMatrix5 = fitchParsimony2.getInternalStatesMatrix();
            CharacterStateMatrix characterStateMatrix6 = fitchParsimony2.getInternalStatesMatrixPriorToTraceback();
            if (fitchParsimony2.getCost() != 3) {
                return false;
            }
            if (!((String)characterStateMatrix5.getState("ab", "0")).equals("C")) {
                return false;
            }
            if (!((String)characterStateMatrix5.getState("de", "0")).equals("G")) {
                return false;
            }
            if (!((String)characterStateMatrix5.getState("cde", "0")).equals("C")) {
                return false;
            }
            if (!((String)characterStateMatrix5.getState("r", "0")).equals("C")) {
                return false;
            }
            if (characterStateMatrix6.getState("cde", "0").size() != 3) {
                return false;
            }
            if (!characterStateMatrix6.getState("cde", "0").contains("A")) {
                return false;
            }
            if (!characterStateMatrix6.getState("cde", "0").contains("C")) {
                return false;
            }
            if (!characterStateMatrix6.getState("cde", "0").contains("G")) {
                return false;
            }
            FitchParsimony fitchParsimony3 = new FitchParsimony();
            PhylogenyFactory phylogenyFactory3 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny3 = phylogenyFactory3.create("(((a,b)ab,((c,d)cd,e)cde)abcde,f)r", new NHXParser())[0];
            BasicCharacterStateMatrix<String> basicCharacterStateMatrix3 = new BasicCharacterStateMatrix<String>(6, 1);
            basicCharacterStateMatrix3.setIdentifier(0, "a");
            basicCharacterStateMatrix3.setIdentifier(1, "b");
            basicCharacterStateMatrix3.setIdentifier(2, "c");
            basicCharacterStateMatrix3.setIdentifier(3, "d");
            basicCharacterStateMatrix3.setIdentifier(4, "e");
            basicCharacterStateMatrix3.setIdentifier(5, "f");
            basicCharacterStateMatrix3.setCharacter(0, "0");
            basicCharacterStateMatrix3.setState("a", "0", "C");
            basicCharacterStateMatrix3.setState("b", "0", "U");
            basicCharacterStateMatrix3.setState("c", "0", "G");
            basicCharacterStateMatrix3.setState("d", "0", "U");
            basicCharacterStateMatrix3.setState("e", "0", "A");
            basicCharacterStateMatrix3.setState("f", "0", "A");
            fitchParsimony3.setReturnInternalStates(true);
            fitchParsimony3.setReturnGainLossMatrix(false);
            fitchParsimony3.execute(phylogeny3, basicCharacterStateMatrix3);
            CharacterStateMatrix characterStateMatrix7 = fitchParsimony3.getInternalStatesMatrix();
            CharacterStateMatrix characterStateMatrix8 = fitchParsimony3.getInternalStatesMatrixPriorToTraceback();
            if (fitchParsimony3.getCost() != 4) {
                return false;
            }
            if (!((String)characterStateMatrix7.getState("ab", "0")).equals("U")) {
                return false;
            }
            if (!((String)characterStateMatrix7.getState("cd", "0")).equals("U")) {
                return false;
            }
            if (!((String)characterStateMatrix7.getState("cde", "0")).equals("U")) {
                return false;
            }
            if (!((String)characterStateMatrix7.getState("abcde", "0")).equals("U")) {
                return false;
            }
            if (!((String)characterStateMatrix7.getState("r", "0")).equals("A")) {
                return false;
            }
            if (characterStateMatrix8.getState("cde", "0").size() != 3) {
                return false;
            }
            if (!characterStateMatrix8.getState("cde", "0").contains("A")) {
                return false;
            }
            if (!characterStateMatrix8.getState("cde", "0").contains("G")) {
                return false;
            }
            if (!characterStateMatrix8.getState("cde", "0").contains("U")) {
                return false;
            }
            if (characterStateMatrix8.getState("ab", "0").size() != 2) {
                return false;
            }
            if (!characterStateMatrix8.getState("ab", "0").contains("C")) {
                return false;
            }
            if (!characterStateMatrix8.getState("ab", "0").contains("U")) {
                return false;
            }
            if (characterStateMatrix8.getState("cd", "0").size() != 2) {
                return false;
            }
            if (!characterStateMatrix8.getState("cd", "0").contains("G")) {
                return false;
            }
            if (!characterStateMatrix8.getState("cd", "0").contains("U")) {
                return false;
            }
            if (characterStateMatrix8.getState("abcde", "0").size() != 1) {
                return false;
            }
            if (!characterStateMatrix8.getState("abcde", "0").contains("U")) {
                return false;
            }
            if (characterStateMatrix8.getState("r", "0").size() != 2) {
                return false;
            }
            if (!characterStateMatrix8.getState("r", "0").contains("A")) {
                return false;
            }
            if (!characterStateMatrix8.getState("r", "0").contains("U")) {
                return false;
            }
            FitchParsimony fitchParsimony4 = new FitchParsimony();
            PhylogenyFactory phylogenyFactory4 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny4 = phylogenyFactory4.create("(((a,b)ab,((c,d)cd,e)cde)abcde,f)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix4 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(6, 1);
            basicCharacterStateMatrix4.setIdentifier(0, "a");
            basicCharacterStateMatrix4.setIdentifier(1, "b");
            basicCharacterStateMatrix4.setIdentifier(2, "c");
            basicCharacterStateMatrix4.setIdentifier(3, "d");
            basicCharacterStateMatrix4.setIdentifier(4, "e");
            basicCharacterStateMatrix4.setIdentifier(5, "f");
            basicCharacterStateMatrix4.setCharacter(0, "0");
            basicCharacterStateMatrix4.setState("a", "0", binaryStates);
            basicCharacterStateMatrix4.setState("b", "0", binaryStates2);
            basicCharacterStateMatrix4.setState("c", "0", binaryStates);
            basicCharacterStateMatrix4.setState("d", "0", binaryStates);
            basicCharacterStateMatrix4.setState("e", "0", binaryStates2);
            basicCharacterStateMatrix4.setState("f", "0", binaryStates2);
            fitchParsimony4.setReturnInternalStates(true);
            fitchParsimony4.setReturnGainLossMatrix(true);
            fitchParsimony4.execute(phylogeny4, basicCharacterStateMatrix4);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix9 = fitchParsimony4.getGainLossMatrix();
            if (fitchParsimony4.getCost() != 2) {
                return false;
            }
            if (fitchParsimony4.getTotalLosses() != 0) {
                return false;
            }
            if (fitchParsimony4.getTotalGains() != 2) {
                return false;
            }
            if (fitchParsimony4.getTotalUnchanged() != 9) {
                return false;
            }
            if (characterStateMatrix9.getState("a", "0") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix9.getState("b", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix9.getState("ab", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix9.getState("cd", "0") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix9.getState("r", "0") != gainLossStates4) {
                return false;
            }
            FitchParsimony fitchParsimony5 = new FitchParsimony();
            PhylogenyFactory phylogenyFactory5 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny5 = phylogenyFactory5.create("(((a,b)ab,((c,d)cd,e)cde)abcde,f)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix5 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(6, 1);
            basicCharacterStateMatrix5.setIdentifier(0, "a");
            basicCharacterStateMatrix5.setIdentifier(1, "b");
            basicCharacterStateMatrix5.setIdentifier(2, "c");
            basicCharacterStateMatrix5.setIdentifier(3, "d");
            basicCharacterStateMatrix5.setIdentifier(4, "e");
            basicCharacterStateMatrix5.setIdentifier(5, "f");
            basicCharacterStateMatrix5.setCharacter(0, "0");
            basicCharacterStateMatrix5.setState("a", "0", binaryStates);
            basicCharacterStateMatrix5.setState("b", "0", binaryStates2);
            basicCharacterStateMatrix5.setState("c", "0", binaryStates);
            basicCharacterStateMatrix5.setState("d", "0", binaryStates2);
            basicCharacterStateMatrix5.setState("e", "0", binaryStates);
            basicCharacterStateMatrix5.setState("f", "0", binaryStates2);
            fitchParsimony5.setReturnInternalStates(true);
            fitchParsimony5.setReturnGainLossMatrix(true);
            fitchParsimony5.execute(phylogeny5, basicCharacterStateMatrix5);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix10 = fitchParsimony5.getGainLossMatrix();
            if (fitchParsimony5.getCost() != 3) {
                return false;
            }
            if (fitchParsimony5.getTotalLosses() != 2) {
                return false;
            }
            if (fitchParsimony5.getTotalGains() != 1) {
                return false;
            }
            if (fitchParsimony5.getTotalUnchanged() != 8) {
                return false;
            }
            if (characterStateMatrix10.getState("abcde", "0") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix10.getState("a", "0") != gainLossStates3) {
                return false;
            }
            if (characterStateMatrix10.getState("b", "0") != gainLossStates2) {
                return false;
            }
            if (characterStateMatrix10.getState("d", "0") != gainLossStates2) {
                return false;
            }
            if (characterStateMatrix10.getState("r", "0") != gainLossStates4) {
                return false;
            }
            FitchParsimony fitchParsimony6 = new FitchParsimony();
            PhylogenyFactory phylogenyFactory6 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny6 = phylogenyFactory6.create("(((a,b)ab,((c,d)cd,e)cde)abcde,f)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix6 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(6, 1);
            basicCharacterStateMatrix6.setIdentifier(0, "a");
            basicCharacterStateMatrix6.setIdentifier(1, "b");
            basicCharacterStateMatrix6.setIdentifier(2, "c");
            basicCharacterStateMatrix6.setIdentifier(3, "d");
            basicCharacterStateMatrix6.setIdentifier(4, "e");
            basicCharacterStateMatrix6.setIdentifier(5, "f");
            basicCharacterStateMatrix6.setCharacter(0, "0");
            basicCharacterStateMatrix6.setState("a", "0", binaryStates);
            basicCharacterStateMatrix6.setState("b", "0", binaryStates2);
            basicCharacterStateMatrix6.setState("c", "0", binaryStates);
            basicCharacterStateMatrix6.setState("d", "0", binaryStates);
            basicCharacterStateMatrix6.setState("e", "0", binaryStates2);
            basicCharacterStateMatrix6.setState("f", "0", binaryStates);
            fitchParsimony6.setReturnInternalStates(true);
            fitchParsimony6.setReturnGainLossMatrix(true);
            fitchParsimony6.execute(phylogeny6, basicCharacterStateMatrix6);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix11 = fitchParsimony6.getGainLossMatrix();
            if (fitchParsimony6.getCost() != 2) {
                return false;
            }
            if (fitchParsimony6.getTotalLosses() != 2) {
                return false;
            }
            if (fitchParsimony6.getTotalGains() != 0) {
                return false;
            }
            if (fitchParsimony6.getTotalUnchanged() != 9) {
                return false;
            }
            if (characterStateMatrix11.getState("abcde", "0") != gainLossStates3) {
                return false;
            }
            if (characterStateMatrix11.getState("r", "0") != gainLossStates3) {
                return false;
            }
            if (characterStateMatrix11.getState("b", "0") != gainLossStates2) {
                return false;
            }
            if (characterStateMatrix11.getState("e", "0") != gainLossStates2) {
                return false;
            }
            FitchParsimony fitchParsimony7 = new FitchParsimony();
            PhylogenyFactory phylogenyFactory7 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny7 = phylogenyFactory7.create("(((a,b)ab,(c,d)cd)abcd,((e,f)ef,(g,h)gh)efgh)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix7 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(8, 1);
            basicCharacterStateMatrix7.setIdentifier(0, "a");
            basicCharacterStateMatrix7.setIdentifier(1, "b");
            basicCharacterStateMatrix7.setIdentifier(2, "c");
            basicCharacterStateMatrix7.setIdentifier(3, "d");
            basicCharacterStateMatrix7.setIdentifier(4, "e");
            basicCharacterStateMatrix7.setIdentifier(5, "f");
            basicCharacterStateMatrix7.setIdentifier(6, "g");
            basicCharacterStateMatrix7.setIdentifier(7, "h");
            basicCharacterStateMatrix7.setCharacter(0, "0");
            basicCharacterStateMatrix7.setState("a", "0", binaryStates);
            basicCharacterStateMatrix7.setState("b", "0", binaryStates2);
            basicCharacterStateMatrix7.setState("c", "0", binaryStates);
            basicCharacterStateMatrix7.setState("d", "0", binaryStates2);
            basicCharacterStateMatrix7.setState("e", "0", binaryStates);
            basicCharacterStateMatrix7.setState("f", "0", binaryStates2);
            basicCharacterStateMatrix7.setState("g", "0", binaryStates);
            basicCharacterStateMatrix7.setState("h", "0", binaryStates2);
            fitchParsimony7.setReturnInternalStates(true);
            fitchParsimony7.setReturnGainLossMatrix(true);
            fitchParsimony7.execute(phylogeny7, basicCharacterStateMatrix7);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix12 = fitchParsimony7.getGainLossMatrix();
            if (fitchParsimony7.getCost() != 4) {
                return false;
            }
            if (fitchParsimony7.getTotalLosses() != 0) {
                return false;
            }
            if (fitchParsimony7.getTotalGains() != 4) {
                return false;
            }
            if (fitchParsimony7.getTotalUnchanged() != 11) {
                return false;
            }
            if (characterStateMatrix12.getState("a", "0") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix12.getState("c", "0") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix12.getState("e", "0") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix12.getState("g", "0") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix12.getState("r", "0") != gainLossStates4) {
                return false;
            }
            fitchParsimony7.setReturnInternalStates(true);
            fitchParsimony7.setReturnGainLossMatrix(true);
            fitchParsimony7.setUseLast(true);
            fitchParsimony7.execute(phylogeny7, basicCharacterStateMatrix7);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix13 = fitchParsimony7.getGainLossMatrix();
            if (fitchParsimony7.getCost() != 4) {
                return false;
            }
            if (fitchParsimony7.getTotalLosses() != 4) {
                return false;
            }
            if (fitchParsimony7.getTotalGains() != 0) {
                return false;
            }
            if (fitchParsimony7.getTotalUnchanged() != 11) {
                return false;
            }
            if (characterStateMatrix13.getState("b", "0") != gainLossStates2) {
                return false;
            }
            if (characterStateMatrix13.getState("d", "0") != gainLossStates2) {
                return false;
            }
            if (characterStateMatrix13.getState("f", "0") != gainLossStates2) {
                return false;
            }
            if (characterStateMatrix13.getState("h", "0") != gainLossStates2) {
                return false;
            }
            if (characterStateMatrix13.getState("r", "0") != gainLossStates3) {
                return false;
            }
            FitchParsimony fitchParsimony8 = new FitchParsimony();
            PhylogenyFactory phylogenyFactory8 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny8 = phylogenyFactory8.create("(((a,b)ab,(c,d)cd)abcd,((e,f)ef,(g,h)gh)efgh)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix8 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(8, 1);
            basicCharacterStateMatrix8.setIdentifier(0, "a");
            basicCharacterStateMatrix8.setIdentifier(1, "b");
            basicCharacterStateMatrix8.setIdentifier(2, "c");
            basicCharacterStateMatrix8.setIdentifier(3, "d");
            basicCharacterStateMatrix8.setIdentifier(4, "e");
            basicCharacterStateMatrix8.setIdentifier(5, "f");
            basicCharacterStateMatrix8.setIdentifier(6, "g");
            basicCharacterStateMatrix8.setIdentifier(7, "h");
            basicCharacterStateMatrix8.setCharacter(0, "0");
            basicCharacterStateMatrix8.setState("a", "0", binaryStates);
            basicCharacterStateMatrix8.setState("b", "0", binaryStates);
            basicCharacterStateMatrix8.setState("c", "0", binaryStates);
            basicCharacterStateMatrix8.setState("d", "0", binaryStates2);
            basicCharacterStateMatrix8.setState("e", "0", binaryStates2);
            basicCharacterStateMatrix8.setState("f", "0", binaryStates2);
            basicCharacterStateMatrix8.setState("g", "0", binaryStates2);
            basicCharacterStateMatrix8.setState("h", "0", binaryStates2);
            fitchParsimony8.setReturnInternalStates(true);
            fitchParsimony8.setReturnGainLossMatrix(true);
            fitchParsimony8.execute(phylogeny8, basicCharacterStateMatrix8);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix14 = fitchParsimony8.getGainLossMatrix();
            if (fitchParsimony8.getCost() != 2) {
                return false;
            }
            if (fitchParsimony8.getTotalLosses() != 1) {
                return false;
            }
            if (fitchParsimony8.getTotalGains() != 1) {
                return false;
            }
            if (fitchParsimony8.getTotalUnchanged() != 13) {
                return false;
            }
            if (characterStateMatrix14.getState("d", "0") != gainLossStates2) {
                return false;
            }
            if (characterStateMatrix14.getState("abcd", "0") != gainLossStates) {
                return false;
            }
            FitchParsimony fitchParsimony9 = new FitchParsimony();
            PhylogenyFactory phylogenyFactory9 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny9 = phylogenyFactory9.create("(((a,b)ab,c)abc,d)abcd", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix9 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(4, 1);
            basicCharacterStateMatrix9.setIdentifier(0, "a");
            basicCharacterStateMatrix9.setIdentifier(1, "b");
            basicCharacterStateMatrix9.setIdentifier(2, "c");
            basicCharacterStateMatrix9.setIdentifier(3, "d");
            basicCharacterStateMatrix9.setCharacter(0, "0");
            basicCharacterStateMatrix9.setState("a", "0", binaryStates);
            basicCharacterStateMatrix9.setState("b", "0", binaryStates2);
            basicCharacterStateMatrix9.setState("c", "0", binaryStates);
            basicCharacterStateMatrix9.setState("d", "0", binaryStates2);
            fitchParsimony9.setReturnInternalStates(true);
            fitchParsimony9.setReturnGainLossMatrix(true);
            fitchParsimony9.setUseLast(false);
            fitchParsimony9.execute(phylogeny9, basicCharacterStateMatrix9);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix15 = fitchParsimony9.getGainLossMatrix();
            if (fitchParsimony9.getCost() != 2) {
                return false;
            }
            if (fitchParsimony9.getTotalLosses() != 1) {
                return false;
            }
            if (fitchParsimony9.getTotalGains() != 1) {
                return false;
            }
            if (fitchParsimony9.getTotalUnchanged() != 5) {
                return false;
            }
            if (characterStateMatrix15.getState("a", "0") != gainLossStates3) {
                return false;
            }
            if (characterStateMatrix15.getState("b", "0") != gainLossStates2) {
                return false;
            }
            if (characterStateMatrix15.getState("c", "0") != gainLossStates3) {
                return false;
            }
            if (characterStateMatrix15.getState("d", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix15.getState("ab", "0") != gainLossStates3) {
                return false;
            }
            if (characterStateMatrix15.getState("abc", "0") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix15.getState("abcd", "0") != gainLossStates4) {
                return false;
            }
            fitchParsimony9.setUseLast(true);
            fitchParsimony9.execute(phylogeny9, basicCharacterStateMatrix9);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix16 = fitchParsimony9.getGainLossMatrix();
            if (fitchParsimony9.getCost() != 2) {
                return false;
            }
            if (fitchParsimony9.getTotalLosses() != 2) {
                return false;
            }
            if (fitchParsimony9.getTotalGains() != 0) {
                return false;
            }
            if (fitchParsimony9.getTotalUnchanged() != 5) {
                return false;
            }
            if (characterStateMatrix16.getState("a", "0") != gainLossStates3) {
                return false;
            }
            if (characterStateMatrix16.getState("b", "0") != gainLossStates2) {
                return false;
            }
            if (characterStateMatrix16.getState("c", "0") != gainLossStates3) {
                return false;
            }
            if (characterStateMatrix16.getState("d", "0") != gainLossStates2) {
                return false;
            }
            if (characterStateMatrix16.getState("ab", "0") != gainLossStates3) {
                return false;
            }
            if (characterStateMatrix16.getState("abc", "0") != gainLossStates3) {
                return false;
            }
            if (characterStateMatrix16.getState("abcd", "0") != gainLossStates3) {
                return false;
            }
            fitchParsimony9.setUseLast(false);
            fitchParsimony9.setRandomize(true);
            fitchParsimony9.setRandomNumberSeed(8722445L);
            fitchParsimony9.execute(phylogeny9, basicCharacterStateMatrix9);
            fitchParsimony9.getGainLossMatrix();
            if (fitchParsimony9.getCost() != 2) {
                return false;
            }
            if (fitchParsimony9.getTotalLosses() != 1) {
                return false;
            }
            if (fitchParsimony9.getTotalGains() != 1) {
                return false;
            }
            if (fitchParsimony9.getTotalUnchanged() != 5) {
                return false;
            }
            FitchParsimony fitchParsimony10 = new FitchParsimony();
            PhylogenyFactory phylogenyFactory10 = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny10 = phylogenyFactory10.create("((((a,b)ab,c)abc,d)abcd,e)abcde", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix10 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(5, 1);
            basicCharacterStateMatrix10.setIdentifier(0, "a");
            basicCharacterStateMatrix10.setIdentifier(1, "b");
            basicCharacterStateMatrix10.setIdentifier(2, "c");
            basicCharacterStateMatrix10.setIdentifier(3, "d");
            basicCharacterStateMatrix10.setIdentifier(4, "e");
            basicCharacterStateMatrix10.setCharacter(0, "0");
            basicCharacterStateMatrix10.setState("a", "0", binaryStates);
            basicCharacterStateMatrix10.setState("b", "0", binaryStates2);
            basicCharacterStateMatrix10.setState("c", "0", binaryStates2);
            basicCharacterStateMatrix10.setState("d", "0", binaryStates);
            basicCharacterStateMatrix10.setState("e", "0", binaryStates2);
            fitchParsimony10.setReturnInternalStates(true);
            fitchParsimony10.setReturnGainLossMatrix(true);
            fitchParsimony10.setUseLast(false);
            fitchParsimony10.execute(phylogeny10, basicCharacterStateMatrix10);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix17 = fitchParsimony10.getGainLossMatrix();
            if (fitchParsimony10.getCost() != 2) {
                return false;
            }
            if (fitchParsimony10.getTotalLosses() != 0) {
                return false;
            }
            if (fitchParsimony10.getTotalGains() != 2) {
                return false;
            }
            if (fitchParsimony10.getTotalUnchanged() != 7) {
                return false;
            }
            if (characterStateMatrix17.getState("a", "0") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix17.getState("b", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix17.getState("c", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix17.getState("d", "0") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix17.getState("e", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix17.getState("ab", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix17.getState("abc", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix17.getState("abcd", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix17.getState("abcde", "0") != gainLossStates4) {
                return false;
            }
            fitchParsimony10.setUseLast(true);
            fitchParsimony10.execute(phylogeny10, basicCharacterStateMatrix10);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix18 = fitchParsimony10.getGainLossMatrix();
            if (fitchParsimony10.getCost() != 2) {
                return false;
            }
            if (fitchParsimony10.getTotalLosses() != 0) {
                return false;
            }
            if (fitchParsimony10.getTotalGains() != 2) {
                return false;
            }
            if (fitchParsimony10.getTotalUnchanged() != 7) {
                return false;
            }
            if (characterStateMatrix18.getState("a", "0") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix18.getState("b", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix18.getState("c", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix18.getState("d", "0") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix18.getState("e", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix18.getState("ab", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix18.getState("abc", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix18.getState("abcd", "0") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix18.getState("abcde", "0") != gainLossStates4) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testNeighborJoining() {
        try {
            BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = new BasicSymmetricalDistanceMatrix(6);
            basicSymmetricalDistanceMatrix.setRow("5", 1);
            basicSymmetricalDistanceMatrix.setRow("4 7", 2);
            basicSymmetricalDistanceMatrix.setRow("7 10 7", 3);
            basicSymmetricalDistanceMatrix.setRow("6 9 6 5", 4);
            basicSymmetricalDistanceMatrix.setRow("8 11 8 9 8", 5);
            basicSymmetricalDistanceMatrix.setIdentifier(0, "A");
            basicSymmetricalDistanceMatrix.setIdentifier(1, "B");
            basicSymmetricalDistanceMatrix.setIdentifier(2, "C");
            basicSymmetricalDistanceMatrix.setIdentifier(3, "D");
            basicSymmetricalDistanceMatrix.setIdentifier(4, "E");
            basicSymmetricalDistanceMatrix.setIdentifier(5, "F");
            NeighborJoining neighborJoining = NeighborJoining.createInstance();
            neighborJoining.execute(basicSymmetricalDistanceMatrix);
            basicSymmetricalDistanceMatrix = new BasicSymmetricalDistanceMatrix(7);
            basicSymmetricalDistanceMatrix.setIdentifier(0, "Bovine");
            basicSymmetricalDistanceMatrix.setIdentifier(1, "Mouse");
            basicSymmetricalDistanceMatrix.setIdentifier(2, "Gibbon");
            basicSymmetricalDistanceMatrix.setIdentifier(3, "Orang");
            basicSymmetricalDistanceMatrix.setIdentifier(4, "Gorilla");
            basicSymmetricalDistanceMatrix.setIdentifier(5, "Chimp");
            basicSymmetricalDistanceMatrix.setIdentifier(6, "Human");
            basicSymmetricalDistanceMatrix.setRow("0.00000 1.68660 1.71980 1.66060 1.52430 1.60430 1.59050", 0);
            basicSymmetricalDistanceMatrix.setRow("1.68660 0.00000 1.52320 1.48410 1.44650 1.43890 1.46290", 1);
            basicSymmetricalDistanceMatrix.setRow("1.71980 1.52320 0.00000 0.71150 0.59580 0.61790 0.55830", 2);
            basicSymmetricalDistanceMatrix.setRow("1.66060 1.48410 0.71150 0.00000 0.46310 0.50610 0.47100", 3);
            basicSymmetricalDistanceMatrix.setRow("1.52430 1.44650 0.59580 0.46310 0.00000 0.34840 0.30830", 4);
            basicSymmetricalDistanceMatrix.setRow("1.60430 1.43890 0.61790 0.50610 0.34840 0.00000 0.26920", 5);
            basicSymmetricalDistanceMatrix.setRow("1.59050 1.46290 0.55830 0.47100 0.30830 0.26920 0.00000", 6);
            neighborJoining.execute(basicSymmetricalDistanceMatrix);
            basicSymmetricalDistanceMatrix = new BasicSymmetricalDistanceMatrix(4);
            basicSymmetricalDistanceMatrix.setIdentifier(0, "A");
            basicSymmetricalDistanceMatrix.setIdentifier(1, "B");
            basicSymmetricalDistanceMatrix.setIdentifier(2, "C");
            basicSymmetricalDistanceMatrix.setIdentifier(3, "D");
            basicSymmetricalDistanceMatrix.setRow("0.00 0.95 0.17 0.98", 0);
            basicSymmetricalDistanceMatrix.setRow("0.95 0.00 1.02 1.83", 1);
            basicSymmetricalDistanceMatrix.setRow("0.17 1.02 0.00 1.01", 2);
            basicSymmetricalDistanceMatrix.setRow("0.98 1.83 1.01 0.00", 3);
            Phylogeny phylogeny = neighborJoining.execute(basicSymmetricalDistanceMatrix);
            phylogeny.reRoot(phylogeny.getNode("C").getParent());
            if (!TestPhylogenyReconstruction.isEqual(phylogeny.getNode("A").getDistanceToParent(), 0.05)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(phylogeny.getNode("B").getDistanceToParent(), 0.9)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(phylogeny.getNode("C").getDistanceToParent(), 0.1)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(phylogeny.getNode("D").getDistanceToParent(), 0.91)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testSymmetricalDistanceMatrixParser() {
        try {
            String string = ForesterUtil.getLineSeparator();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" 4" + string);
            stringBuffer.append("A 0 0 0 0" + string);
            stringBuffer.append("B 1 0 0 0" + string);
            stringBuffer.append("C 2 4 0 0" + string);
            stringBuffer.append("D 3 5 6 0" + string);
            stringBuffer.append(string);
            stringBuffer.append(" 4" + string);
            stringBuffer.append("A 0   11  12  13" + string);
            stringBuffer.append("B 11  0   14  15" + string);
            stringBuffer.append("C 12  14  0   16" + string);
            stringBuffer.append("D 13  15  16  0" + string);
            stringBuffer.append(string);
            stringBuffer.append(string);
            stringBuffer.append("     " + string);
            stringBuffer.append(" 4" + string);
            stringBuffer.append(" A        0     " + string);
            stringBuffer.append(" B            21 0" + string);
            stringBuffer.append(" C            22 24    0  " + string);
            stringBuffer.append(" # 2 222 2 2 " + string);
            stringBuffer.append(" D            23 25 26 0" + string);
            stringBuffer.append(string);
            stringBuffer.append(string);
            stringBuffer.append("     " + string);
            SymmetricalDistanceMatrixParser symmetricalDistanceMatrixParser = SymmetricalDistanceMatrixParser.createInstance();
            DistanceMatrix[] distanceMatrixArray = symmetricalDistanceMatrixParser.parse(stringBuffer.toString());
            if (distanceMatrixArray.length != 3) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[0].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[0].getValue(1, 0), 1.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[0].getValue(2, 0), 2.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[0].getValue(3, 0), 3.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[0].getValue(0, 1), 1.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[0].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[0].getValue(2, 1), 4.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[0].getValue(3, 1), 5.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[1].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[1].getValue(1, 0), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[1].getValue(2, 0), 12.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[1].getValue(3, 0), 13.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[1].getValue(0, 1), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[1].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[1].getValue(2, 1), 14.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[1].getValue(3, 1), 15.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[2].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[2].getValue(1, 0), 21.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[2].getValue(2, 0), 22.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[2].getValue(3, 0), 23.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[2].getValue(0, 1), 21.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[2].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[2].getValue(2, 1), 24.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray[2].getValue(3, 1), 25.0)) {
                return false;
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("A 0 0 0 0" + string);
            stringBuffer.append("B 1 0 0 0" + string);
            stringBuffer.append("C 2 4 0 0" + string);
            stringBuffer.append("D 3 5 6 0" + string);
            stringBuffer.append(" " + string);
            stringBuffer.append("A 0   11  12  13" + string);
            stringBuffer.append("B 11  0   14  15" + string);
            stringBuffer.append("C 12  14  0   16" + string);
            stringBuffer.append("D 13  15  16  0" + string);
            stringBuffer.append(string);
            stringBuffer.append(" A        0     " + string);
            stringBuffer.append(" B            21 0" + string);
            stringBuffer.append(" C            22 24    0  " + string);
            stringBuffer.append(" # 2 222 2 2 " + string);
            stringBuffer.append(" D            23 25 26 0" + string);
            DistanceMatrix[] distanceMatrixArray2 = symmetricalDistanceMatrixParser.parse(stringBuffer.toString());
            if (distanceMatrixArray2.length != 3) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[0].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[0].getValue(1, 0), 1.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[0].getValue(2, 0), 2.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[0].getValue(3, 0), 3.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[0].getValue(0, 1), 1.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[0].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[0].getValue(2, 1), 4.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[0].getValue(3, 1), 5.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[1].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[1].getValue(1, 0), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[1].getValue(2, 0), 12.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[1].getValue(3, 0), 13.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[1].getValue(0, 1), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[1].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[1].getValue(2, 1), 14.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[1].getValue(3, 1), 15.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[2].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[2].getValue(1, 0), 21.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[2].getValue(2, 0), 22.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[2].getValue(3, 0), 23.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[2].getValue(0, 1), 21.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[2].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[2].getValue(2, 1), 24.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray2[2].getValue(3, 1), 25.0)) {
                return false;
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("A 0" + string);
            stringBuffer.append("B 10 0" + string);
            DistanceMatrix[] distanceMatrixArray3 = symmetricalDistanceMatrixParser.parse(stringBuffer.toString());
            if (distanceMatrixArray3.length != 1) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray3[0].getValue(0, 1), 10.0)) {
                return false;
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append(" " + string);
            stringBuffer.append("#" + string);
            DistanceMatrix[] distanceMatrixArray4 = symmetricalDistanceMatrixParser.parse(stringBuffer.toString());
            if (distanceMatrixArray4.length != 0) {
                return false;
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append(" " + string);
            stringBuffer.append("A 0   11  12  13" + string);
            stringBuffer.append("B     0   14  15" + string);
            stringBuffer.append("C         0   16" + string);
            stringBuffer.append("D              0" + string);
            stringBuffer.append(string);
            stringBuffer.append("A 0 21  22  23" + string);
            stringBuffer.append("B 0 24  25" + string);
            stringBuffer.append("C 0 26" + string);
            stringBuffer.append("D 0" + string);
            symmetricalDistanceMatrixParser.setInputMatrixType(SymmetricalDistanceMatrixParser.InputMatrixType.UPPER_TRIANGLE);
            DistanceMatrix[] distanceMatrixArray5 = symmetricalDistanceMatrixParser.parse(stringBuffer);
            if (distanceMatrixArray5.length != 2) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(1, 0), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(2, 0), 12.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(3, 0), 13.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(0, 1), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(2, 1), 14.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(3, 1), 15.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(0, 2), 12.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(1, 2), 14.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(2, 2), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(3, 2), 16.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(0, 3), 13.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(1, 3), 15.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(2, 3), 16.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray5[0].getValue(3, 3), 0.0)) {
                return false;
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append(" 4 " + string);
            stringBuffer.append("A 0   11  12  13" + string);
            stringBuffer.append("B     0   14  15" + string);
            stringBuffer.append("C         0   16" + string);
            stringBuffer.append("D              0" + string);
            stringBuffer.append(" 4" + string);
            stringBuffer.append("A 0 21  22  23" + string);
            stringBuffer.append("B 0 24  25" + string);
            stringBuffer.append("C 0 26" + string);
            stringBuffer.append("D 0" + string);
            stringBuffer.append("     " + string);
            stringBuffer.append(" 4" + string);
            stringBuffer.append("A 0 21  22  23" + string);
            stringBuffer.append("B 0 24  25" + string);
            stringBuffer.append("C 0 26" + string);
            stringBuffer.append("D 0" + string);
            stringBuffer.append(string);
            stringBuffer.append("A 0 21  22  23" + string);
            stringBuffer.append("B 0 24  25" + string);
            stringBuffer.append("C 0 26" + string);
            stringBuffer.append("D 0" + string);
            symmetricalDistanceMatrixParser.setInputMatrixType(SymmetricalDistanceMatrixParser.InputMatrixType.UPPER_TRIANGLE);
            DistanceMatrix[] distanceMatrixArray6 = symmetricalDistanceMatrixParser.parse(stringBuffer);
            if (distanceMatrixArray6.length != 4) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(1, 0), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(2, 0), 12.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(3, 0), 13.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(0, 1), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(2, 1), 14.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(3, 1), 15.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(0, 2), 12.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(1, 2), 14.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(2, 2), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(3, 2), 16.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(0, 3), 13.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(1, 3), 15.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(2, 3), 16.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(distanceMatrixArray6[0].getValue(3, 3), 0.0)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static void timeNeighborJoining() {
        NeighborJoining neighborJoining = NeighborJoining.createInstance();
        for (int i = 3; i <= 13; ++i) {
            int n = (int)Math.pow(2.0, i);
            BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = new BasicSymmetricalDistanceMatrix(n);
            basicSymmetricalDistanceMatrix.randomize(new Date().getTime());
            long l = new Date().getTime();
            neighborJoining.execute(basicSymmetricalDistanceMatrix);
            System.out.println("Size: " + n + " -> " + (new Date().getTime() - l) + "ms.");
        }
    }
}

