/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.distance;

import java.util.ArrayList;
import java.util.List;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.ForesterUtil;

public final class NeighborJoining {
    private BasicSymmetricalDistanceMatrix _d;
    private double[][] _d_values;
    private double[][] _m_values;
    private double[] _r;
    private int _n;
    private PhylogenyNode[] _external_nodes;
    private int[] _mappings;
    private final boolean _verbose;
    private static final boolean DEBUG = false;

    private NeighborJoining(boolean bl) {
        this._verbose = bl;
    }

    private final void calculateDistancesFromNewNode(int n, int n2, double d) {
        int n3 = this._mappings[n];
        int n4 = this._mappings[n2];
        for (int i = 0; i < this._n; ++i) {
            if (i == n || i == n2) continue;
            int n5 = this._mappings[i];
            this._d_values[n3][n5] = (this._d_values[n3][n5] + this._d_values[n5][n4] - 2.0) / 2.0;
        }
    }

    private final void calculateNetDivergences() {
        for (int i = 0; i < this._n; ++i) {
            double d = 0.0;
            int n = this._mappings[i];
            for (int j = 0; j < this._n; ++j) {
                d += this._d_values[n][this._mappings[j]];
            }
            this._r[i] = d;
        }
    }

    public final Phylogeny execute(BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        double d;
        this.reset(basicSymmetricalDistanceMatrix);
        Phylogeny phylogeny = new Phylogeny();
        while (this._n > 2) {
            this.updateM();
            d = Double.MAX_VALUE;
            int n = -1;
            int n2 = -1;
            for (int i = 1; i < this._n; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (!(this._m_values[j][i] < d)) continue;
                    d = this._m_values[j][i];
                    n = j;
                    n2 = i;
                }
            }
            PhylogenyNode phylogenyNode = new PhylogenyNode();
            double d2 = this.getValueFromD(n, n2);
            double d3 = d2 / 2.0 + (this._r[n] - this._r[n2]) / (double)(2 * (this._n - 2));
            double d4 = d2 - d3;
            this.getExternalPhylogenyNode(n).setDistanceToParent(d3);
            this.getExternalPhylogenyNode(n2).setDistanceToParent(d4);
            phylogenyNode.addAsChild(this.getExternalPhylogenyNode(n));
            phylogenyNode.addAsChild(this.getExternalPhylogenyNode(n2));
            if (this._verbose) {
                this.printProgress(n, n2);
            }
            this.calculateDistancesFromNewNode(n, n2, d2);
            this._external_nodes[this._mappings[n]] = phylogenyNode;
            this.updateMappings(n2);
            --this._n;
        }
        d = this.getValueFromD(0, 1) / 2.0;
        this.getExternalPhylogenyNode(0).setDistanceToParent(d);
        this.getExternalPhylogenyNode(1).setDistanceToParent(d);
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        phylogenyNode.addAsChild(this.getExternalPhylogenyNode(0));
        phylogenyNode.addAsChild(this.getExternalPhylogenyNode(1));
        if (this._verbose) {
            this.printProgress(0, 1);
        }
        phylogeny.setRoot(phylogenyNode);
        phylogeny.setRooted(false);
        return phylogeny;
    }

    public final List<Phylogeny> execute(List<BasicSymmetricalDistanceMatrix> list) {
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
        for (BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix : list) {
            arrayList.add(this.execute(basicSymmetricalDistanceMatrix));
        }
        return arrayList;
    }

    private final PhylogenyNode getExternalPhylogenyNode(int n) {
        return this._external_nodes[this._mappings[n]];
    }

    private final double getValueFromD(int n, int n2) {
        return this._d_values[this._mappings[n]][this._mappings[n2]];
    }

    private final void initExternalNodes() {
        this._external_nodes = new PhylogenyNode[this._n];
        for (int i = 0; i < this._n; ++i) {
            this._external_nodes[i] = new PhylogenyNode();
            String string = this._d.getIdentifier(i);
            if (string != null) {
                this._external_nodes[i].setName(string);
            } else {
                this._external_nodes[i].setName("" + i);
            }
            this._mappings[i] = i;
        }
    }

    private final void printProgress(int n, int n2) {
        PhylogenyNode phylogenyNode = this.getExternalPhylogenyNode(n);
        PhylogenyNode phylogenyNode2 = this.getExternalPhylogenyNode(n2);
        System.out.println("Node " + (ForesterUtil.isEmpty(phylogenyNode.getName()) ? Integer.valueOf(phylogenyNode.getId()) : phylogenyNode.getName()) + " joins " + (ForesterUtil.isEmpty(phylogenyNode2.getName()) ? Integer.valueOf(phylogenyNode2.getId()) : phylogenyNode2.getName()));
    }

    private final void reset(BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        this._n = basicSymmetricalDistanceMatrix.getSize();
        this._d = basicSymmetricalDistanceMatrix;
        this._r = new double[this._n];
        this._mappings = new int[this._n];
        this._d_values = this._d.getValues();
        this._m_values = new double[this._n][this._n];
        this.initExternalNodes();
    }

    private final void updateM() {
        this.calculateNetDivergences();
        int n = this._n - 2;
        for (int i = 1; i < this._n; ++i) {
            double d = this._r[i];
            int n2 = this._mappings[i];
            for (int j = 0; j < i; ++j) {
                this._m_values[j][i] = this._d_values[this._mappings[j]][n2] - (this._r[j] + d) / (double)n;
            }
        }
    }

    private final void updateMappings(int n) {
        for (int i = n; i < this._mappings.length - 1; ++i) {
            this._mappings[i] = this._mappings[i + 1];
        }
    }

    public static final NeighborJoining createInstance() {
        return new NeighborJoining(false);
    }

    public static final NeighborJoining createInstance(boolean bl) {
        return new NeighborJoining(bl);
    }
}

