/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.matrix.character;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.util.ForesterUtil;
import org.forester.util.IllegalFormatUseException;

public class BasicCharacterStateMatrix<S>
implements CharacterStateMatrix<S> {
    final Object[][] _states;
    final String[] _identifiers;
    final String[] _characters;
    final Map<String, Integer> _identifier_index_map;
    final Map<String, Integer> _character_index_map;

    public BasicCharacterStateMatrix(int n, int n2) {
        this._states = new Object[n][n2];
        this._identifiers = new String[n];
        this._characters = new String[n2];
        this._identifier_index_map = new HashMap<String, Integer>(n);
        this._character_index_map = new HashMap<String, Integer>(n2);
    }

    public BasicCharacterStateMatrix(int n, int n2, S s) {
        this(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.setState(i, j, s);
            }
        }
    }

    public BasicCharacterStateMatrix(List<List<S>> list) {
        if (list == null || list.size() < 1 || list.get(0) == null) {
            throw new IllegalArgumentException("attempt to create character state matrix from empty list");
        }
        int n = list.get(0).size();
        int n2 = list.size();
        this._states = new Object[n2][n];
        this._identifiers = new String[n2];
        this._characters = new String[n];
        this._identifier_index_map = new HashMap<String, Integer>(n2);
        this._character_index_map = new HashMap<String, Integer>(n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.setState(i, j, list.get(i).get(j));
            }
        }
    }

    public BasicCharacterStateMatrix(S[][] SArray) {
        this(SArray.length, SArray[0].length);
        for (int i = 0; i < SArray.length; ++i) {
            for (int j = 0; j < SArray[0].length; ++j) {
                this.setState(i, j, SArray[i][j]);
            }
        }
    }

    @Override
    public boolean containsCharacter(String string) {
        return this._character_index_map.containsKey(string);
    }

    @Override
    public boolean containsIdentifier(String string) {
        return this._identifier_index_map.containsKey(string);
    }

    @Override
    public CharacterStateMatrix<S> copy() {
        int n;
        BasicCharacterStateMatrix<S> basicCharacterStateMatrix = new BasicCharacterStateMatrix<S>(this.getNumberOfIdentifiers(), this.getNumberOfCharacters());
        for (n = 0; n < this.getNumberOfCharacters(); ++n) {
            if (this.getCharacter(n) == null) continue;
            basicCharacterStateMatrix.setCharacter(n, this.getCharacter(n));
        }
        for (n = 0; n < this.getNumberOfIdentifiers(); ++n) {
            if (this.getIdentifier(n) != null) {
                basicCharacterStateMatrix.setIdentifier(n, this.getIdentifier(n));
            }
            for (int i = 0; i < this.getNumberOfCharacters(); ++i) {
                basicCharacterStateMatrix.setState(n, i, this.getState(n, i));
            }
        }
        return basicCharacterStateMatrix;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check character state matrix equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check character state matrix to " + object + " [" + object.getClass() + "]");
        }
        CharacterStateMatrix characterStateMatrix = (CharacterStateMatrix)object;
        if (this.getNumberOfIdentifiers() != characterStateMatrix.getNumberOfIdentifiers() || this.getNumberOfCharacters() != characterStateMatrix.getNumberOfCharacters()) {
            // empty if block
        }
        for (int i = 0; i < this.getNumberOfIdentifiers(); ++i) {
            for (int j = 0; j < this.getNumberOfCharacters(); ++j) {
                Object s;
                S s2 = this.getState(i, j);
                if (s2 == (s = characterStateMatrix.getState(i, j))) continue;
                if (s2 == null && s != null) {
                    return false;
                }
                if (s2 != null && s == null) {
                    return false;
                }
                if (s2.equals(characterStateMatrix.getState(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getCharacter(int n) {
        return this._characters[n];
    }

    @Override
    public int getCharacterIndex(String string) {
        if (!this._character_index_map.containsKey(string)) {
            throw new IllegalArgumentException("character [" + string + "] not found");
        }
        return this._character_index_map.get(string);
    }

    @Override
    public String getIdentifier(int n) {
        return this._identifiers[n];
    }

    @Override
    public int getIdentifierIndex(String string) {
        if (!this._identifier_index_map.containsKey(string)) {
            throw new IllegalArgumentException("indentifier [" + string + "] not found");
        }
        return this._identifier_index_map.get(string);
    }

    private int getLengthOfLongestState() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfIdentifiers(); ++i) {
            for (int j = 0; j < this.getNumberOfCharacters(); ++j) {
                int n2;
                S s = this.getState(i, j);
                if (s == null || (n2 = this.getState(i, j).toString().length()) <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    @Override
    public int getNumberOfCharacters() {
        if (!this.isEmpty()) {
            return this._states[0].length;
        }
        return 0;
    }

    @Override
    public int getNumberOfIdentifiers() {
        return this._states.length;
    }

    @Override
    public S getState(int n, int n2) {
        return (S)this._states[n][n2];
    }

    @Override
    public S getState(String string, int n) {
        if (!this.containsIdentifier(string)) {
            throw new IllegalArgumentException("identifier [" + string + "] not found");
        }
        return this.getState(this._identifier_index_map.get(string), n);
    }

    @Override
    public S getState(String string, String string2) {
        if (!this.containsIdentifier(string)) {
            throw new IllegalArgumentException("identifier [" + string + "] not found");
        }
        if (!this.containsCharacter(string2)) {
            throw new IllegalArgumentException("character [" + string2 + "] not found");
        }
        return this.getState(this._identifier_index_map.get(string), (int)this._character_index_map.get(string2));
    }

    @Override
    public boolean isEmpty() {
        return this.getNumberOfIdentifiers() <= 0;
    }

    @Override
    public CharacterStateMatrix<S> pivot() {
        int n;
        BasicCharacterStateMatrix<S> basicCharacterStateMatrix = new BasicCharacterStateMatrix<S>(this.getNumberOfCharacters(), this.getNumberOfIdentifiers());
        for (n = 0; n < this.getNumberOfCharacters(); ++n) {
            if (this.getCharacter(n) == null) continue;
            basicCharacterStateMatrix.setIdentifier(n, this.getCharacter(n));
        }
        for (n = 0; n < this.getNumberOfIdentifiers(); ++n) {
            if (this.getIdentifier(n) != null) {
                basicCharacterStateMatrix.setCharacter(n, this.getIdentifier(n));
            }
            for (int i = 0; i < this.getNumberOfCharacters(); ++i) {
                basicCharacterStateMatrix.setState(i, n, this.getState(n, i));
            }
        }
        return basicCharacterStateMatrix;
    }

    @Override
    public void setCharacter(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException("attempt to use null character");
        }
        this._characters[n] = string;
        if (this._character_index_map.containsKey(string)) {
            throw new IllegalArgumentException("character [" + string + "] is not unique");
        }
        this._character_index_map.put(string, n);
    }

    @Override
    public void setIdentifier(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException("attempt to use null identifier");
        }
        this._identifiers[n] = string;
        if (this._identifier_index_map.containsKey(string)) {
            throw new IllegalArgumentException("identifier [" + string + "] is not unique");
        }
        this._identifier_index_map.put(string, n);
    }

    @Override
    public void setState(int n, int n2, S s) {
        this._states[n][n2] = s;
    }

    @Override
    public void setState(String string, int n, S s) {
        if (!this._identifier_index_map.containsKey(string)) {
            throw new IllegalArgumentException("identifier [" + string + "] not found");
        }
        this.setState(this._identifier_index_map.get(string), n, s);
    }

    @Override
    public void setState(String string, String string2, S s) {
        if (!this.containsIdentifier(string)) {
            throw new IllegalArgumentException("identifier [" + string + "] not found");
        }
        if (!this.containsCharacter(string2)) {
            throw new IllegalArgumentException("character [" + string2 + "] not found");
        }
        this.setState(this._identifier_index_map.get(string), (int)this._character_index_map.get(string2), s);
    }

    private void toForester(Writer writer) throws IOException {
        int n;
        int n2 = this.getLengthOfLongestState() + 5;
        writer.write("Identifiers: ");
        writer.write(String.valueOf(this.getNumberOfIdentifiers()));
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("Characters : ");
        writer.write(String.valueOf(this.getNumberOfCharacters()));
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(ForesterUtil.pad("", 20, ' ', false).toString());
        writer.write(32);
        for (n = 0; n < this.getNumberOfCharacters(); ++n) {
            String string = this.getCharacter(n);
            writer.write(string != null ? ForesterUtil.pad(string, n2, ' ', false).toString() : ForesterUtil.pad("", n2, ' ', false).toString());
            if (n >= this.getNumberOfCharacters() - 1) continue;
            writer.write(32);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        for (n = 0; n < this.getNumberOfIdentifiers(); ++n) {
            if (this.getIdentifier(n) != null) {
                writer.write(ForesterUtil.pad(this.getIdentifier(n), 20, ' ', false).toString());
                writer.write(32);
            }
            for (int i = 0; i < this.getNumberOfCharacters(); ++i) {
                S s = this.getState(n, i);
                writer.write(s != null ? ForesterUtil.pad(s.toString(), n2, ' ', false).toString() : ForesterUtil.pad("", n2, ' ', false).toString());
                if (i >= this.getNumberOfCharacters() - 1) continue;
                writer.write(32);
            }
            if (n >= this.getNumberOfIdentifiers() - 1) continue;
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
    }

    private void toNexus(Writer writer) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        writer.write("#NEXUS");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        this.writeNexusTaxaBlock(writer);
        this.writeNexusBinaryChractersBlock(writer);
    }

    private void toPhylip(Writer writer) throws IOException {
        writer.write(32);
        writer.write(32);
        writer.write(32);
        writer.write(32);
        writer.write(this.getNumberOfIdentifiers());
        writer.write(32);
        writer.write(this.getNumberOfCharacters());
        writer.write(ForesterUtil.LINE_SEPARATOR);
        for (int i = 0; i < this.getNumberOfIdentifiers(); ++i) {
            if (ForesterUtil.isEmpty(this.getIdentifier(i))) {
                throw new IllegalFormatUseException("Phylip format does not allow empty identifiers");
            }
            writer.write(ForesterUtil.pad(this.getIdentifier(i), 6, ' ', false).toString());
            writer.write(32);
            writer.write(32);
            writer.write("");
            for (int j = 0; j < this.getNumberOfCharacters(); ++j) {
                String string = this.getState(i, j).toString();
                writer.write(string != null ? ForesterUtil.pad(string, 6, ' ', false).toString() : ForesterUtil.pad("", 6, ' ', false).toString());
                if (j >= this.getNumberOfCharacters() - 1) continue;
                writer.write(32);
                writer.write(32);
            }
            if (i >= this.getNumberOfIdentifiers() - 1) continue;
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
    }

    @Override
    public void toWriter(Writer writer) throws IOException {
        this.toForester(writer);
    }

    @Override
    public void toWriter(Writer writer, CharacterStateMatrix.Format format) throws IOException {
        switch (format) {
            case PHYLIP: {
                this.toPhylip(writer);
                break;
            }
            case FORESTER: {
                this.toForester(writer);
                break;
            }
            case NEXUS_BINARY: {
                this.toNexus(writer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format:" + (Object)((Object)format));
            }
        }
    }

    public void writeNexusBinaryChractersBlock(Writer writer) throws IOException {
        writer.write("Begin Characters;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(" ");
        writer.write("Dimensions");
        writer.write(" ");
        writer.write("NChar");
        writer.write("=");
        writer.write(String.valueOf(this.getNumberOfCharacters()));
        writer.write(";");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        this.writeNexusCharstatelabels(writer);
        writer.write(" ");
        writer.write("Format");
        writer.write(" ");
        writer.write("DataType");
        writer.write("=");
        writer.write("Standard");
        writer.write(" ");
        writer.write("Symbols");
        writer.write("=\"");
        writer.write(String.valueOf((Object)CharacterStateMatrix.BinaryStates.ABSENT));
        writer.write(String.valueOf((Object)CharacterStateMatrix.BinaryStates.PRESENT));
        writer.write("\";");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        this.writeNexusMatrix(writer);
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("End;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    public void writeNexusCharstatelabels(Writer writer) throws IOException {
        writer.write(" ");
        writer.write("CharStateLabels");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        for (int i = 0; i < this.getNumberOfCharacters(); ++i) {
            writer.write("  " + (i + 1) + " '");
            writer.write(this.getCharacter(i));
            writer.write("'");
            if (i >= this.getNumberOfCharacters() - 1) continue;
            writer.write(",");
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
        writer.write(";");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    public void writeNexusMatrix(Writer writer) throws IOException {
        writer.write(" ");
        writer.write("Matrix");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        for (int i = 0; i < this.getNumberOfIdentifiers(); ++i) {
            if (this.getIdentifier(i) != null) {
                writer.write("  ");
                writer.write(ForesterUtil.pad(this.getIdentifier(i), 20, ' ', false).toString());
                writer.write(32);
            }
            for (int j = 0; j < this.getNumberOfCharacters(); ++j) {
                S s = this.getState(i, j);
                if (s == null) {
                    throw new IllegalFormatUseException("character state matrix cannot contain null if to be represented in nexus format");
                }
                if (!(s instanceof CharacterStateMatrix.BinaryStates)) {
                    throw new IllegalFormatUseException("nexus format representation expects binary character data - got [" + this.getState(0, 0).getClass() + "] instead");
                }
                if (s == CharacterStateMatrix.BinaryStates.UNKNOWN) {
                    throw new IllegalFormatUseException("character state matrix cannot contain unknown states if to be represented in nexus format");
                }
                writer.write(s.toString());
            }
            if (i >= this.getNumberOfIdentifiers() - 1) continue;
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
        writer.write(";");
    }

    public void writeNexusTaxaBlock(Writer writer) throws IOException {
        writer.write("Begin Taxa;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(" ");
        writer.write("Dimensions");
        writer.write(" ");
        writer.write("NTax");
        writer.write("=");
        writer.write(String.valueOf(this.getNumberOfIdentifiers()));
        writer.write(";");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(" ");
        writer.write("TaxLabels");
        for (int i = 0; i < this.getNumberOfIdentifiers(); ++i) {
            writer.write(" ");
            writer.write(this.getIdentifier(i));
        }
        writer.write(";");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("End;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }
}

