/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import org.forester.go.GoSubset;

public class BasicGoSubset
implements GoSubset {
    final GoSubset.Type _type;

    public BasicGoSubset(String string) {
        String string2 = string.trim().toLowerCase();
        if (string2.equals("goslim_generic")) {
            this._type = GoSubset.Type.GOSLIM_GENERIC;
        } else if (string2.equals("goslim_goa")) {
            this._type = GoSubset.Type.GOSLIM_GOA;
        } else if (string2.equals("goslim_pir")) {
            this._type = GoSubset.Type.GOSLIM_PIR;
        } else if (string2.equals("gosubset_prok")) {
            this._type = GoSubset.Type.GOSUBSET_PROK;
        } else if (string2.equals("goslim_candida")) {
            this._type = GoSubset.Type.GOSLIM_CANDIDA;
        } else if (string2.equals("goslim_aspergillus")) {
            this._type = GoSubset.Type.GOSLIM_ASPERGILLUS;
        } else if (string2.equals("goslim_plant")) {
            this._type = GoSubset.Type.GOSLIM_PLANT;
        } else if (string2.equals("goslim_yeast")) {
            this._type = GoSubset.Type.GOSLIM_YEAST;
        } else if (string2.equals("goslim_pombe")) {
            this._type = GoSubset.Type.GOSLIM_POMBE;
        } else if (string2.equals("high_level_annotation_qc")) {
            this._type = GoSubset.Type.HIGH_LEVEL_ANNOTATION_QC;
        } else if (string2.equals("unvetted")) {
            this._type = GoSubset.Type.UNVETTED;
        } else if (string2.equals("mf_needs_review")) {
            this._type = GoSubset.Type.MF_NEEDS_REVIEW;
        } else {
            throw new IllegalArgumentException("unknown GO subset type: " + string2);
        }
    }

    public BasicGoSubset(GoSubset.Type type) {
        this._type = type;
    }

    @Override
    public int compareTo(GoSubset goSubset) {
        return this.getType().compareTo(goSubset.getType());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check go subset equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check go subset equality to " + object + " [" + object.getClass() + "]");
        }
        return this.getType() == ((GoSubset)object).getType();
    }

    @Override
    public GoSubset.Type getType() {
        return this._type;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.getType()) {
            case GOSLIM_CANDIDA: {
                stringBuilder.append("goslim_candida");
                break;
            }
            case GOSLIM_GENERIC: {
                stringBuilder.append("goslim_generic");
                break;
            }
            case GOSLIM_GOA: {
                stringBuilder.append("goslim_goa");
                break;
            }
            case GOSLIM_PIR: {
                stringBuilder.append("goslim_pir");
                break;
            }
            case GOSLIM_PLANT: {
                stringBuilder.append("goslim_plant");
                break;
            }
            case GOSLIM_ASPERGILLUS: {
                stringBuilder.append("goslim_aspergillus");
                break;
            }
            case GOSLIM_YEAST: {
                stringBuilder.append("goslim_yeast");
                break;
            }
            case GOSUBSET_PROK: {
                stringBuilder.append("gosubset_prok");
                break;
            }
            case GOSLIM_POMBE: {
                stringBuilder.append("goslim_pombe");
                break;
            }
            case MF_NEEDS_REVIEW: {
                stringBuilder.append("mf_needs_review");
                break;
            }
            case HIGH_LEVEL_ANNOTATION_QC: {
                stringBuilder.append("high_level_annotation_qc");
                break;
            }
            case UNVETTED: {
                stringBuilder.append("unvetted");
                break;
            }
            default: {
                new AssertionError((Object)("unknown type: " + (Object)((Object)this.getType())));
            }
        }
        return stringBuilder.toString();
    }
}

