/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.writers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.forester.io.writers.PhyloXmlNodeWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.PhylogenyNodeI;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PostOrderStackObject;
import org.forester.util.ForesterUtil;

public final class PhylogenyWriter {
    public static final boolean INDENT_PHYLOXML_DEAFULT = true;
    public static final String PHYLO_XML_INTENDATION_BASE = "  ";
    public static final String PHYLO_XML_VERSION_ENCODING_LINE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String PHYLO_XML_NAMESPACE_LINE = "<phyloxml xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.phyloxml.org http://www.phyloxml.org/1.10/phyloxml.xsd\" xmlns=\"http://www.phyloxml.org\">";
    public static final String PHYLO_XML_END = "</phyloxml>";
    private boolean _saw_comma;
    private StringBuffer _buffer;
    private Writer _writer;
    private PhylogenyNode _root;
    private boolean _has_next;
    private Stack<PostOrderStackObject> _stack;
    private boolean _simple_nh;
    private boolean _nh_write_distance_to_parent;
    PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE _nh_conversion_support_style;
    private boolean _indent_phyloxml;
    private int _node_level;
    private int _phyloxml_level;
    private FORMAT _format;

    public PhylogenyWriter() {
        this.setIndentPhyloxml(true);
        this.setNhConversionSupportStyle(PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE.NONE);
    }

    private void appendPhylogenyLevelPhyloXml(Writer writer, Phylogeny phylogeny) throws IOException {
        String string = new String();
        if (!ForesterUtil.isEmpty(phylogeny.getName())) {
            PhylogenyDataUtil.appendElement(writer, "name", phylogeny.getName(), string);
        }
        if (phylogeny.getIdentifier() != null) {
            if (ForesterUtil.isEmpty(phylogeny.getIdentifier().getProvider())) {
                PhylogenyDataUtil.appendElement(writer, "id", phylogeny.getIdentifier().getValue(), string);
            }
            PhylogenyDataUtil.appendElement(writer, "id", phylogeny.getIdentifier().getValue(), "provider", phylogeny.getIdentifier().getProvider(), string);
        }
        if (!ForesterUtil.isEmpty(phylogeny.getDescription())) {
            PhylogenyDataUtil.appendElement(writer, "description", phylogeny.getDescription(), string);
        }
        if (phylogeny.getConfidence() != null) {
            if (ForesterUtil.isEmpty(phylogeny.getConfidence().getType())) {
                PhylogenyDataUtil.appendElement(writer, "confidence", phylogeny.getConfidence().getValue() + "", string);
            }
            PhylogenyDataUtil.appendElement(writer, "confidence", phylogeny.getConfidence().getValue() + "", "type", phylogeny.getConfidence().getType(), string);
        }
    }

    private StringBuffer createIndentation() {
        if (!this.isIndentPhyloxml()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.getNodeLevel() * 2);
        for (int i = 0; i < this.getNodeLevel(); ++i) {
            stringBuffer.append(PHYLO_XML_INTENDATION_BASE);
        }
        return stringBuffer;
    }

    private void decreaseNodeLevel() {
        --this._node_level;
    }

    private StringBuffer getBuffer() {
        return this._buffer;
    }

    private int getNodeLevel() {
        return this._node_level;
    }

    private StringBuffer getOutput(Phylogeny phylogeny) throws IOException {
        if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
            throw new RuntimeException("method inappropriately called");
        }
        if (phylogeny != null) {
            this.reset(phylogeny);
            while (this.isHasNext()) {
                this.next();
            }
            if (this.getOutputFormt() == FORMAT.NH) {
                this.getBuffer().append(';');
            }
            return this.getBuffer();
        }
        return new StringBuffer(0);
    }

    private FORMAT getOutputFormt() {
        return this._format;
    }

    private int getPhyloXmlLevel() {
        return this._phyloxml_level;
    }

    private PhylogenyNode getRoot() {
        return this._root;
    }

    private Stack<PostOrderStackObject> getStack() {
        return this._stack;
    }

    private Writer getWriter() {
        return this._writer;
    }

    private void increaseNodeLevel() {
        ++this._node_level;
    }

    private boolean isHasNext() {
        return this._has_next;
    }

    private boolean isIndentPhyloxml() {
        return this._indent_phyloxml;
    }

    private boolean isSawComma() {
        return this._saw_comma;
    }

    private boolean isSimpleNH() {
        return this._simple_nh;
    }

    private boolean isWriteDistanceToParentInNH() {
        return this._nh_write_distance_to_parent;
    }

    private void next() throws IOException {
        while (true) {
            PostOrderStackObject postOrderStackObject = this.getStack().pop();
            PhylogenyNode phylogenyNode = postOrderStackObject.getNode();
            int n = postOrderStackObject.getPhase();
            if (n > phylogenyNode.getNumberOfDescendants()) {
                this.setHasNext(phylogenyNode != this.getRoot());
                if (this.getOutputFormt() != FORMAT.PHYLO_XML || phylogenyNode.isExternal()) {
                    if (!phylogenyNode.isRoot() && phylogenyNode.isFirstChildNode()) {
                        this.increaseNodeLevel();
                    }
                    if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
                        this.writeNode(phylogenyNode, this.createIndentation());
                    } else {
                        this.writeNode(phylogenyNode, null);
                    }
                }
                if (!phylogenyNode.isRoot()) {
                    if (!phylogenyNode.isLastChildNode()) {
                        this.writeCladeSeparator();
                    } else {
                        this.writeCloseClade();
                    }
                }
                return;
            }
            this.getStack().push(new PostOrderStackObject(phylogenyNode, n + 1));
            if (!phylogenyNode.isInternal()) continue;
            this.getStack().push(new PostOrderStackObject(phylogenyNode.getChildNode(n - 1), 1));
            this.writeOpenClade(phylogenyNode);
            if (this.getOutputFormt() != FORMAT.PHYLO_XML || n != 1) continue;
            this.writeNode(phylogenyNode, this.createIndentation());
        }
    }

    private void reset(Phylogeny phylogeny) {
        this.setBuffer(new StringBuffer());
        this.setWriter(null);
        this.setSawComma(false);
        this.setHasNext(true);
        this.setRoot(phylogeny.getRoot());
        this.setStack(new Stack<PostOrderStackObject>());
        this.getStack().push(new PostOrderStackObject(phylogeny.getRoot(), 1));
        this.setNodeLevel(1);
    }

    private void reset(Writer writer, Phylogeny phylogeny) {
        this.setBuffer(null);
        this.setWriter(writer);
        this.setSawComma(false);
        this.setHasNext(true);
        this.setRoot(phylogeny.getRoot());
        this.setStack(new Stack<PostOrderStackObject>());
        this.getStack().push(new PostOrderStackObject(phylogeny.getRoot(), 1));
        this.setNodeLevel(1);
    }

    private void setBuffer(StringBuffer stringBuffer) {
        this._buffer = stringBuffer;
    }

    private void setHasNext(boolean bl) {
        this._has_next = bl;
    }

    public void setIndentPhyloxml(boolean bl) {
        this._indent_phyloxml = bl;
    }

    private void setNodeLevel(int n) {
        this._node_level = n;
    }

    private void setOutputFormt(FORMAT fORMAT) {
        this._format = fORMAT;
    }

    private void setPhyloXmlLevel(int n) {
        this._phyloxml_level = n;
    }

    private void setRoot(PhylogenyNode phylogenyNode) {
        this._root = phylogenyNode;
    }

    private void setSawComma(boolean bl) {
        this._saw_comma = bl;
    }

    private void setSimpleNH(boolean bl) {
        this._simple_nh = bl;
    }

    private void setStack(Stack<PostOrderStackObject> stack) {
        this._stack = stack;
    }

    private void setWriteDistanceToParentInNH(boolean bl) {
        this._nh_write_distance_to_parent = bl;
    }

    private void setWriter(Writer writer) {
        this._writer = writer;
    }

    public void toNewHampshire(List<Phylogeny> list, boolean bl, boolean bl2, File file, String string) throws IOException {
        Iterator<Phylogeny> iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append(this.toNewHampshire(iterator.next(), bl, bl2));
            stringBuffer.append(string);
        }
        this.writeToFile(stringBuffer, file);
    }

    public StringBuffer toNewHampshire(Phylogeny phylogeny, boolean bl, boolean bl2, PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE nH_CONVERSION_SUPPORT_VALUE_STYLE) throws IOException {
        this.setOutputFormt(FORMAT.NH);
        this.setNhConversionSupportStyle(nH_CONVERSION_SUPPORT_VALUE_STYLE);
        this.setSimpleNH(bl);
        this.setWriteDistanceToParentInNH(bl2);
        return this.getOutput(phylogeny);
    }

    public StringBuffer toNewHampshire(Phylogeny phylogeny, boolean bl, boolean bl2) throws IOException {
        this.setOutputFormt(FORMAT.NH);
        this.setSimpleNH(bl);
        this.setWriteDistanceToParentInNH(bl2);
        return this.getOutput(phylogeny);
    }

    public void toNewHampshire(Phylogeny phylogeny, boolean bl, boolean bl2, File file) throws IOException {
        this.writeToFile(this.toNewHampshire(phylogeny, bl, bl2), file);
    }

    public void toNewHampshire(Phylogeny phylogeny, boolean bl, boolean bl2, PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE nH_CONVERSION_SUPPORT_VALUE_STYLE, File file) throws IOException {
        this.writeToFile(this.toNewHampshire(phylogeny, bl, bl2, nH_CONVERSION_SUPPORT_VALUE_STYLE), file);
    }

    public void toNewHampshire(Phylogeny[] phylogenyArray, boolean bl, boolean bl2, File file, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (Phylogeny phylogeny : phylogenyArray) {
            stringBuffer.append(this.toNewHampshire(phylogeny, bl, bl2));
            stringBuffer.append(string);
        }
        this.writeToFile(stringBuffer, file);
    }

    public void toNewHampshireX(List<Phylogeny> list, File file, String string) throws IOException {
        Iterator<Phylogeny> iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append(this.toNewHampshireX(iterator.next()));
            stringBuffer.append(string);
        }
        this.writeToFile(stringBuffer, file);
    }

    public StringBuffer toNewHampshireX(Phylogeny phylogeny) throws IOException {
        this.setOutputFormt(FORMAT.NHX);
        return this.getOutput(phylogeny);
    }

    public void toNewHampshireX(Phylogeny phylogeny, File file) throws IOException {
        this.writeToFile(this.toNewHampshireX(phylogeny), file);
    }

    public void toNewHampshireX(Phylogeny[] phylogenyArray, File file, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (Phylogeny phylogeny : phylogenyArray) {
            stringBuffer.append(this.toNewHampshireX(phylogeny));
            stringBuffer.append(string);
        }
        this.writeToFile(stringBuffer, file);
    }

    public void toNexus(File file, Phylogeny phylogeny, PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE nH_CONVERSION_SUPPORT_VALUE_STYLE) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new PrintWriter(file));
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>(1);
        arrayList.add(phylogeny);
        PhylogenyWriter.writeNexusStart(bufferedWriter);
        PhylogenyWriter.writeNexusTaxaBlock(bufferedWriter, phylogeny);
        PhylogenyWriter.writeNexusTreesBlock(bufferedWriter, arrayList, nH_CONVERSION_SUPPORT_VALUE_STYLE);
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
    }

    public StringBuffer toNexus(Phylogeny phylogeny, PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE nH_CONVERSION_SUPPORT_VALUE_STYLE) throws IOException {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>(1);
        arrayList.add(phylogeny);
        PhylogenyWriter.writeNexusStart(bufferedWriter);
        PhylogenyWriter.writeNexusTaxaBlock(bufferedWriter, phylogeny);
        PhylogenyWriter.writeNexusTreesBlock(bufferedWriter, arrayList, nH_CONVERSION_SUPPORT_VALUE_STYLE);
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
        return stringWriter.getBuffer();
    }

    public void toPhyloXML(File file, List<Phylogeny> list, int n, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new PrintWriter(file));
        this.toPhyloXML((Writer)bufferedWriter, list, n, string);
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
    }

    public void toPhyloXML(File file, Phylogeny phylogeny, int n) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new PrintWriter(file));
        PhylogenyWriter.writePhyloXmlStart(bufferedWriter);
        this.toPhyloXMLNoPhyloXmlSource(bufferedWriter, phylogeny, n);
        PhylogenyWriter.writePhyloXmlEnd(bufferedWriter);
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
    }

    public StringBuffer toPhyloXML(Phylogeny phylogeny, int n) throws IOException {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        this.setPhyloXmlLevel(n);
        this.setOutputFormt(FORMAT.PHYLO_XML);
        PhylogenyWriter.writePhyloXmlStart(bufferedWriter);
        this.writeOutput(bufferedWriter, phylogeny);
        PhylogenyWriter.writePhyloXmlEnd(bufferedWriter);
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
        return stringWriter.getBuffer();
    }

    public void toPhyloXML(Phylogeny[] phylogenyArray, int n, File file, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new PrintWriter(file));
        this.toPhyloXML((Writer)bufferedWriter, phylogenyArray, n, string);
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
    }

    public void toPhyloXML(Phylogeny phylogeny, int n, File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new PrintWriter(file));
        this.toPhyloXML(bufferedWriter, phylogeny, n);
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
    }

    public void toPhyloXML(Writer writer, List<Phylogeny> list, int n, String string) throws IOException {
        PhylogenyWriter.writePhyloXmlStart(writer);
        Iterator<Phylogeny> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.toPhyloXMLNoPhyloXmlSource(writer, iterator.next(), n);
            writer.write(string);
        }
        PhylogenyWriter.writePhyloXmlEnd(writer);
    }

    public void toPhyloXML(Writer writer, Phylogeny phylogeny, int n) throws IOException {
        this.setPhyloXmlLevel(n);
        this.setOutputFormt(FORMAT.PHYLO_XML);
        PhylogenyWriter.writePhyloXmlStart(writer);
        this.writeOutput(writer, phylogeny);
        PhylogenyWriter.writePhyloXmlEnd(writer);
    }

    public void toPhyloXML(Writer writer, Phylogeny[] phylogenyArray, int n, String string) throws IOException {
        PhylogenyWriter.writePhyloXmlStart(writer);
        for (Phylogeny phylogeny : phylogenyArray) {
            this.toPhyloXMLNoPhyloXmlSource(writer, phylogeny, n);
            writer.write(string);
        }
        PhylogenyWriter.writePhyloXmlEnd(writer);
    }

    private void toPhyloXMLNoPhyloXmlSource(Writer writer, Phylogeny phylogeny, int n) throws IOException {
        this.setPhyloXmlLevel(n);
        this.setOutputFormt(FORMAT.PHYLO_XML);
        this.writeOutput(writer, phylogeny);
    }

    private void writeCladeSeparator() {
        this.setSawComma(true);
        if (this.getOutputFormt() == FORMAT.NHX || this.getOutputFormt() == FORMAT.NH) {
            this.getBuffer().append(",");
        }
    }

    private void writeCloseClade() throws IOException {
        this.decreaseNodeLevel();
        if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
            this.getWriter().write(ForesterUtil.LINE_SEPARATOR);
            if (this.isIndentPhyloxml()) {
                this.getWriter().write(this.createIndentation().toString());
            }
            PhylogenyDataUtil.appendClose(this.getWriter(), "clade");
        } else if (this.getOutputFormt() == FORMAT.NHX || this.getOutputFormt() == FORMAT.NH) {
            this.getBuffer().append(")");
        }
    }

    private void writeNode(PhylogenyNode phylogenyNode, StringBuffer stringBuffer) throws IOException {
        if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
            if (phylogenyNode.isExternal()) {
                this.getWriter().write(ForesterUtil.LINE_SEPARATOR);
                if (stringBuffer != null) {
                    this.getWriter().write(stringBuffer.toString());
                }
                PhylogenyDataUtil.appendOpen(this.getWriter(), "clade");
            }
            PhyloXmlNodeWriter.toPhyloXml(this.getWriter(), phylogenyNode, this.getPhyloXmlLevel(), stringBuffer != null ? stringBuffer.toString() : "");
            if (phylogenyNode.isExternal()) {
                this.getWriter().write(ForesterUtil.LINE_SEPARATOR);
                if (stringBuffer != null) {
                    this.getWriter().write(stringBuffer.toString());
                }
                PhylogenyDataUtil.appendClose(this.getWriter(), "clade");
            }
        } else if (this.getOutputFormt() == FORMAT.NHX) {
            this.getBuffer().append(phylogenyNode.toNewHampshireX());
        } else if (this.getOutputFormt() == FORMAT.NH) {
            this.getBuffer().append(phylogenyNode.toNewHampshire(this.isSimpleNH(), this.isWriteDistanceToParentInNH(), this.getNhConversionSupportStyle()));
        }
    }

    private PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE getNhConversionSupportStyle() {
        return this._nh_conversion_support_style;
    }

    private void setNhConversionSupportStyle(PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE nH_CONVERSION_SUPPORT_VALUE_STYLE) {
        this._nh_conversion_support_style = nH_CONVERSION_SUPPORT_VALUE_STYLE;
    }

    private void writeOpenClade(PhylogenyNode phylogenyNode) throws IOException {
        if (!this.isSawComma()) {
            if (!phylogenyNode.isRoot() && phylogenyNode.isFirstChildNode()) {
                this.increaseNodeLevel();
            }
            if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
                this.getWriter().write(ForesterUtil.LINE_SEPARATOR);
                if (this.isIndentPhyloxml()) {
                    this.getWriter().write(this.createIndentation().toString());
                }
                if (phylogenyNode.isCollapse()) {
                    PhylogenyDataUtil.appendOpen(this.getWriter(), "clade", "collapse", "true");
                } else {
                    PhylogenyDataUtil.appendOpen(this.getWriter(), "clade");
                }
            } else if (this.getOutputFormt() == FORMAT.NHX || this.getOutputFormt() == FORMAT.NH) {
                this.getBuffer().append("(");
            }
        }
        this.setSawComma(false);
    }

    private void writeOutput(Writer writer, Phylogeny phylogeny) throws IOException {
        if (this.getOutputFormt() != FORMAT.PHYLO_XML) {
            throw new RuntimeException("method inappropriately called");
        }
        if (phylogeny != null) {
            this.reset(writer, phylogeny);
            boolean bl = true;
            String string = "";
            String string2 = "";
            String string3 = "false";
            if (phylogeny.isRooted()) {
                string3 = "true";
            }
            if (!phylogeny.isRerootable()) {
                bl = false;
            }
            if (!ForesterUtil.isEmpty(phylogeny.getDistanceUnit())) {
                string = phylogeny.getDistanceUnit();
            }
            if (!ForesterUtil.isEmpty(phylogeny.getType())) {
                string2 = phylogeny.getType();
            }
            if (bl) {
                PhylogenyDataUtil.appendOpen(writer, "phylogeny", "rooted", string3, "branch_length_unit", string, "type", string2);
            } else {
                PhylogenyDataUtil.appendOpen(writer, "phylogeny", "rooted", string3, "branch_length_unit", string, "type", string2, "rerootable", "false");
            }
            this.appendPhylogenyLevelPhyloXml(writer, phylogeny);
            while (this.isHasNext()) {
                this.next();
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
            PhylogenyDataUtil.appendClose(writer, "phylogeny");
        }
    }

    private void writeToFile(StringBuffer stringBuffer, File file) throws IOException {
        if (file.exists()) {
            throw new IOException("attempt to overwrite existing file \"" + file.getAbsolutePath() + "\"");
        }
        PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
            printWriter.print(PHYLO_XML_VERSION_ENCODING_LINE);
            printWriter.print(ForesterUtil.LINE_SEPARATOR);
            printWriter.print(PHYLO_XML_NAMESPACE_LINE);
            printWriter.print(ForesterUtil.LINE_SEPARATOR);
        }
        printWriter.print(stringBuffer);
        if (this.getOutputFormt() == FORMAT.PHYLO_XML) {
            printWriter.print(ForesterUtil.LINE_SEPARATOR);
            printWriter.print(PHYLO_XML_END);
        }
        printWriter.flush();
        printWriter.close();
    }

    public static PhylogenyWriter createPhylogenyWriter() {
        return new PhylogenyWriter();
    }

    private static void writeNexusStart(Writer writer) throws IOException {
        writer.write("#NEXUS");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    public static void writeNexusTaxaBlock(Writer writer, Phylogeny phylogeny) throws IOException {
        writer.write("Begin Taxa;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(" ");
        writer.write("Dimensions");
        writer.write(" ");
        writer.write("NTax");
        writer.write("=");
        writer.write(String.valueOf(phylogeny.getNumberOfExternalNodes()));
        writer.write(";");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(" ");
        writer.write("TaxLabels");
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            writer.write(" ");
            String string = "";
            if (!ForesterUtil.isEmpty(phylogenyNode.getName())) {
                string = phylogenyNode.getName();
            } else if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode())) {
                    string = phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode();
                } else if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName())) {
                    string = phylogenyNode.getNodeData().getTaxonomy().getScientificName();
                } else if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getCommonName())) {
                    string = phylogenyNode.getNodeData().getTaxonomy().getCommonName();
                } else if (phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode() != null) {
                    string = phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode();
                }
            } else if (phylogenyNode.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName())) {
                string = phylogenyNode.getNodeData().getSequence().getName();
            }
            if (string.length() > 0) {
                string = string.replaceAll(" ", "_");
            }
            writer.write(string);
        }
        writer.write(";");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("End;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    public static void writeNexusTreesBlock(Writer writer, List<Phylogeny> list, PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE nH_CONVERSION_SUPPORT_VALUE_STYLE) throws IOException {
        writer.write("Begin Trees;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        int n = 1;
        for (Phylogeny phylogeny : list) {
            writer.write(" ");
            writer.write("Tree");
            writer.write(" ");
            if (!ForesterUtil.isEmpty(phylogeny.getName())) {
                writer.write("'");
                writer.write(phylogeny.getName());
                writer.write("'");
            } else {
                writer.write("tree");
                writer.write(String.valueOf(n));
            }
            writer.write("=");
            if (phylogeny.isRooted()) {
                writer.write("[&R]");
            } else {
                writer.write("[&U]");
            }
            writer.write(phylogeny.toNewHampshire(false, nH_CONVERSION_SUPPORT_VALUE_STYLE));
            writer.write(ForesterUtil.LINE_SEPARATOR);
            ++n;
        }
        writer.write("End;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    private static void writePhyloXmlEnd(Writer writer) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(PHYLO_XML_END);
    }

    private static void writePhyloXmlStart(Writer writer) throws IOException {
        writer.write(PHYLO_XML_VERSION_ENCODING_LINE);
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(PHYLO_XML_NAMESPACE_LINE);
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    public static enum FORMAT {
        NH,
        NHX,
        PHYLO_XML,
        NEXUS;

    }
}

