/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.writers;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.Sequence;
import org.forester.util.ForesterUtil;

public class SequenceWriter {
    public static void main(String[] stringArray) {
        Sequence sequence = BasicSequence.createAaSequence("name", "abcdefghiiklmnap");
        System.out.println(sequence.toString());
        System.out.println(SequenceWriter.toFasta(sequence, 0).toString());
        System.out.println(SequenceWriter.toFasta(sequence, 5).toString());
        System.out.println(SequenceWriter.toFasta(sequence, 8).toString());
        System.out.println(SequenceWriter.toFasta(sequence, 4).toString());
        System.out.println(SequenceWriter.toFasta(sequence, 3).toString());
        System.out.println(SequenceWriter.toFasta(sequence, 2).toString());
        System.out.println(SequenceWriter.toFasta(sequence, 1).toString());
        System.out.println(SequenceWriter.toFasta(sequence, 100).toString());
        System.out.println(SequenceWriter.toFasta(sequence, 15).toString());
        System.out.println(SequenceWriter.toFasta(sequence, 16).toString());
    }

    public static StringBuilder toFasta(Sequence sequence, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(">");
        stringBuilder.append(sequence.getIdentifier().toString());
        stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        if (n < 1 || n >= sequence.getLength()) {
            stringBuilder.append(sequence.getMolecularSequence());
        } else {
            int n2 = sequence.getLength() / n;
            int n3 = sequence.getLength() - n2 * n;
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(sequence.getMolecularSequence(), i * n, n);
                if (i >= n2 - 1) continue;
                stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            }
            if (n3 > 0) {
                stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
                stringBuilder.append(sequence.getMolecularSequence(), n2 * n, n3);
            }
        }
        return stringBuilder;
    }

    public static void toFasta(Sequence sequence, Writer writer, int n) throws IOException {
        writer.write(">");
        writer.write(sequence.getIdentifier().toString());
        writer.write(ForesterUtil.LINE_SEPARATOR);
        if (n < 1 || n >= sequence.getLength()) {
            writer.write(sequence.getMolecularSequence());
        } else {
            int n2 = sequence.getLength() / n;
            int n3 = sequence.getLength() - n2 * n;
            for (int i = 0; i < n2; ++i) {
                writer.write(sequence.getMolecularSequence(), i * n, n);
                if (i >= n2 - 1) continue;
                writer.write(ForesterUtil.LINE_SEPARATOR);
            }
            if (n3 > 0) {
                writer.write(ForesterUtil.LINE_SEPARATOR);
                writer.write(sequence.getMolecularSequence(), n2 * n, n3);
            }
        }
    }

    public static void writeSeqs(List<Sequence> list, Writer writer, SEQ_FORMAT sEQ_FORMAT, int n) throws IOException {
        switch (sEQ_FORMAT) {
            case FASTA: {
                for (Sequence sequence : list) {
                    SequenceWriter.toFasta(sequence, writer, n);
                    writer.write(ForesterUtil.LINE_SEPARATOR);
                }
                break;
            }
            default: {
                throw new RuntimeException("unknown format " + (Object)((Object)sEQ_FORMAT));
            }
        }
    }

    public static enum SEQ_FORMAT {
        FASTA;

    }
}

