/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.protein.BinaryDomainCombination;
import org.forester.protein.DomainId;
import org.forester.species.Species;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.CombinableDomains;
import org.forester.util.DescriptiveStatistics;

public class BasicCombinableDomains
implements CombinableDomains {
    private final DomainId _key_domain;
    private int _key_domain_count;
    private int _key_domain_proteins_count;
    private final Species _species;
    private final TreeMap<DomainId, Integer> _combining_domains;
    private DescriptiveStatistics _key_domain_confidence_statistics;

    public BasicCombinableDomains(DomainId domainId, Species species) {
        this._key_domain = domainId;
        this._species = species;
        this._combining_domains = new TreeMap();
        this.init();
    }

    @Override
    public void addCombinableDomain(DomainId domainId) {
        if (this.getCombiningDomains().containsKey(domainId)) {
            this.getCombiningDomains().put(domainId, this.getCombiningDomains().get(domainId) + 1);
        } else {
            this.getCombiningDomains().put(domainId, 1);
        }
    }

    @Override
    public List<DomainId> getAllDomains() {
        List<DomainId> list = this.getCombinableDomains();
        if (!list.contains(this.getKeyDomain())) {
            list.add(this.getKeyDomain());
        }
        return list;
    }

    @Override
    public List<DomainId> getCombinableDomains() {
        ArrayList<DomainId> arrayList = new ArrayList<DomainId>(this.getNumberOfCombinableDomains());
        for (DomainId domainId : this.getCombiningDomains().keySet()) {
            arrayList.add(domainId);
        }
        return arrayList;
    }

    @Override
    public SortedMap<DomainId, Integer> getCombinableDomainsIds() {
        TreeMap<DomainId, Integer> treeMap = new TreeMap<DomainId, Integer>();
        Iterator<DomainId> iterator = this.getCombiningDomains().keySet().iterator();
        while (iterator.hasNext()) {
            DomainId domainId;
            DomainId domainId2 = domainId = iterator.next();
            treeMap.put(domainId2, this.getCombiningDomains().get(domainId2));
        }
        return treeMap;
    }

    @Override
    public StringBuilder getCombiningDomainIdsAsStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<DomainId> iterator = this.getCombiningDomains().keySet().iterator();
        while (iterator.hasNext()) {
            DomainId domainId = iterator.next();
            stringBuilder.append(domainId.toString());
            stringBuilder.append(" [");
            int n = this.getCombiningDomains().get(domainId);
            stringBuilder.append(n);
            stringBuilder.append("]");
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder;
    }

    protected TreeMap<DomainId, Integer> getCombiningDomains() {
        return this._combining_domains;
    }

    @Override
    public DomainId getKeyDomain() {
        return this._key_domain;
    }

    @Override
    public DescriptiveStatistics getKeyDomainConfidenceDescriptiveStatistics() {
        return this._key_domain_confidence_statistics;
    }

    @Override
    public int getKeyDomainCount() {
        return this._key_domain_count;
    }

    @Override
    public int getKeyDomainProteinsCount() {
        return this._key_domain_proteins_count;
    }

    @Override
    public int getNumberOfCombinableDomains() {
        return this._combining_domains.size();
    }

    @Override
    public int getNumberOfProteinsExhibitingCombination(DomainId domainId) {
        if (this.getCombiningDomains().containsKey(domainId)) {
            return this.getCombiningDomains().get(domainId);
        }
        return 0;
    }

    @Override
    public Species getSpecies() {
        return this._species;
    }

    private void init() {
        this._key_domain_count = 0;
        this._key_domain_proteins_count = 0;
        this._key_domain_confidence_statistics = null;
    }

    @Override
    public boolean isCombinable(DomainId domainId) {
        return this.getCombiningDomains().containsKey(domainId);
    }

    @Override
    public void setKeyDomainConfidenceDescriptiveStatistics(DescriptiveStatistics descriptiveStatistics) {
        this._key_domain_confidence_statistics = descriptiveStatistics;
    }

    @Override
    public void setKeyDomainCount(int n) {
        this._key_domain_count = n;
    }

    @Override
    public void setKeyDomainProteinsCount(int n) {
        this._key_domain_proteins_count = n;
    }

    @Override
    public List<BinaryDomainCombination> toBinaryDomainCombinations() {
        ArrayList<BinaryDomainCombination> arrayList = new ArrayList<BinaryDomainCombination>(this.getNumberOfCombinableDomains());
        for (DomainId domainId : this.getCombiningDomains().keySet()) {
            arrayList.add(new BasicBinaryDomainCombination(this.getKeyDomain(), domainId));
        }
        return arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getKeyDomain());
        stringBuilder.append(" [");
        stringBuilder.append(this.getKeyDomainCount());
        stringBuilder.append(", ");
        stringBuilder.append(this.getKeyDomainProteinsCount());
        stringBuilder.append(", ");
        stringBuilder.append(this.getNumberOfCombinableDomains());
        stringBuilder.append("]: ");
        stringBuilder.append((CharSequence)this.getCombiningDomainIdsAsStringBuilder());
        return stringBuilder.toString();
    }
}

