/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.ForesterUtil;

public final class PhylogenyDecorator {
    private static final String TP_TAXONOMY_CODE = "TAXONOMY_CODE";
    private static final String TP_TAXONOMY_ID = "TAXONOMY_ID";
    private static final String TP_TAXONOMY_ID_PROVIDER = "TAXONOMY_ID_PROVIDER";
    private static final String TP_TAXONOMY_SN = "TAXONOMY_SN";
    private static final String TP_TAXONOMY_CN = "TAXONOMY_CN";
    private static final String TP_TAXONOMY_SYN = "TAXONOMY_SYN";
    private static final String TP_SEQ_SYMBOL = "SEQ_SYMBOL";
    private static final String TP_SEQ_ACCESSION = "SEQ_ACCESSION";
    private static final String TP_SEQ_ACCESSION_SOURCE = "SEQ_ACCESSION_SOURCE";
    private static final String TP_SEQ_ANNOTATION_DESC = "SEQ_ANNOTATION_DESC";
    private static final String TP_SEQ_ANNOTATION_REF = "SEQ_ANNOTATION_REF";
    private static final String TP_SEQ_MOL_SEQ = "SEQ_MOL_SEQ";
    private static final String TP_SEQ_NAME = "SEQ_NAME";
    private static final String TP_NODE_NAME = "NODE_NAME";
    private static final Pattern NODENAME_SEQNUMBER_TAXDOMAINNUMBER = Pattern.compile("^([a-fA-Z0-9]{1,5})_([A-Z0-9]{2,4}[A-Z])(\\d{1,4})$");
    public static final boolean SANITIZE = false;
    public static final boolean VERBOSE = true;

    private PhylogenyDecorator() {
    }

    public static void decorate(Phylogeny phylogeny, Map<String, Map<String, String>> map, boolean bl, int n) throws IllegalArgumentException, PhyloXmlDataFormatException {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            String string = phylogenyNode.getName();
            if (ForesterUtil.isEmpty(string)) continue;
            if (map.containsKey(string) || n > 0) {
                Annotation annotation;
                Map<String, String> map2 = map.get(string);
                for (int i = 0; map2 == null && n > 0 && i <= n; ++i) {
                    map2 = map.get(string.substring(0, string.length() - i));
                }
                if (map2 == null) continue;
                if (map2.containsKey(TP_TAXONOMY_CODE)) {
                    AptxUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                    phylogenyNode.getNodeData().getTaxonomy().setTaxonomyCode(map2.get(TP_TAXONOMY_CODE));
                }
                if (map2.containsKey(TP_TAXONOMY_ID) && map2.containsKey(TP_TAXONOMY_ID_PROVIDER)) {
                    AptxUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                    phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(map2.get(TP_TAXONOMY_ID), map2.get(TP_TAXONOMY_ID_PROVIDER)));
                } else if (map2.containsKey(TP_TAXONOMY_ID)) {
                    AptxUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                    phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(map2.get(TP_TAXONOMY_ID)));
                }
                if (map2.containsKey(TP_TAXONOMY_SN)) {
                    AptxUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                    phylogenyNode.getNodeData().getTaxonomy().setScientificName(map2.get(TP_TAXONOMY_SN));
                }
                if (map2.containsKey(TP_TAXONOMY_CN)) {
                    AptxUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                    phylogenyNode.getNodeData().getTaxonomy().setCommonName(map2.get(TP_TAXONOMY_CN));
                }
                if (map2.containsKey(TP_TAXONOMY_SYN)) {
                    AptxUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                    phylogenyNode.getNodeData().getTaxonomy().getSynonyms().add(map2.get(TP_TAXONOMY_SYN));
                }
                if (map2.containsKey(TP_SEQ_ACCESSION) && map2.containsKey(TP_SEQ_ACCESSION_SOURCE)) {
                    AptxUtil.ensurePresenceOfSequence(phylogenyNode);
                    phylogenyNode.getNodeData().getSequence().setAccession(new Accession(map2.get(TP_SEQ_ACCESSION), map2.get(TP_SEQ_ACCESSION_SOURCE)));
                }
                if (map2.containsKey(TP_SEQ_ANNOTATION_DESC)) {
                    AptxUtil.ensurePresenceOfSequence(phylogenyNode);
                    annotation = new Annotation("?");
                    annotation.setDesc(map2.get(TP_SEQ_ANNOTATION_DESC));
                    phylogenyNode.getNodeData().getSequence().addAnnotation(annotation);
                }
                if (map2.containsKey(TP_SEQ_ANNOTATION_REF)) {
                    AptxUtil.ensurePresenceOfSequence(phylogenyNode);
                    annotation = new Annotation(map2.get(TP_SEQ_ANNOTATION_REF));
                    phylogenyNode.getNodeData().getSequence().addAnnotation(annotation);
                }
                if (map2.containsKey(TP_SEQ_SYMBOL)) {
                    AptxUtil.ensurePresenceOfSequence(phylogenyNode);
                    phylogenyNode.getNodeData().getSequence().setSymbol(map2.get(TP_SEQ_SYMBOL));
                }
                if (map2.containsKey(TP_SEQ_NAME)) {
                    AptxUtil.ensurePresenceOfSequence(phylogenyNode);
                    phylogenyNode.getNodeData().getSequence().setName(map2.get(TP_SEQ_NAME));
                }
                if (map2.containsKey(TP_SEQ_MOL_SEQ)) {
                    AptxUtil.ensurePresenceOfSequence(phylogenyNode);
                    phylogenyNode.getNodeData().getSequence().setMolecularSequence(map2.get(TP_SEQ_MOL_SEQ));
                }
                if (!map2.containsKey(TP_NODE_NAME)) continue;
                phylogenyNode.setName(map2.get(TP_NODE_NAME));
                continue;
            }
            if (!bl) continue;
            throw new IllegalArgumentException("\"" + string + "\" not found in name map");
        }
    }

    public static void decorate(Phylogeny phylogeny, Map<String, String> map, FIELD fIELD, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, boolean bl6) throws IllegalArgumentException, NHXFormatException, PhyloXmlDataFormatException {
        PhylogenyDecorator.decorate(phylogeny, map, fIELD, bl, bl2, null, bl3, bl4, bl5, n, bl6);
    }

    public static void decorate(Phylogeny phylogeny, Map<String, String> map, FIELD fIELD, boolean bl, boolean bl2, Map<String, String> map2, boolean bl3, boolean bl4, boolean bl5, int n, boolean bl6) throws IllegalArgumentException, PhyloXmlDataFormatException {
        if (bl && fIELD == FIELD.TAXONOMY_SCIENTIFIC_NAME) {
            throw new IllegalArgumentException("Attempt to extract bracketed scientific name together with data field pointing to scientific name");
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            String string = phylogenyNode.getName();
            if (ForesterUtil.isEmpty(string)) continue;
            if (map2 != null) {
                string = PhylogenyDecorator.extractIntermediate(map2, string);
            }
            if (map.containsKey(string) || n > 0) {
                String string2 = map.get(string);
                for (int i = 0; string2 == null && n > 0 && i <= n; ++i) {
                    string2 = map.get(string.substring(0, string.length() - i));
                }
                if (string2 == null) continue;
                string2 = string2.trim();
                string2.replaceAll("/\\s+/", " ");
                if (bl && string2.endsWith("]")) {
                    PhylogenyDecorator.extractBracketedScientificNames(phylogenyNode, string2);
                }
                switch (fIELD) {
                    case SEQUENCE_ANNOTATION_DESC: {
                        System.out.println(string + ": " + string2);
                        if (!phylogenyNode.getNodeData().isHasSequence()) {
                            phylogenyNode.getNodeData().setSequence(new Sequence());
                        }
                        Annotation annotation = new Annotation("?");
                        annotation.setDesc(string2);
                        phylogenyNode.getNodeData().getSequence().addAnnotation(annotation);
                        break;
                    }
                    case DOMAIN_STRUCTURE: {
                        System.out.println(string + ": " + string2);
                        if (!phylogenyNode.getNodeData().isHasSequence()) {
                            phylogenyNode.getNodeData().setSequence(new Sequence());
                        }
                        phylogenyNode.getNodeData().getSequence().setDomainArchitecture(new DomainArchitecture(string2));
                        break;
                    }
                    case TAXONOMY_CODE: {
                        System.out.println(string + ": " + string2);
                        AptxUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                        phylogenyNode.getNodeData().getTaxonomy().setTaxonomyCode(string2);
                        break;
                    }
                    case TAXONOMY_SCIENTIFIC_NAME: {
                        System.out.println(string + ": " + string2);
                        AptxUtil.ensurePresenceOfTaxonomy(phylogenyNode);
                        phylogenyNode.getNodeData().getTaxonomy().setScientificName(string2);
                        break;
                    }
                    case SEQUENCE_NAME: {
                        System.out.println(string + ": " + string2);
                        if (!phylogenyNode.getNodeData().isHasSequence()) {
                            phylogenyNode.getNodeData().setSequence(new Sequence());
                        }
                        phylogenyNode.getNodeData().getSequence().setName(string2);
                        break;
                    }
                    case NODE_NAME: {
                        System.out.print(string + " -> ");
                        if (bl3) {
                            System.out.print(string2 + " -> ");
                            string2 = PhylogenyDecorator.deleteAtFirstSpace(string2);
                        } else if (bl4) {
                            System.out.print(string2 + " -> ");
                            string2 = PhylogenyDecorator.processNameIntelligently(string2);
                        } else if (bl5) {
                            System.out.print(string2 + " -> ");
                            string2 = PhylogenyDecorator.processSimilarTo(string2);
                        }
                        System.out.println(string2);
                        phylogenyNode.setName(string2);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unknown field \"" + (Object)((Object)fIELD) + "\"");
                    }
                }
                if (!bl6 || fIELD == FIELD.NODE_NAME) continue;
                phylogenyNode.setName(PhylogenyDecorator.moveDomainNumbersAtEnd(phylogenyNode.getName()));
                continue;
            }
            if (!bl2) continue;
            throw new IllegalArgumentException("\"" + string + "\" not found in name map");
        }
    }

    public static void decorate(Phylogeny[] phylogenyArray, Map<String, Map<String, String>> map, boolean bl, int n) throws IllegalArgumentException, NHXFormatException, PhyloXmlDataFormatException {
        for (int i = 0; i < phylogenyArray.length; ++i) {
            PhylogenyDecorator.decorate(phylogenyArray[i], map, bl, n);
        }
    }

    public static void decorate(Phylogeny[] phylogenyArray, Map<String, String> map, FIELD fIELD, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, boolean bl6) throws IllegalArgumentException, NHXFormatException, PhyloXmlDataFormatException {
        for (int i = 0; i < phylogenyArray.length; ++i) {
            PhylogenyDecorator.decorate(phylogenyArray[i], map, fIELD, bl, bl2, bl3, bl4, bl5, n, bl6);
        }
    }

    public static void decorate(Phylogeny[] phylogenyArray, Map<String, String> map, FIELD fIELD, boolean bl, boolean bl2, Map<String, String> map2, boolean bl3, boolean bl4, boolean bl5, int n, boolean bl6) throws IllegalArgumentException, NHXFormatException, PhyloXmlDataFormatException {
        for (int i = 0; i < phylogenyArray.length; ++i) {
            PhylogenyDecorator.decorate(phylogenyArray[i], map, fIELD, bl, bl2, map2, bl3, bl4, bl5, n, bl6);
        }
    }

    private static String deleteAtFirstSpace(String string) {
        int n = string.indexOf(" ");
        if (n > 1) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    private static void extractBracketedScientificNames(PhylogenyNode phylogenyNode, String string) {
        int n = string.lastIndexOf("[");
        String string2 = string.substring(n + 1, string.length() - 1);
        AptxUtil.ensurePresenceOfTaxonomy(phylogenyNode);
        phylogenyNode.getNodeData().getTaxonomy().setScientificName(string2);
    }

    private static String extractIntermediate(Map<String, String> map, String string) {
        String string2 = null;
        System.out.print(string + " => ");
        if (map.containsKey(string)) {
            string2 = map.get(string);
            if (ForesterUtil.isEmpty(string2)) {
                throw new IllegalArgumentException("\"" + string + "\" maps to null or empty string in secondary map");
            }
        } else {
            throw new IllegalArgumentException("\"" + string + "\" not found in name secondary map");
        }
        System.out.println(string2 + "  ");
        return string2;
    }

    private static String moveDomainNumbersAtEnd(String string) {
        Matcher matcher = NODENAME_SEQNUMBER_TAXDOMAINNUMBER.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            return string2 + "_[" + string4 + "]_" + string3;
        }
        return string;
    }

    public static Map<String, Map<String, String>> parseMappingTable(File file) throws IOException {
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        BasicTable<String> basicTable = null;
        basicTable = BasicTableParser.parse(file, "\t", false);
        for (int i = 0; i < basicTable.getNumberOfRows(); ++i) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            String string = null;
            for (int j = 0; j < basicTable.getNumberOfColumns(); ++j) {
                String string2 = basicTable.getValue(j, i);
                if (j == 0) {
                    string = string2;
                    continue;
                }
                if (string2 == null) continue;
                String string3 = string2.substring(0, string2.indexOf(58));
                String string4 = string2.substring(string2.indexOf(58) + 1, string2.length());
                hashMap2.put(string3, string4);
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    private static String processNameIntelligently(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length < 2) {
            return string;
        }
        if (stringArray[0].indexOf("_") > 0 && stringArray[0].indexOf("|") > 0) {
            return stringArray[0];
        }
        if (stringArray[1].indexOf("_") > 0 && stringArray[1].indexOf("|") > 0) {
            return stringArray[1];
        }
        if (stringArray[0].indexOf("_") > 0 && stringArray[0].indexOf(".") > 0) {
            return stringArray[0];
        }
        if (stringArray[1].indexOf("_") > 0 && stringArray[1].indexOf(".") > 0) {
            return stringArray[1];
        }
        if (stringArray[0].indexOf("_") > 0) {
            return stringArray[0];
        }
        if (stringArray[1].indexOf("_") > 0) {
            return stringArray[1];
        }
        return stringArray[0];
    }

    private static String processSimilarTo(String string) {
        int n = string.toLowerCase().indexOf("similar to");
        String string2 = "";
        if (n >= 0) {
            string2 = " similarity=" + string.substring(n + 10).trim();
        }
        String string3 = PhylogenyDecorator.processNameIntelligently(string);
        return string3 + string2;
    }

    private static String sanitize(String string) {
        string = string.replace(' ', '_');
        string = string.replace('(', '{');
        string = string.replace(')', '}');
        string = string.replace('[', '{');
        string = string.replace(']', '}');
        string = string.replace(',', '_');
        return string;
    }

    public static enum FIELD {
        NODE_NAME,
        SEQUENCE_ANNOTATION_DESC,
        DOMAIN_STRUCTURE,
        TAXONOMY_CODE,
        TAXONOMY_SCIENTIFIC_NAME,
        SEQUENCE_NAME;

    }
}

