/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.forester.util.ForesterUtil;

public class BasicTable<E> {
    private Map<String, Map<String, E>> _rows;
    private int _max_row;
    private int _max_col;

    public BasicTable() {
        this.init();
    }

    public Map<String, E> getColumnsAsMap(int n, int n2) throws IllegalArgumentException {
        HashMap<String, E> hashMap = new HashMap<String, E>();
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            String string = (String)this.getValue(n, i);
            E e = this.getValue(n2, i);
            if (string == null || e == null) continue;
            if (hashMap.containsKey(string)) {
                throw new IllegalArgumentException("attempt to use non-unique table value as key [" + string + "]");
            }
            hashMap.put(string, e);
        }
        return hashMap;
    }

    public Map<String, Double> getColumnsAsMapDouble(int n, int n2) throws IllegalArgumentException, IOException {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            String string = (String)this.getValue(n, i);
            double d = 0.0;
            try {
                d = Double.parseDouble(this.getValueAsString(n2, i));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException);
            }
            if (string == null) continue;
            if (hashMap.containsKey(string)) {
                throw new IllegalArgumentException("attempt to use non-unique table value as key [" + string + "]");
            }
            hashMap.put(string, d);
        }
        return hashMap;
    }

    public int findRow(String string) throws IllegalArgumentException {
        int n = -1;
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            if (!this.getValueAsString(0, i).equals(string)) continue;
            if (n >= 0) {
                throw new IllegalArgumentException("\"" + string + "\" is not unique");
            }
            n = i;
        }
        return n;
    }

    public int getNumberOfColumns() {
        return this._max_col + 1;
    }

    public int getNumberOfRows() {
        return this._max_row + 1;
    }

    private Map<String, E> getRow(int n) {
        return this.getRows().get("" + n);
    }

    private Map<String, Map<String, E>> getRows() {
        return this._rows;
    }

    public E getValue(int n, int n2) throws IllegalArgumentException {
        if (n2 > this.getNumberOfRows() - 1 || n2 < 0) {
            throw new IllegalArgumentException("value for row (" + n2 + ") is out of range [number of rows: " + this.getNumberOfRows() + "]");
        }
        if (n >= this.getNumberOfColumns() || n2 < 0) {
            throw new IllegalArgumentException("value for column (" + n + ") is out of range [number of columns: " + this.getNumberOfColumns() + "]");
        }
        Map<String, E> map = this.getRow(n2);
        if (map == null || map.size() < 1) {
            return null;
        }
        return map.get("" + n);
    }

    public String getValueAsString(int n, int n2) throws IllegalArgumentException {
        if (this.getValue(n, n2) != null) {
            return this.getValue(n, n2).toString();
        }
        return null;
    }

    private void init() {
        this._rows = new HashMap<String, Map<String, E>>();
        this.setMaxCol(-1);
        this.setMaxRow(-1);
    }

    public boolean isEmpty() {
        return this.getNumberOfRows() <= 0;
    }

    private void setMaxCol(int n) {
        this._max_col = n;
    }

    private void setMaxRow(int n) {
        this._max_row = n;
    }

    public void setValue(int n, int n2, E e) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("attempt to use negative values for row or column");
        }
        if (n2 > this.getNumberOfRows() - 1) {
            this.setMaxRow(n2);
        }
        if (n > this.getNumberOfColumns() - 1) {
            this.setMaxCol(n);
        }
        String string = "" + n2;
        Map<Object, Object> map = null;
        if (this.getRows().containsKey(string)) {
            map = this.getRows().get(string);
        } else {
            map = new HashMap();
            this.getRows().put(string, map);
        }
        map.put("" + n, e);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            for (int j = 0; j < this.getNumberOfColumns(); ++j) {
                stringBuffer.append(this.getValue(j, i));
                if (j >= this.getNumberOfColumns() - 1) continue;
                stringBuffer.append(" ");
            }
            if (i >= this.getNumberOfRows() - 1) continue;
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }
}

