/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.forester.util.EasyWriter;

public final class ForesterUtil {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String JAVA_VENDOR = System.getProperty("java.vendor");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final Pattern PARANTHESESABLE_NH_CHARS_PATTERN = Pattern.compile("[(),;\\s]");
    public static final double ZERO_DIFF = 1.0E-9;
    public static final BigDecimal NULL_BD = new BigDecimal(0);
    public static final NumberFormat FORMATTER_9;
    public static final NumberFormat FORMATTER_6;
    public static final NumberFormat FORMATTER_06;
    public static final NumberFormat FORMATTER_3;

    private ForesterUtil() {
    }

    public static final void appendSeparatorIfNotEmpty(StringBuffer stringBuffer, char c) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(c);
        }
    }

    public static final String getForesterLibraryInformation() {
        return "forester 1.005 (120629)";
    }

    public static boolean seqIsLikelyToBeAa(String string) {
        String string2 = string.toLowerCase();
        return string2.indexOf(114) > -1 || string2.indexOf(100) > -1 || string2.indexOf(101) > -1 || string2.indexOf(113) > -1 || string2.indexOf(104) > -1 || string2.indexOf(107) > -1 || string2.indexOf(119) > -1 || string2.indexOf(115) > -1 || string2.indexOf(109) > -1 || string2.indexOf(112) > -1 || string2.indexOf(118) > -1;
    }

    public static final Color calcColor(double d, double d2, double d3, Color color, Color color2) {
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        double d4 = ForesterUtil.calculateColorFactor(d, d3, d2);
        int n = ForesterUtil.calculateColorComponent(color.getRed(), color2.getRed(), d4);
        int n2 = ForesterUtil.calculateColorComponent(color.getGreen(), color2.getGreen(), d4);
        int n3 = ForesterUtil.calculateColorComponent(color.getBlue(), color2.getBlue(), d4);
        return new Color(n, n2, n3);
    }

    public static final Color calcColor(double d, double d2, double d3, double d4, Color color, Color color2, Color color3) {
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        if (d < d4) {
            double d5 = ForesterUtil.calculateColorFactor(d, d4, d2);
            int n = ForesterUtil.calculateColorComponent(color.getRed(), color3.getRed(), d5);
            int n2 = ForesterUtil.calculateColorComponent(color.getGreen(), color3.getGreen(), d5);
            int n3 = ForesterUtil.calculateColorComponent(color.getBlue(), color3.getBlue(), d5);
            return new Color(n, n2, n3);
        }
        if (d > d4) {
            double d6 = ForesterUtil.calculateColorFactor(d, d3, d4);
            int n = ForesterUtil.calculateColorComponent(color3.getRed(), color2.getRed(), d6);
            int n4 = ForesterUtil.calculateColorComponent(color3.getGreen(), color2.getGreen(), d6);
            int n5 = ForesterUtil.calculateColorComponent(color3.getBlue(), color2.getBlue(), d6);
            return new Color(n, n4, n5);
        }
        return color3;
    }

    private static final int calculateColorComponent(double d, double d2, double d3) {
        return (int)(d + d3 * (d2 - d) / 255.0);
    }

    private static final double calculateColorFactor(double d, double d2, double d3) {
        return 255.0 * (d - d3) / (d2 - d3);
    }

    public static final String collapseWhiteSpace(String string) {
        return string.replaceAll("[\\s]+", " ");
    }

    public static final void collection2file(File file, Collection<?> collection, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        ForesterUtil.collection2writer(bufferedWriter, collection, string);
        ((Writer)bufferedWriter).close();
    }

    public static final void collection2writer(Writer writer, Collection<?> collection, String string) throws IOException {
        boolean bl = true;
        for (Object obj : collection) {
            if (!bl) {
                writer.write(string);
            } else {
                bl = false;
            }
            writer.write(obj.toString());
        }
    }

    public static final String colorToHex(Color color) {
        String string = Integer.toHexString(color.getRGB());
        return string.substring(2, string.length());
    }

    public static synchronized void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static final int countChars(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static final BufferedWriter createBufferedWriter(File file) throws IOException {
        if (file.exists()) {
            throw new IOException("[" + file + "] already exists");
        }
        return new BufferedWriter(new FileWriter(file));
    }

    public static final EasyWriter createEasyWriter(File file) throws IOException {
        return new EasyWriter(ForesterUtil.createBufferedWriter(file));
    }

    public static final BufferedWriter createEasyWriter(String string) throws IOException {
        return ForesterUtil.createEasyWriter(ForesterUtil.createFileForWriting(string));
    }

    public static final BufferedWriter createBufferedWriter(String string) throws IOException {
        return new BufferedWriter(new FileWriter(ForesterUtil.createFileForWriting(string)));
    }

    public static final File createFileForWriting(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            throw new IOException("[" + string + "] already exists");
        }
        return file;
    }

    public static void fatalError(String string, String string2) {
        System.err.println();
        System.err.println("[" + string + "] > " + string2);
        System.err.println();
        System.exit(-1);
    }

    public static String[] file2array(File file) throws IOException {
        List<String> list = ForesterUtil.file2list(file);
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (String string : list) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public static final List<String> file2list(File file) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
            for (String string2 : ForesterUtil.splitString(string)) {
                arrayList.add(string2);
            }
        }
        bufferedReader.close();
        return arrayList;
    }

    public static final SortedSet<String> file2set(File file) throws IOException {
        String string;
        TreeSet<String> treeSet = new TreeSet<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
            for (String string2 : ForesterUtil.splitString(string)) {
                treeSet.add(string2);
            }
        }
        bufferedReader.close();
        return treeSet;
    }

    public static final String getCurrentDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    public static final String getFileSeparator() {
        return FILE_SEPARATOR;
    }

    public static final String getFirstLine(Object object) throws FileNotFoundException, IOException {
        Object object2;
        BufferedReader bufferedReader = null;
        if (object instanceof File) {
            object2 = (File)object;
            if (!((File)object2).exists()) {
                throw new IOException("[" + ((File)object2).getAbsolutePath() + "] does not exist");
            }
            if (!((File)object2).isFile()) {
                throw new IOException("[" + ((File)object2).getAbsolutePath() + "] is not a file");
            }
            if (!((File)object2).canRead()) {
                throw new IOException("[" + ((File)object2).getAbsolutePath() + "] is not a readable");
            }
            bufferedReader = new BufferedReader(new FileReader((File)object2));
        } else if (object instanceof InputStream) {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        } else if (object instanceof String) {
            bufferedReader = new BufferedReader(new StringReader((String)object));
        } else if (object instanceof StringBuffer) {
            bufferedReader = new BufferedReader(new StringReader(object.toString()));
        } else if (object instanceof URL) {
            bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
        } else {
            throw new IllegalArgumentException("dont know how to read [" + object.getClass() + "]");
        }
        while ((object2 = bufferedReader.readLine()) != null) {
            if (ForesterUtil.isEmpty((String)(object2 = ((String)object2).trim()))) continue;
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            return object2;
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        return object2;
    }

    public static final String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static final void increaseCountingMap(Map<String, Integer> map, String string) {
        if (!map.containsKey(string)) {
            map.put(string, 1);
        } else {
            map.put(string, map.get(string) + 1);
        }
    }

    public static final boolean isContainsParanthesesableNhCharacter(String string) {
        return PARANTHESESABLE_NH_CHARS_PATTERN.matcher(string).find();
    }

    public static final boolean isEmpty(List<?> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (Object obj : list) {
            if (obj == null) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEmpty(Set<?> set) {
        if (set == null || set.isEmpty()) {
            return true;
        }
        for (Object obj : set) {
            if (obj == null) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.length() < 1;
    }

    public static final boolean isEqual(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-9;
    }

    public static final boolean isEven(int n) {
        return n % 2 == 0;
    }

    public static final boolean isIntersecting(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length < 1 || stringArray2.length < 1) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            for (int j = 0; j < stringArray2.length; ++j) {
                if (string == null || stringArray2[j] == null || !string.equals(stringArray2[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static final double isLargerOrEqualToZero(double d) {
        if (d > 0.0) {
            return d;
        }
        return 0.0;
    }

    public static final boolean isNull(BigDecimal bigDecimal) {
        return bigDecimal == null || bigDecimal.compareTo(NULL_BD) == 0;
    }

    public static final String isReadableFile(File file) {
        if (!file.exists()) {
            return "file [" + file + "] does not exist";
        }
        if (file.isDirectory()) {
            return "[" + file + "] is a directory";
        }
        if (!file.isFile()) {
            return "[" + file + "] is not a file";
        }
        if (!file.canRead()) {
            return "file [" + file + "] is not readable";
        }
        if (file.length() < 1L) {
            return "file [" + file + "] is empty";
        }
        return null;
    }

    public static final String isReadableFile(String string) {
        return ForesterUtil.isReadableFile(new File(string));
    }

    public static final String isWritableFile(File file) {
        if (file.isDirectory()) {
            return "[" + file + "] is a directory";
        }
        if (file.exists()) {
            return "[" + file + "] already exists";
        }
        return null;
    }

    public static final int limitRangeForColor(int n) {
        if (n > 255) {
            n = 255;
        } else if (n < 0) {
            n = 0;
        }
        return n;
    }

    public static final SortedMap<Object, Integer> listToSortedCountsMap(List list) {
        TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>();
        for (Object e : list) {
            if (!treeMap.containsKey(e)) {
                treeMap.put(e, 1);
                continue;
            }
            treeMap.put(e, (Integer)treeMap.get(e) + 1);
        }
        return treeMap;
    }

    public static final void map2file(File file, Map<?, ?> map, String string, String string2) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        ForesterUtil.map2writer(bufferedWriter, map, string, string2);
        ((Writer)bufferedWriter).close();
    }

    public static final void map2writer(Writer writer, Map<?, ?> map, String string, String string2) throws IOException {
        boolean bl = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!bl) {
                writer.write(string2);
            } else {
                bl = false;
            }
            writer.write(entry.getKey().toString());
            writer.write(string);
            writer.write(entry.getValue().toString());
        }
    }

    public static final StringBuffer mapToStringBuffer(Map map, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object k : map.keySet()) {
            stringBuffer.append(k.toString());
            stringBuffer.append(string);
            stringBuffer.append(map.get(k).toString());
            stringBuffer.append(ForesterUtil.getLineSeparator());
        }
        return stringBuffer;
    }

    public static final String normalizeString(String string, int n, boolean bl, char c) {
        if (string.length() > n) {
            return string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer(n - string.length());
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuffer.append(c);
        }
        if (bl) {
            return stringBuffer + string;
        }
        return string + stringBuffer;
    }

    public static final BufferedReader obtainReader(Object object) throws IOException, FileNotFoundException {
        BufferedReader bufferedReader = null;
        if (object instanceof File) {
            File file = (File)object;
            if (!file.exists()) {
                throw new IOException("\"" + file.getAbsolutePath() + "\" does not exist");
            }
            if (!file.isFile()) {
                throw new IOException("\"" + file.getAbsolutePath() + "\" is not a file");
            }
            if (!file.canRead()) {
                throw new IOException("\"" + file.getAbsolutePath() + "\" is not a readable");
            }
            bufferedReader = new BufferedReader(new FileReader(file));
        } else if (object instanceof InputStream) {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        } else if (object instanceof String) {
            bufferedReader = new BufferedReader(new StringReader((String)object));
        } else if (object instanceof StringBuffer) {
            bufferedReader = new BufferedReader(new StringReader(object.toString()));
        } else {
            throw new IllegalArgumentException("attempt to parse object of type [" + object.getClass() + "] (can only parse objects of type File, InputStream, String, or StringBuffer)");
        }
        return bufferedReader;
    }

    public static final StringBuffer pad(double d, int n, char c, boolean bl) {
        return ForesterUtil.pad(new StringBuffer(d + ""), n, c, bl);
    }

    public static final StringBuffer pad(String string, int n, char c, boolean bl) {
        return ForesterUtil.pad(new StringBuffer(string), n, c, bl);
    }

    public static final StringBuffer pad(StringBuffer stringBuffer, int n, char c, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = n - stringBuffer.length();
        if (n2 < 1) {
            return new StringBuffer(stringBuffer.substring(0, n));
        }
        for (int i = 0; i < n2; ++i) {
            stringBuffer2.append(c);
        }
        if (bl) {
            return stringBuffer2.append(stringBuffer);
        }
        return stringBuffer.append(stringBuffer2);
    }

    public static final double parseDouble(String string) throws ParseException {
        if (ForesterUtil.isEmpty(string)) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    public static final int parseInt(String string) throws ParseException {
        if (ForesterUtil.isEmpty(string)) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static final void printArray(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            System.out.println("[" + i + "]=" + objectArray[i]);
        }
    }

    public static final void printCountingMap(Map<String, Integer> map) {
        for (String string : map.keySet()) {
            System.out.println(string + ": " + map.get(string));
        }
    }

    public static final void printErrorMessage(String string, String string2) {
        System.out.println("[" + string + "] > error: " + string2);
    }

    public static final void printProgramInformation(String string, String string2, String string3) {
        int n = string.length() + string2.length() + string3.length() + 4;
        System.out.println();
        System.out.println(string + " " + string2 + " (" + string3 + ")");
        for (int i = 0; i < n; ++i) {
            System.out.print("_");
        }
        System.out.println();
    }

    public static final void printProgramInformation(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8 = new String(string);
        if (!ForesterUtil.isEmpty(string2)) {
            string8 = string8 + " - " + string2;
        }
        int n = string8.length() + string3.length() + string4.length() + 4;
        System.out.println();
        System.out.println(string8 + " " + string3 + " (" + string4 + ")");
        for (int i = 0; i < n; ++i) {
            System.out.print("_");
        }
        System.out.println();
        System.out.println();
        System.out.println("WWW     : " + string6);
        System.out.println("Contact : " + string5);
        if (!ForesterUtil.isEmpty(string7)) {
            System.out.println("Based on: " + string7);
        }
        if (!ForesterUtil.isEmpty(JAVA_VERSION) && !ForesterUtil.isEmpty(JAVA_VENDOR)) {
            System.out.println();
            System.out.println("[running on Java " + JAVA_VERSION + " " + JAVA_VENDOR + "]");
        }
        System.out.println();
    }

    public static final void printProgramInformation(String string, String string2, String string3, String string4, String string5) {
        ForesterUtil.printProgramInformation(string, null, string2, string3, string4, string5, null);
    }

    public static final void printWarningMessage(String string, String string2) {
        System.out.println("[" + string + "] > warning: " + string2);
    }

    public static final void programMessage(String string, String string2) {
        System.out.println("[" + string + "] > " + string2);
    }

    public static final String removeSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n > 1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static final String removeWhiteSpace(String string) {
        for (int i = 0; i <= string.length() - 1; ++i) {
            if (string.charAt(i) != ' ' && string.charAt(i) != '\t' && string.charAt(i) != '\n' && string.charAt(i) != '\r') continue;
            string = string.substring(0, i) + string.substring(i + 1);
            --i;
        }
        return string;
    }

    public static final String replaceIllegalNhCharacters(String string) {
        if (string == null) {
            return "";
        }
        return string.trim().replaceAll("[\\[\\]:]+", "_");
    }

    public static final String replaceIllegalNhxCharacters(String string) {
        if (string == null) {
            return "";
        }
        return string.trim().replaceAll("[\\[\\](),:;\\s]+", "_");
    }

    public static final double round(double d, int n) {
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(n, 4);
        return bigDecimal.doubleValue();
    }

    public static final int roundToInt(double d) {
        return (int)(d + 0.5);
    }

    public static final int roundToInt(float f) {
        return (int)(f + 0.5f);
    }

    public static final short roundToShort(double d) {
        return (short)(d + 0.5);
    }

    public static final String sanitizeString(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    private static final String[] splitString(String string) {
        return string.split("[\\s;,]+");
    }

    public static final String stringArrayToString(String[] stringArray) {
        return ForesterUtil.stringArrayToString(stringArray, ", ");
    }

    public static final String stringArrayToString(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(stringArray[i] + string);
            }
            stringBuilder.append(stringArray[stringArray.length - 1]);
        }
        return stringBuilder.toString();
    }

    public static final String[] stringListToArray(List<String> list) {
        if (list != null) {
            String[] stringArray = new String[list.size()];
            int n = 0;
            for (String string : list) {
                stringArray[n++] = string;
            }
            return stringArray;
        }
        return null;
    }

    public static final String stringListToString(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size() - 1; ++i) {
                stringBuilder.append(list.get(i) + string);
            }
            stringBuilder.append(list.get(list.size() - 1));
        }
        return stringBuilder.toString();
    }

    public static final String[] stringSetToArray(Set<String> set) {
        String[] stringArray = new String[set.size()];
        int n = 0;
        for (String string : set) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public static final void unexpectedFatalError(String string, Exception exception) {
        System.err.println();
        System.err.println("[" + string + "] > unexpected error (Should not have occured! Please contact program author(s).)");
        exception.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String string, String string2) {
        System.err.println();
        System.err.println("[" + string + "] > unexpected error. Should not have occured! Please contact program author(s).");
        System.err.println(string2);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String string, String string2, Exception exception) {
        System.err.println();
        System.err.println("[" + string + "] > unexpected error. Should not have occured! Please contact program author(s).");
        System.err.println(string2);
        exception.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final String wordWrap(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) == ' ') {
                n3 = i;
            }
            if (stringBuilder.charAt(i) == '\n') {
                n3 = -1;
                n2 = i + 1;
            }
            if (i <= n2 + n - 1) continue;
            if (n3 != -1) {
                stringBuilder.setCharAt(n3, '\n');
                n2 = n3 + 1;
                n3 = -1;
                continue;
            }
            stringBuilder.insert(i, '\n');
            n2 = i + 1;
        }
        return stringBuilder.toString();
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        FORMATTER_9 = new DecimalFormat("#.#########", decimalFormatSymbols);
        FORMATTER_6 = new DecimalFormat("#.######", decimalFormatSymbols);
        FORMATTER_06 = new DecimalFormat("0.######", decimalFormatSymbols);
        FORMATTER_3 = new DecimalFormat("#.###", decimalFormatSymbols);
    }
}

