/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.seqdb;

import java.util.List;
import org.forester.util.ForesterUtil;
import org.forester.ws.seqdb.DatabaseTools;
import org.forester.ws.seqdb.SequenceDatabaseEntry;

public final class UniProtEntry
implements SequenceDatabaseEntry {
    private String _ac;
    private String _rec_name;
    private String _os_scientific_name;
    private String _tax_id;
    private String _symbol;

    private UniProtEntry() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static SequenceDatabaseEntry createInstanceFromPlainText(List<String> list) {
        UniProtEntry uniProtEntry = new UniProtEntry();
        for (String string : list) {
            if (string.startsWith("AC")) {
                uniProtEntry.setAc(DatabaseTools.extract(string, "AC", ";"));
                continue;
            }
            if (string.startsWith("DE")) {
                if (string.indexOf("RecName:") <= 0 || string.indexOf("Full=") <= 0) continue;
                uniProtEntry.setRecName(DatabaseTools.extract(string, "Full=", ";"));
                continue;
            }
            if (string.startsWith("GN")) {
                if (string.indexOf("Name=") <= 0) continue;
                uniProtEntry.setSymbol(DatabaseTools.extract(string, "Name=", ";"));
                continue;
            }
            if (string.startsWith("OS")) {
                if (string.indexOf("(") > 0) {
                    uniProtEntry.setOsScientificName(DatabaseTools.extract(string, "OS", "("));
                    continue;
                }
                uniProtEntry.setOsScientificName(DatabaseTools.extract(string, "OS", "."));
                continue;
            }
            if (!string.startsWith("OX") || string.indexOf("NCBI_TaxID=") <= 0) continue;
            uniProtEntry.setTaxId(DatabaseTools.extract(string, "NCBI_TaxID=", ";"));
        }
        return uniProtEntry;
    }

    @Override
    public String getAccession() {
        return this._ac;
    }

    private void setAc(String string) {
        if (this._ac == null) {
            this._ac = string;
        }
    }

    @Override
    public String getSequenceName() {
        return this._rec_name;
    }

    private void setRecName(String string) {
        if (this._rec_name == null) {
            this._rec_name = string;
        }
    }

    @Override
    public String getTaxonomyScientificName() {
        return this._os_scientific_name;
    }

    private void setOsScientificName(String string) {
        if (this._os_scientific_name == null) {
            this._os_scientific_name = string;
        }
    }

    @Override
    public String getTaxonomyIdentifier() {
        return this._tax_id;
    }

    private void setTaxId(String string) {
        if (this._tax_id == null) {
            this._tax_id = string;
        }
    }

    @Override
    public String getSequenceSymbol() {
        return this._symbol;
    }

    private void setSymbol(String string) {
        if (this._symbol == null) {
            this._symbol = string;
        }
    }

    @Override
    public boolean isEmpty() {
        return ForesterUtil.isEmpty(this.getAccession()) && ForesterUtil.isEmpty(this.getSequenceName()) && ForesterUtil.isEmpty(this.getTaxonomyScientificName()) && ForesterUtil.isEmpty(this.getTaxonomyIdentifier()) && ForesterUtil.isEmpty(this.getSequenceSymbol());
    }

    @Override
    public String getProvider() {
        return "uniprot";
    }
}

